/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.json;

import com.dslplatform.json.JsonReader;
import com.dslplatform.json.JsonWriter;
import com.dslplatform.json.Nullable;
import com.dslplatform.json.NumberConverter;
import com.dslplatform.json.SerializationException;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;

public abstract class JavaTimeConverter {
    public static final LocalDateTime MIN_LOCAL_DATE_TIME = LocalDateTime.of(1, 1, 1, 0, 0, 0, 0);
    public static final OffsetDateTime MIN_DATE_TIME_UTC = OffsetDateTime.of(MIN_LOCAL_DATE_TIME, ZoneOffset.UTC);
    public static final LocalDate MIN_LOCAL_DATE = LocalDate.of(1, 1, 1);
    public static final LocalTime MIN_LOCAL_TIME = LocalTime.of(0, 0);
    public static final OffsetTime MIN_TIME_UTC = OffsetTime.of(LocalTime.of(0, 0), ZoneOffset.UTC);
    public static final JsonReader.ReadObject<LocalDate> LOCAL_DATE_READER = new JsonReader.ReadObject<LocalDate>(){

        @Nullable
        public LocalDate read(JsonReader reader) throws IOException {
            return reader.wasNull() ? null : JavaTimeConverter.deserializeLocalDate(reader);
        }
    };
    public static final JsonWriter.WriteObject<LocalDate> LOCAL_DATE_WRITER = new JsonWriter.WriteObject<LocalDate>(){

        public void write(JsonWriter writer, @Nullable LocalDate value) {
            JavaTimeConverter.serializeNullable(value, writer);
        }
    };
    public static final JsonReader.ReadObject<LocalTime> LOCAL_TIME_READER = new JsonReader.ReadObject<LocalTime>(){

        @Nullable
        public LocalTime read(JsonReader reader) throws IOException {
            return reader.wasNull() ? null : JavaTimeConverter.deserializeLocalTime(reader);
        }
    };
    public static final JsonWriter.WriteObject<LocalTime> LOCAL_TIME_WRITER = new JsonWriter.WriteObject<LocalTime>(){

        public void write(JsonWriter writer, @Nullable LocalTime value) {
            JavaTimeConverter.serializeNullable(value, writer);
        }
    };
    public static final JsonReader.ReadObject<OffsetTime> OFFSET_TIME_READER = new JsonReader.ReadObject<OffsetTime>(){

        @Nullable
        public OffsetTime read(JsonReader reader) throws IOException {
            return reader.wasNull() ? null : JavaTimeConverter.deserializeOffsetTime(reader);
        }
    };
    public static final JsonWriter.WriteObject<OffsetTime> OFFSET_TIME_WRITER = new JsonWriter.WriteObject<OffsetTime>(){

        public void write(JsonWriter writer, @Nullable OffsetTime value) {
            JavaTimeConverter.serializeNullable(value, writer);
        }
    };
    public static final JsonReader.ReadObject<OffsetDateTime> DATE_TIME_READER = new JsonReader.ReadObject<OffsetDateTime>(){

        @Nullable
        public OffsetDateTime read(JsonReader reader) throws IOException {
            return reader.wasNull() ? null : JavaTimeConverter.deserializeDateTime(reader);
        }
    };
    public static final JsonWriter.WriteObject<OffsetDateTime> DATE_TIME_WRITER = new JsonWriter.WriteObject<OffsetDateTime>(){

        public void write(JsonWriter writer, @Nullable OffsetDateTime value) {
            JavaTimeConverter.serializeNullable(value, writer);
        }
    };
    public static final JsonReader.ReadObject<LocalDateTime> LOCAL_DATE_TIME_READER = new JsonReader.ReadObject<LocalDateTime>(){

        @Nullable
        public LocalDateTime read(JsonReader reader) throws IOException {
            return reader.wasNull() ? null : JavaTimeConverter.deserializeLocalDateTime(reader);
        }
    };
    public static final JsonWriter.WriteObject<LocalDateTime> LOCAL_DATE_TIME_WRITER = new JsonWriter.WriteObject<LocalDateTime>(){

        public void write(JsonWriter writer, @Nullable LocalDateTime value) {
            JavaTimeConverter.serializeNullable(value, writer);
        }
    };
    public static final JsonReader.ReadObject<ZonedDateTime> ZONED_DATE_TIME_READER = new JsonReader.ReadObject<ZonedDateTime>(){

        @Nullable
        public ZonedDateTime read(JsonReader reader) throws IOException {
            return reader.wasNull() ? null : JavaTimeConverter.deserializeDateTime(reader).toZonedDateTime();
        }
    };
    public static final JsonWriter.WriteObject<ZonedDateTime> ZONED_DATE_TIME_WRITER = new JsonWriter.WriteObject<ZonedDateTime>(){

        public void write(JsonWriter writer, @Nullable ZonedDateTime value) {
            if (value == null) {
                writer.writeNull();
            } else {
                JavaTimeConverter.serialize(value.toOffsetDateTime(), writer);
            }
        }
    };

    public static void serializeNullable(@Nullable OffsetDateTime value, JsonWriter sw) {
        if (value == null) {
            sw.writeNull();
        } else {
            JavaTimeConverter.serialize(value, sw);
        }
    }

    public static void serializeNullable(@Nullable LocalTime value, JsonWriter sw) {
        if (value == null) {
            sw.writeNull();
        } else {
            JavaTimeConverter.serialize(value, sw);
        }
    }

    public static void serializeNullable(@Nullable OffsetTime value, JsonWriter sw) {
        if (value == null) {
            sw.writeNull();
        } else {
            JavaTimeConverter.serialize(value, sw);
        }
    }

    public static void serializeNullable(@Nullable LocalDateTime value, JsonWriter sw) {
        if (value == null) {
            sw.writeNull();
        } else {
            JavaTimeConverter.serialize(value, sw);
        }
    }

    public static void serialize(OffsetDateTime value, JsonWriter sw) {
        int year = value.getYear();
        if (year < 0) {
            throw new SerializationException("Negative dates are not supported.");
        }
        if (year > 9999) {
            sw.writeByte((byte)34);
            sw.writeAscii(value.toString());
            sw.writeByte((byte)34);
            return;
        }
        byte[] buf = sw.ensureCapacity(32);
        int pos = sw.size();
        buf[pos] = 34;
        NumberConverter.write4((int)year, (byte[])buf, (int)(pos + 1));
        buf[pos + 5] = 45;
        NumberConverter.write2((int)value.getMonthValue(), (byte[])buf, (int)(pos + 6));
        buf[pos + 8] = 45;
        NumberConverter.write2((int)value.getDayOfMonth(), (byte[])buf, (int)(pos + 9));
        buf[pos + 11] = 84;
        NumberConverter.write2((int)value.getHour(), (byte[])buf, (int)(pos + 12));
        buf[pos + 14] = 58;
        NumberConverter.write2((int)value.getMinute(), (byte[])buf, (int)(pos + 15));
        buf[pos + 17] = 58;
        NumberConverter.write2((int)value.getSecond(), (byte[])buf, (int)(pos + 18));
        int nano = value.getNano();
        if (nano != 0) {
            int end = JavaTimeConverter.writeNano(buf, pos + 20, nano);
            JavaTimeConverter.writeTimezone(end + 20, value.getOffset(), sw);
        } else {
            JavaTimeConverter.writeTimezone(20, value.getOffset(), sw);
        }
    }

    private static int writeNano(byte[] buf, int offset, int nano) {
        int end;
        buf[offset] = 46;
        int div = nano / 1000;
        int div2 = div / 1000;
        int rem1 = nano - div * 1000;
        if (rem1 != 0) {
            NumberConverter.write3((int)div2, (byte[])buf, (int)(offset + 1));
            NumberConverter.write3((int)(div - div2 * 1000), (byte[])buf, (int)(offset + 4));
            NumberConverter.write3((int)rem1, (byte[])buf, (int)(offset + 7));
            end = 10;
        } else {
            int rem2 = div - div2 * 1000;
            if (rem2 != 0) {
                NumberConverter.write3((int)div2, (byte[])buf, (int)(offset + 1));
                NumberConverter.write3((int)rem2, (byte[])buf, (int)(offset + 4));
                end = 7;
            } else {
                NumberConverter.write3((int)div2, (byte[])buf, (int)(offset + 1));
                end = 4;
            }
        }
        if (buf[end + offset - 1] == 48) {
            --end;
        }
        if (buf[end + offset - 1] == 48) {
            --end;
        }
        return end;
    }

    public static void serialize(LocalTime value, JsonWriter sw) {
        byte[] buf = sw.ensureCapacity(22);
        int pos = sw.size();
        buf[pos] = 34;
        NumberConverter.write2((int)value.getHour(), (byte[])buf, (int)(pos + 1));
        buf[pos + 3] = 58;
        NumberConverter.write2((int)value.getMinute(), (byte[])buf, (int)(pos + 4));
        buf[pos + 6] = 58;
        NumberConverter.write2((int)value.getSecond(), (byte[])buf, (int)(pos + 7));
        int nano = value.getNano();
        if (nano != 0) {
            int end = JavaTimeConverter.writeNano(buf, pos + 9, nano);
            buf[pos + 9 + end] = 34;
            sw.advance(10 + end);
        } else {
            buf[pos + 9] = 34;
            sw.advance(10);
        }
    }

    public static void serialize(OffsetTime value, JsonWriter sw) {
        byte[] buf = sw.ensureCapacity(22);
        int pos = sw.size();
        buf[pos] = 34;
        NumberConverter.write2((int)value.getHour(), (byte[])buf, (int)(pos + 1));
        buf[pos + 3] = 58;
        NumberConverter.write2((int)value.getMinute(), (byte[])buf, (int)(pos + 4));
        buf[pos + 6] = 58;
        NumberConverter.write2((int)value.getSecond(), (byte[])buf, (int)(pos + 7));
        int nano = value.getNano();
        if (nano != 0) {
            int end = JavaTimeConverter.writeNano(buf, pos + 9, nano);
            JavaTimeConverter.writeTimezone(end + 9, value.getOffset(), sw);
        } else {
            JavaTimeConverter.writeTimezone(9, value.getOffset(), sw);
        }
    }

    public static void serialize(LocalDateTime value, JsonWriter sw) {
        int year = value.getYear();
        if (year < 0) {
            throw new SerializationException("Negative dates are not supported.");
        }
        if (year > 9999) {
            sw.writeByte((byte)34);
            sw.writeAscii(value.toString());
            sw.writeByte((byte)34);
            return;
        }
        byte[] buf = sw.ensureCapacity(32);
        int pos = sw.size();
        buf[pos] = 34;
        NumberConverter.write4((int)year, (byte[])buf, (int)(pos + 1));
        buf[pos + 5] = 45;
        NumberConverter.write2((int)value.getMonthValue(), (byte[])buf, (int)(pos + 6));
        buf[pos + 8] = 45;
        NumberConverter.write2((int)value.getDayOfMonth(), (byte[])buf, (int)(pos + 9));
        buf[pos + 11] = 84;
        NumberConverter.write2((int)value.getHour(), (byte[])buf, (int)(pos + 12));
        buf[pos + 14] = 58;
        NumberConverter.write2((int)value.getMinute(), (byte[])buf, (int)(pos + 15));
        buf[pos + 17] = 58;
        NumberConverter.write2((int)value.getSecond(), (byte[])buf, (int)(pos + 18));
        int nano = value.getNano();
        if (nano != 0) {
            int end = JavaTimeConverter.writeNano(buf, pos + 20, nano);
            buf[pos + 20 + end] = 34;
            sw.advance(end + 21);
        } else {
            buf[pos + 20] = 34;
            sw.advance(21);
        }
    }

    private static void writeTimezone(int position, ZoneOffset zone, JsonWriter sw) {
        sw.advance(position);
        sw.writeAscii(zone.getId());
        sw.writeByte((byte)34);
    }

    private static boolean allDigits(char[] buffer, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (buffer[i] >= '0' && buffer[i] <= '9') continue;
            return false;
        }
        return true;
    }

    public static OffsetDateTime deserializeDateTime(JsonReader reader) throws IOException {
        char[] tmp = reader.readSimpleQuote();
        int len = reader.getCurrentIndex() - reader.getTokenStart() - 1;
        if (len > 19 && len < 31 && tmp[len - 1] == 'Z' && tmp[4] == '-' && tmp[7] == '-' && (tmp[10] == 'T' || tmp[10] == 't' || tmp[10] == ' ') && tmp[13] == ':' && tmp[16] == ':' && JavaTimeConverter.allDigits(tmp, 20, len - 1)) {
            int year = NumberConverter.read4((char[])tmp, (int)0);
            int month = NumberConverter.read2((char[])tmp, (int)5);
            int day = NumberConverter.read2((char[])tmp, (int)8);
            int hour = NumberConverter.read2((char[])tmp, (int)11);
            int min = NumberConverter.read2((char[])tmp, (int)14);
            int sec = NumberConverter.read2((char[])tmp, (int)17);
            if (tmp[19] == '.') {
                int nanos = JavaTimeConverter.readNanos(tmp, len - 1, 20);
                return OffsetDateTime.of(year, month, day, hour, min, sec, nanos, ZoneOffset.UTC);
            }
            return OffsetDateTime.of(year, month, day, hour, min, sec, 0, ZoneOffset.UTC);
        }
        if (len > 22 && len < 36 && tmp[len - 3] == ':' && (tmp[len - 6] == '+' || tmp[len - 6] == '-') && tmp[4] == '-' && tmp[7] == '-' && (tmp[10] == 'T' || tmp[10] == 't' || tmp[10] == ' ') && tmp[13] == ':' && tmp[16] == ':' && JavaTimeConverter.allDigits(tmp, len - 2, len) && JavaTimeConverter.allDigits(tmp, len - 5, len - 3)) {
            int year = NumberConverter.read4((char[])tmp, (int)0);
            int month = NumberConverter.read2((char[])tmp, (int)5);
            int day = NumberConverter.read2((char[])tmp, (int)8);
            int hour = NumberConverter.read2((char[])tmp, (int)11);
            int min = NumberConverter.read2((char[])tmp, (int)14);
            int sec = NumberConverter.read2((char[])tmp, (int)17);
            int offHour = NumberConverter.read2((char[])tmp, (int)(len - 5));
            int offMin = NumberConverter.read2((char[])tmp, (int)(len - 2));
            boolean isPositiveOffset = tmp[len - 6] == '+';
            ZoneOffset offset = ZoneOffset.ofHoursMinutes(isPositiveOffset ? offHour : -offHour, isPositiveOffset ? offMin : -offMin);
            if (tmp[19] == '.') {
                int nanos = JavaTimeConverter.readNanos(tmp, len - 6, 20);
                return OffsetDateTime.of(year, month, day, hour, min, sec, nanos, offset);
            }
            return OffsetDateTime.of(year, month, day, hour, min, sec, 0, offset);
        }
        return OffsetDateTime.parse(new String(tmp, 0, len));
    }

    private static int readNanos(char[] tmp, int len, int offset) {
        switch (len - offset) {
            case 1: {
                return 100000000 * (tmp[offset] - 48);
            }
            case 2: {
                return 100000000 * (tmp[offset] - 48) + 10000000 * (tmp[offset + 1] - 48);
            }
            case 3: {
                return 100000000 * (tmp[offset] - 48) + 10000000 * (tmp[offset + 1] - 48) + 1000000 * (tmp[offset + 2] - 48);
            }
            case 4: {
                return 100000000 * (tmp[offset] - 48) + 10000000 * (tmp[offset + 1] - 48) + 1000000 * (tmp[offset + 2] - 48) + 100000 * (tmp[offset + 3] - 48);
            }
            case 5: {
                return 100000000 * (tmp[offset] - 48) + 10000000 * (tmp[offset + 1] - 48) + 1000000 * (tmp[offset + 2] - 48) + 100000 * (tmp[offset + 3] - 48) + 10000 * (tmp[offset + 4] - 48);
            }
            case 6: {
                return 100000000 * (tmp[offset] - 48) + 10000000 * (tmp[offset + 1] - 48) + 1000000 * (tmp[offset + 2] - 48) + 100000 * (tmp[offset + 3] - 48) + 10000 * (tmp[offset + 4] - 48) + 1000 * (tmp[offset + 5] - 48);
            }
            case 7: {
                return 100000000 * (tmp[offset] - 48) + 10000000 * (tmp[offset + 1] - 48) + 1000000 * (tmp[offset + 2] - 48) + 100000 * (tmp[offset + 3] - 48) + 10000 * (tmp[offset + 4] - 48) + 1000 * (tmp[offset + 5] - 48) + 100 * (tmp[offset + 6] - 48);
            }
            case 8: {
                return 100000000 * (tmp[offset] - 48) + 10000000 * (tmp[offset + 1] - 48) + 1000000 * (tmp[offset + 2] - 48) + 100000 * (tmp[offset + 3] - 48) + 10000 * (tmp[offset + 4] - 48) + 1000 * (tmp[offset + 5] - 48) + 100 * (tmp[offset + 6] - 48) + 10 * (tmp[offset + 7] - 48);
            }
        }
        return 100000000 * (tmp[offset] - 48) + 10000000 * (tmp[offset + 1] - 48) + 1000000 * (tmp[offset + 2] - 48) + 100000 * (tmp[offset + 3] - 48) + 10000 * (tmp[offset + 4] - 48) + 1000 * (tmp[offset + 5] - 48) + 100 * (tmp[offset + 6] - 48) + 10 * (tmp[offset + 7] - 48) + tmp[offset + 8] - 48;
    }

    public static LocalDateTime deserializeLocalDateTime(JsonReader reader) throws IOException {
        char[] tmp = reader.readSimpleQuote();
        int len = reader.getCurrentIndex() - reader.getTokenStart() - 1;
        if (len > 18 && len < 30 && tmp[4] == '-' && tmp[7] == '-' && (tmp[10] == 'T' || tmp[10] == 't' || tmp[10] == ' ') && tmp[13] == ':' && tmp[16] == ':' && JavaTimeConverter.allDigits(tmp, 20, len)) {
            int year = NumberConverter.read4((char[])tmp, (int)0);
            int month = NumberConverter.read2((char[])tmp, (int)5);
            int day = NumberConverter.read2((char[])tmp, (int)8);
            int hour = NumberConverter.read2((char[])tmp, (int)11);
            int min = NumberConverter.read2((char[])tmp, (int)14);
            int sec = NumberConverter.read2((char[])tmp, (int)17);
            if (len > 19 && tmp[19] == '.') {
                int nanos = JavaTimeConverter.readNanos(tmp, len, 20);
                return LocalDateTime.of(year, month, day, hour, min, sec, nanos);
            }
            return LocalDateTime.of(year, month, day, hour, min, sec);
        }
        return LocalDateTime.parse(new String(tmp, 0, len));
    }

    public static LocalTime deserializeLocalTime(JsonReader reader) throws IOException {
        char[] tmp = reader.readSimpleQuote();
        int len = reader.getCurrentIndex() - reader.getTokenStart() - 1;
        if (len > 7 && tmp[2] == ':' && tmp[5] == ':' && JavaTimeConverter.allDigits(tmp, 9, len)) {
            int hour = NumberConverter.read2((char[])tmp, (int)0);
            int min = NumberConverter.read2((char[])tmp, (int)3);
            int sec = NumberConverter.read2((char[])tmp, (int)6);
            if (len > 8 && tmp[8] == '.') {
                int nanos = JavaTimeConverter.readNanos(tmp, len, 9);
                return LocalTime.of(hour, min, sec, nanos);
            }
            return LocalTime.of(hour, min, sec);
        }
        return LocalTime.parse(new String(tmp, 0, len));
    }

    public static OffsetTime deserializeOffsetTime(JsonReader reader) throws IOException {
        char[] tmp = reader.readSimpleQuote();
        int len = reader.getCurrentIndex() - reader.getTokenStart() - 1;
        if (len > 8 && len < 20 && tmp[len - 1] == 'Z' && tmp[2] == ':' && tmp[5] == ':' && JavaTimeConverter.allDigits(tmp, 9, len - 1)) {
            int hour = NumberConverter.read2((char[])tmp, (int)0);
            int min = NumberConverter.read2((char[])tmp, (int)3);
            int sec = NumberConverter.read2((char[])tmp, (int)6);
            if (tmp[8] == '.') {
                int nanos = JavaTimeConverter.readNanos(tmp, len - 1, 9);
                return OffsetTime.of(hour, min, sec, nanos, ZoneOffset.UTC);
            }
            return OffsetTime.of(hour, min, sec, 0, ZoneOffset.UTC);
        }
        if (len > 11 && len < 25 && tmp[len - 3] == ':' && (tmp[len - 6] == '+' || tmp[len - 6] == '-') && tmp[2] == ':' && tmp[5] == ':' && JavaTimeConverter.allDigits(tmp, len - 2, len) && JavaTimeConverter.allDigits(tmp, len - 5, len - 3)) {
            int hour = NumberConverter.read2((char[])tmp, (int)0);
            int min = NumberConverter.read2((char[])tmp, (int)3);
            int sec = NumberConverter.read2((char[])tmp, (int)6);
            int offHour = NumberConverter.read2((char[])tmp, (int)(len - 5));
            int offMin = NumberConverter.read2((char[])tmp, (int)(len - 2));
            boolean isPositiveOffset = tmp[len - 6] == '+';
            ZoneOffset offset = ZoneOffset.ofHoursMinutes(isPositiveOffset ? offHour : -offHour, isPositiveOffset ? offMin : -offMin);
            if (tmp[8] == '.') {
                int nanos = JavaTimeConverter.readNanos(tmp, len - 6, 9);
                return OffsetTime.of(hour, min, sec, nanos, offset);
            }
            return OffsetTime.of(hour, min, sec, 0, offset);
        }
        return OffsetTime.parse(new String(tmp, 0, len));
    }

    public static ArrayList<OffsetDateTime> deserializeDateTimeCollection(JsonReader reader) throws IOException {
        return reader.deserializeCollection(DATE_TIME_READER);
    }

    public static void deserializeDateTimeCollection(JsonReader reader, Collection<OffsetDateTime> res) throws IOException {
        reader.deserializeCollection(DATE_TIME_READER, res);
    }

    public static ArrayList<OffsetDateTime> deserializeDateTimeNullableCollection(JsonReader reader) throws IOException {
        return reader.deserializeNullableCollection(DATE_TIME_READER);
    }

    public static void deserializeDateTimeNullableCollection(JsonReader reader, Collection<OffsetDateTime> res) throws IOException {
        reader.deserializeNullableCollection(DATE_TIME_READER, res);
    }

    public static ArrayList<LocalDateTime> deserializeLocalDateTimeCollection(JsonReader reader) throws IOException {
        return reader.deserializeCollection(LOCAL_DATE_TIME_READER);
    }

    public static void deserializeLocalDateTimeCollection(JsonReader reader, Collection<LocalDateTime> res) throws IOException {
        reader.deserializeCollection(LOCAL_DATE_TIME_READER, res);
    }

    public static ArrayList<LocalDateTime> deserializeLocalDateTimeNullableCollection(JsonReader reader) throws IOException {
        return reader.deserializeNullableCollection(LOCAL_DATE_TIME_READER);
    }

    public static void deserializeLocalDateTimeNullableCollection(JsonReader reader, Collection<LocalDateTime> res) throws IOException {
        reader.deserializeNullableCollection(LOCAL_DATE_TIME_READER, res);
    }

    public static ArrayList<LocalTime> deserializeLocalTimeCollection(JsonReader reader) throws IOException {
        return reader.deserializeCollection(LOCAL_TIME_READER);
    }

    public static void deserializeLocalTimeCollection(JsonReader reader, Collection<LocalTime> res) throws IOException {
        reader.deserializeCollection(LOCAL_TIME_READER, res);
    }

    public static ArrayList<LocalTime> deserializeLocalTimeNullableCollection(JsonReader reader) throws IOException {
        return reader.deserializeNullableCollection(LOCAL_TIME_READER);
    }

    public static void deserializeLocalTimeNullableCollection(JsonReader reader, Collection<LocalTime> res) throws IOException {
        reader.deserializeNullableCollection(LOCAL_TIME_READER, res);
    }

    public static void serializeNullable(@Nullable LocalDate value, JsonWriter sw) {
        if (value == null) {
            sw.writeNull();
        } else {
            JavaTimeConverter.serialize(value, sw);
        }
    }

    public static void serialize(LocalDate value, JsonWriter sw) {
        int year = value.getYear();
        if (year < 0) {
            throw new SerializationException("Negative dates are not supported.");
        }
        if (year > 9999) {
            sw.writeByte((byte)34);
            NumberConverter.serialize((int)year, (JsonWriter)sw);
            sw.writeByte((byte)45);
            NumberConverter.serialize((int)value.getMonthValue(), (JsonWriter)sw);
            sw.writeByte((byte)45);
            NumberConverter.serialize((int)value.getDayOfMonth(), (JsonWriter)sw);
            sw.writeByte((byte)34);
            return;
        }
        byte[] buf = sw.ensureCapacity(12);
        int pos = sw.size();
        buf[pos] = 34;
        NumberConverter.write4((int)year, (byte[])buf, (int)(pos + 1));
        buf[pos + 5] = 45;
        NumberConverter.write2((int)value.getMonthValue(), (byte[])buf, (int)(pos + 6));
        buf[pos + 8] = 45;
        NumberConverter.write2((int)value.getDayOfMonth(), (byte[])buf, (int)(pos + 9));
        buf[pos + 11] = 34;
        sw.advance(12);
    }

    public static LocalDate deserializeLocalDate(JsonReader reader) throws IOException {
        char[] tmp = reader.readSimpleQuote();
        int len = reader.getCurrentIndex() - reader.getTokenStart() - 1;
        if (len == 10 && tmp[4] == '-' && tmp[7] == '-') {
            int year = NumberConverter.read4((char[])tmp, (int)0);
            int month = NumberConverter.read2((char[])tmp, (int)5);
            int day = NumberConverter.read2((char[])tmp, (int)8);
            return LocalDate.of(year, month, day);
        }
        if (len == 8 && tmp[4] == '-' && tmp[6] == '-') {
            int year = NumberConverter.read4((char[])tmp, (int)0);
            int month = tmp[5] - 48;
            int day = tmp[7] - 48;
            return LocalDate.of(year, month, day);
        }
        if (len == 9 && tmp[4] == '-') {
            int day;
            int month;
            int year = NumberConverter.read4((char[])tmp, (int)0);
            if (tmp[6] == '-') {
                month = tmp[5] - 48;
                day = NumberConverter.read2((char[])tmp, (int)7);
            } else if (tmp[7] == '-') {
                month = NumberConverter.read2((char[])tmp, (int)5);
                day = tmp[8] - 48;
            } else {
                return LocalDate.parse(new String(tmp, 0, len));
            }
            return LocalDate.of(year, month, day);
        }
        return LocalDate.parse(new String(tmp, 0, len));
    }

    public static ArrayList<LocalDate> deserializeLocalDateCollection(JsonReader reader) throws IOException {
        return reader.deserializeCollection(LOCAL_DATE_READER);
    }

    public static void deserializeLocalDateCollection(JsonReader reader, Collection<LocalDate> res) throws IOException {
        reader.deserializeCollection(LOCAL_DATE_READER, res);
    }

    public static ArrayList<LocalDate> deserializeLocalDateNullableCollection(JsonReader reader) throws IOException {
        return reader.deserializeNullableCollection(LOCAL_DATE_READER);
    }

    public static void deserializeLocalDateNullableCollection(JsonReader reader, Collection<LocalDate> res) throws IOException {
        reader.deserializeNullableCollection(LOCAL_DATE_READER, res);
    }
}

