/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.json.runtime;

import com.dslplatform.json.ConfigurationException;
import com.dslplatform.json.JsonReader;
import com.dslplatform.json.Nullable;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.concurrent.Callable;

public final class CollectionDecoder<E, T extends Collection<E>>
implements JsonReader.ReadObject<T> {
    private final Type manifest;
    private final Callable<T> newInstance;
    private final JsonReader.ReadObject<E> decoder;

    public CollectionDecoder(Type manifest, Callable<T> newInstance, JsonReader.ReadObject<E> decoder) {
        if (manifest == null) {
            throw new IllegalArgumentException("manifest can't be null");
        }
        if (newInstance == null) {
            throw new IllegalArgumentException("create can't be null");
        }
        if (decoder == null) {
            throw new IllegalArgumentException("decoder can't be null");
        }
        this.manifest = manifest;
        this.newInstance = newInstance;
        this.decoder = decoder;
    }

    @Nullable
    public T read(JsonReader reader) throws IOException {
        Collection instance;
        if (reader.wasNull()) {
            return null;
        }
        if (reader.last() != 91) {
            throw reader.newParseError("Expecting '[' for collection start");
        }
        try {
            instance = (Collection)this.newInstance.call();
        }
        catch (Exception e) {
            throw new ConfigurationException("Unable to create a new instance of " + this.manifest, (Throwable)e);
        }
        if (reader.getNextToken() == 93) {
            return (T)instance;
        }
        instance.add(this.decoder.read(reader));
        while (reader.getNextToken() == 44) {
            reader.getNextToken();
            instance.add(this.decoder.read(reader));
        }
        if (reader.last() != 93) {
            throw reader.newParseError("Expecting ']' for collection end");
        }
        return (T)instance;
    }
}

