/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.json.runtime;

import com.dslplatform.json.runtime.Generics;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

class GenericsMapper {
    private final Map<GenericsMappingKey, Type> mappings = new HashMap<GenericsMappingKey, Type>();

    GenericsMapper() {
    }

    private void analyzeType(Type tp) {
        if (tp instanceof Class) {
            this.analyze(tp, (Class)tp);
        }
        if (tp instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)tp;
            this.analyze(tp, (Class)pt.getRawType());
        }
    }

    private void addPassThroughMappings(Type superType, Class<?> subRaw) {
        if (superType instanceof ParameterizedType) {
            Type[] superActual = ((ParameterizedType)superType).getActualTypeArguments();
            Class superRaw = (Class)((ParameterizedType)superType).getRawType();
            TypeVariable<Class<T>>[] variables = superRaw.getTypeParameters();
            for (int i = 0; i < superActual.length; ++i) {
                if (!(superActual[i] instanceof TypeVariable)) continue;
                Type passThroughMapping = this.getActualType(superActual[i], subRaw);
                this.put(variables[i], superRaw, passThroughMapping);
            }
        }
    }

    public static GenericsMapper create(Type manifest, Class<?> raw) {
        GenericsMapper genericsMapper = new GenericsMapper();
        genericsMapper.analyze(manifest, raw);
        return genericsMapper;
    }

    private void analyze(Type manifest, Class<?> raw) {
        Type genericSuperclass;
        if (manifest instanceof ParameterizedType) {
            Type[] actual = ((ParameterizedType)manifest).getActualTypeArguments();
            TypeVariable<Class<?>>[] variables = raw.getTypeParameters();
            for (int i = 0; i < variables.length; ++i) {
                this.putIfAbsent(variables[i], raw, actual[i]);
                this.analyzeType(actual[i]);
            }
        }
        if ((genericSuperclass = raw.getGenericSuperclass()) != Object.class) {
            this.addPassThroughMappings(genericSuperclass, raw);
            this.analyzeType(genericSuperclass);
        }
        for (TypeVariable<Class<?>> tp : raw.getTypeParameters()) {
            Type[] bounds = tp.getBounds();
            if (bounds.length > 1) {
                throw new UnsupportedOperationException("Reflection with multiple upper bounds for type parameters not supported. Offending class: " + raw.getCanonicalName());
            }
            this.putIfAbsent(tp, raw, bounds[0]);
        }
    }

    private boolean isEmpty() {
        return this.mappings.isEmpty();
    }

    private void put(Type typeParameter, Class<?> declaringClass, Type actualType) {
        this.mappings.put(new GenericsMappingKey(typeParameter, declaringClass), actualType);
    }

    private void putIfAbsent(Type typeParameter, Class<?> declaringClass, Type actualType) {
        this.mappings.putIfAbsent(new GenericsMappingKey(typeParameter, declaringClass), actualType);
    }

    private Type getActualType(Type typeParameter, Class<?> declaringClass) {
        return this.mappings.get(new GenericsMappingKey(typeParameter, declaringClass));
    }

    Map<Type, Type> mappingByType() {
        HashMap<Type, Type> nameMapping = new HashMap<Type, Type>();
        for (Map.Entry<GenericsMappingKey, Type> kv : this.mappings.entrySet()) {
            nameMapping.put(kv.getKey().type, kv.getValue());
        }
        return nameMapping;
    }

    public Type makeConcrete(Type manifest, Class<?> raw) {
        GenericArrayType gat;
        Type newType;
        if (this.isEmpty()) {
            return manifest;
        }
        if (manifest instanceof TypeVariable) {
            return this.getActualType(manifest, raw);
        }
        if (manifest instanceof GenericArrayType && (newType = this.makeConcrete((gat = (GenericArrayType)manifest).getGenericComponentType(), raw)) instanceof Class) {
            return Array.newInstance((Class)newType, 0).getClass();
        }
        if (manifest instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)manifest;
            Type[] generics = pt.getActualTypeArguments();
            boolean changed = false;
            for (int i = 0; i < generics.length; ++i) {
                Type newType2 = this.makeConcrete(generics[i], raw);
                changed = changed || newType2 != generics[i];
                generics[i] = newType2;
            }
            if (changed) {
                return Generics.makeParameterizedType((Class)pt.getRawType(), generics);
            }
        }
        return manifest;
    }

    private static class GenericsMappingKey {
        private final Type type;
        private final Class<?> declaringClass;

        public GenericsMappingKey(Type type, Class<?> declaringClass) {
            this.type = type;
            this.declaringClass = declaringClass;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof GenericsMappingKey)) {
                return false;
            }
            GenericsMappingKey key = (GenericsMappingKey)o;
            return Objects.equals(this.type, key.type) && Objects.equals(this.declaringClass, key.declaringClass);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.declaringClass);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Key{");
            sb.append("type=").append(this.type);
            sb.append(", declaringClass=").append(this.declaringClass);
            sb.append('}');
            return sb.toString();
        }
    }
}

