/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.json.runtime;

import com.dslplatform.json.ConfigurationException;
import com.dslplatform.json.DslJson;
import com.dslplatform.json.JsonReader;
import com.dslplatform.json.JsonWriter;
import com.dslplatform.json.Nullable;
import com.dslplatform.json.runtime.DecodePropertyInfo;
import com.dslplatform.json.runtime.ExplicitDescription;
import com.dslplatform.json.runtime.FormatConverter;
import com.dslplatform.json.runtime.FormatDescription;
import com.dslplatform.json.runtime.Reflection;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.HashSet;

public final class MixinDescription<T>
implements JsonWriter.WriteObject<T>,
JsonReader.ReadObject<T>,
ExplicitDescription {
    private static final Charset utf8 = Charset.forName("UTF-8");
    private static final int defaultTypeHash = DecodePropertyInfo.calcHash("$type");
    private static final byte[] defaultObjectStart = "{\"$type\":".getBytes(utf8);
    private final int typeHash;
    private final byte[] objectStart;
    private final Type manifest;
    private final FormatDescription<T>[] descriptions;
    private final boolean alwaysSerialize;
    private final boolean exactMatch;
    private final boolean canObjectFormat;
    private final boolean canArrayFormat;
    private final String discriminator;
    private final String discriminatorError;

    public MixinDescription(Class<T> manifest, DslJson json, FormatDescription<T>[] descriptions) {
        this(manifest, json, descriptions, null);
    }

    public MixinDescription(Class<T> manifest, DslJson json, String discriminator, FormatDescription<T>[] descriptions) {
        this(manifest, json, descriptions, discriminator);
    }

    MixinDescription(Type manifest, DslJson json, FormatDescription<T>[] descriptions, @Nullable String discriminator) {
        if (manifest == null) {
            throw new IllegalArgumentException("manifest can't be null");
        }
        if (descriptions == null || descriptions.length == 0) {
            throw new IllegalArgumentException("descriptions can't be null or empty");
        }
        if (discriminator != null && (discriminator.length() == 0 || discriminator.contains("\""))) {
            throw new IllegalArgumentException("Invalid discriminator provided: " + discriminator);
        }
        this.typeHash = discriminator == null ? defaultTypeHash : DecodePropertyInfo.calcHash(discriminator);
        this.objectStart = discriminator == null ? defaultObjectStart : ("{\"" + discriminator + "\":").getBytes(utf8);
        this.discriminator = discriminator == null ? "$type" : discriminator;
        this.manifest = manifest;
        this.descriptions = descriptions;
        HashSet<Integer> uniqueHashNames = new HashSet<Integer>();
        boolean canObject = false;
        boolean canArray = false;
        for (FormatDescription<T> od : descriptions) {
            uniqueHashNames.add(od.typeHash);
            canObject = canObject || od.objectFormat != null;
            canArray = canArray || od.arrayFormat != null;
        }
        this.alwaysSerialize = !json.omitDefaults;
        this.canObjectFormat = canObject;
        this.canArrayFormat = canArray;
        this.exactMatch = uniqueHashNames.size() != descriptions.length;
        this.discriminatorError = String.format("Expecting \"%s\" attribute as first element of mixin %s", this.discriminator, Reflection.typeDescription(manifest));
    }

    @Nullable
    public T read(JsonReader reader) throws IOException {
        if (reader.wasNull()) {
            return null;
        }
        if (reader.last() == 123 && this.canObjectFormat) {
            return this.readObjectFormat(reader);
        }
        if (this.canArrayFormat && reader.last() == 91) {
            return this.readArrayFormat(reader);
        }
        if (this.canObjectFormat && this.canArrayFormat) {
            throw reader.newParseError("Expecting '{' or '[' for object start");
        }
        if (this.canObjectFormat) {
            throw reader.newParseError("Expecting '{' for object start");
        }
        throw reader.newParseError("Expecting '[' for object start");
    }

    @Nullable
    private T readObjectFormat(JsonReader reader) throws IOException {
        if (reader.getNextToken() != 34) {
            throw reader.newParseError(this.discriminatorError);
        }
        if (reader.fillName() != this.typeHash) {
            String name = reader.getLastName();
            throw reader.newParseErrorFormat(this.discriminatorError, name.length() + 2, "Expecting \"%s\" attribute as first element of mixin %s. Found: '%s'", new Object[]{this.discriminator, Reflection.typeDescription(this.manifest), name});
        }
        reader.getNextToken();
        int hash = reader.calcHash();
        for (FormatDescription<T> od : this.descriptions) {
            if (od.objectFormat == null || od.typeHash != hash || this.exactMatch && !reader.wasLastName(od.typeName)) continue;
            FormatConverter ofd = od.objectFormat;
            if (reader.getNextToken() == 44) {
                reader.getNextToken();
            }
            return ofd.readContent(reader);
        }
        throw new ConfigurationException("Unable to find decoder for '" + reader.getLastName() + "' for mixin: " + Reflection.typeDescription(this.manifest) + " which supports object format. Add @CompiledJson to specified type to allow deserialization into it");
    }

    @Nullable
    private T readArrayFormat(JsonReader reader) throws IOException {
        if (reader.getNextToken() != 34) {
            throw reader.newParseError(this.discriminatorError);
        }
        reader.getNextToken();
        int hash = reader.calcHash();
        for (FormatDescription<T> od : this.descriptions) {
            if (od.arrayFormat == null || od.typeHash != hash || this.exactMatch && !reader.wasLastName(od.typeName)) continue;
            FormatConverter afd = od.arrayFormat;
            if (reader.getNextToken() == 44) {
                reader.getNextToken();
            }
            return afd.readContent(reader);
        }
        throw new ConfigurationException("Unable to find decoder for '" + reader.getLastName() + "' for mixin: " + Reflection.typeDescription(this.manifest) + " which supports array format. Add @CompiledJson to specified type to allow deserialization into it");
    }

    public void write(JsonWriter writer, @Nullable T instance) {
        if (instance == null) {
            writer.writeNull();
            return;
        }
        Class<?> current = instance.getClass();
        for (FormatDescription<T> od : this.descriptions) {
            if (current != od.manifest) continue;
            if (od.isObjectFormatFirst) {
                writer.writeAscii(this.objectStart);
                writer.writeAscii(od.quotedTypeName);
                FormatConverter<T> ofd = od.objectFormat;
                if (this.alwaysSerialize) {
                    writer.writeByte((byte)44);
                    int pos = writer.size();
                    long flushed = writer.flushed();
                    ofd.writeContentFull(writer, instance);
                    if (pos != writer.size() || flushed != writer.flushed()) {
                        writer.writeByte((byte)125);
                    } else {
                        writer.getByteBuffer()[writer.size() - 1] = 125;
                    }
                } else {
                    writer.writeByte((byte)44);
                    ofd.writeContentMinimal(writer, instance);
                    writer.getByteBuffer()[writer.size() - 1] = 125;
                }
            } else {
                writer.writeByte((byte)91);
                writer.writeAscii(od.quotedTypeName);
                od.arrayFormat.writeContentFull(writer, instance);
                writer.writeByte((byte)93);
            }
            return;
        }
        throw new ConfigurationException("Unable to find encoder for '" + instance.getClass() + "'. Add @CompiledJson to specified type to allow serialization from it");
    }
}

