/*
 * Decompiled with CFR 0.152.
 */
package dsl_json.java.lang;

import com.dslplatform.json.Configuration;
import com.dslplatform.json.DslJson;
import com.dslplatform.json.JsonReader;
import com.dslplatform.json.JsonWriter;
import com.dslplatform.json.Nullable;
import com.dslplatform.json.NumberConverter;
import java.io.IOException;

public class ByteDslJsonConverter
implements Configuration {
    private static final JsonWriter.WriteObject<Byte> ByteWriter = new JsonWriter.WriteObject<Byte>(){

        public void write(JsonWriter writer, @Nullable Byte value) {
            if (value == null) {
                writer.writeNull();
            } else {
                NumberConverter.serialize((int)value.byteValue(), (JsonWriter)writer);
            }
        }
    };
    private static final JsonReader.ReadObject<Byte> ByteReader = new JsonReader.ReadObject<Byte>(){

        public Byte read(JsonReader reader) throws IOException {
            return (byte)NumberConverter.deserializeInt((JsonReader)reader);
        }
    };
    private static final JsonReader.ReadObject<Byte> NullableByteReader = new JsonReader.ReadObject<Byte>(){

        @Nullable
        public Byte read(JsonReader reader) throws IOException {
            return reader.wasNull() ? null : Byte.valueOf((byte)NumberConverter.deserializeInt((JsonReader)reader));
        }
    };

    public void configure(DslJson json) {
        json.registerWriter(Byte.TYPE, ByteWriter);
        json.registerReader(Byte.TYPE, ByteReader);
        json.registerWriter(Byte.class, ByteWriter);
        json.registerReader(Byte.class, NullableByteReader);
    }
}

