/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.json;

import com.dslplatform.json.AnnotationCompiler;
import com.dslplatform.json.CompiledJson;
import com.dslplatform.json.Nullable;
import com.dslplatform.json.processor.Analysis;
import com.dslplatform.json.processor.AnnotationUsage;
import com.dslplatform.json.processor.AttributeInfo;
import com.dslplatform.json.processor.LogLevel;
import com.dslplatform.json.processor.ObjectType;
import com.dslplatform.json.processor.StructInfo;
import com.dslplatform.json.processor.TypeSupport;
import com.dslplatform.json.processor.UnknownTypes;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.StandardLocation;

@SupportedAnnotationTypes(value={"com.dslplatform.json.CompiledJson", "com.dslplatform.json.JsonAttribute", "com.dslplatform.json.JsonConverter"})
@SupportedOptions(value={"dsljson.namespace", "dsljson.compiler", "dsljson.showdsl", "dsljson.loglevel", "dsljson.annotation"})
public class CompiledJsonProcessor
extends AbstractProcessor {
    private static final Map<String, String> SupportedTypes = new HashMap<String, String>();
    private static final Map<String, String> SupportedCollections;
    private static final Set<String> JsonIgnore;
    private static final Map<String, List<Analysis.AnnotationMapping<Boolean>>> NonNullable;
    private static final Map<String, String> PropertyAlias;
    private static final Map<String, List<Analysis.AnnotationMapping<Boolean>>> JsonRequired;
    private static final Map<String, String> PropertyIndex;
    private static final List<IncompatibleTypes> CheckTypes;
    private static final TypeSupport TypeSupport;
    private static final String CONFIG = "META-INF/services/com.dslplatform.json.Configuration";
    private String namespace;
    private String compiler;
    private boolean showDsl;
    private LogLevel logLevel = LogLevel.ERRORS;
    private AnnotationUsage annotationUsage = AnnotationUsage.IMPLICIT;
    private Analysis analysis;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        String au;
        String ll;
        super.init(processingEnv);
        Map<String, String> options = processingEnv.getOptions();
        String ns = options.get("dsljson.namespace");
        this.namespace = ns != null && ns.length() > 0 ? ns : "dsl_json";
        this.compiler = options.get("dsljson.compiler");
        String sd = options.get("dsljson.showdsl");
        if (sd != null && sd.length() > 0) {
            try {
                this.showDsl = Boolean.parseBoolean(sd);
            }
            catch (Exception exception) {}
        } else {
            this.showDsl = false;
        }
        if ((ll = options.get("dsljson.loglevel")) != null && ll.length() > 0) {
            this.logLevel = LogLevel.valueOf((String)ll);
        }
        if ((au = options.get("dsljson.annotation")) != null && au.length() > 0) {
            this.annotationUsage = AnnotationUsage.valueOf((String)au);
        }
        this.analysis = new Analysis(processingEnv, this.annotationUsage, this.logLevel, TypeSupport, JsonIgnore, NonNullable, PropertyAlias, JsonRequired, Collections.emptySet(), PropertyIndex, UnknownTypes.ERROR, true, true, true, false);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            return false;
        }
        Set<? extends Element> compiledJsons = roundEnv.getElementsAnnotatedWith(this.analysis.compiledJsonElement);
        if (!compiledJsons.isEmpty()) {
            String fileContent;
            Set<? extends Element> jsonConverters = roundEnv.getElementsAnnotatedWith(this.analysis.converterElement);
            Map configurations = this.analysis.processConverters(jsonConverters);
            this.analysis.processAnnotation(this.analysis.compiledJsonType, compiledJsons);
            Map structs = this.analysis.analyze();
            CompileOptions options = new CompileOptions();
            options.hasError = this.analysis.hasError();
            String dsl = this.buildDsl(structs, options);
            if (options.hasError) {
                return false;
            }
            if (this.showDsl) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, dsl);
            }
            try {
                fileContent = AnnotationCompiler.buildExternalJson(dsl, options.toOptions(this.namespace, this.compiler), this.logLevel, this.processingEnv.getMessager());
            }
            catch (Exception e) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "DSL compilation error\n" + e.getMessage());
                return false;
            }
            try {
                String className = this.namespace + ".json.ExternalSerialization";
                Writer writer = this.processingEnv.getFiler().createSourceFile(className, new Element[0]).openWriter();
                writer.write(fileContent);
                writer.close();
                writer = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", CONFIG, new Element[0]).openWriter();
                writer.write(className);
                for (String conf : configurations.keySet()) {
                    writer.write(10);
                    writer.write(conf);
                }
                writer.close();
            }
            catch (IOException e) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed saving compiled json serialization files");
            }
        }
        return false;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    private String buildDsl(Map<String, StructInfo> structs, CompileOptions options) {
        StringBuilder dsl = new StringBuilder();
        dsl.append("module json {\n");
        TypeCheck[] checks = new TypeCheck[CheckTypes.size()];
        for (int i = 0; i < checks.length; ++i) {
            checks[i] = new TypeCheck();
        }
        boolean requiresExtraSetup = false;
        for (StructInfo info : structs.values()) {
            if (info.formats.contains(CompiledJson.Format.ARRAY)) {
                options.hasError = true;
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Array format is not supported in the DSL compiler. Found on: '" + info.element.getQualifiedName() + "'.", info.element, info.annotation);
            }
            if (info.deserializeAs == null && info.type == ObjectType.MIXIN) {
                for (StructInfo im : info.implementations) {
                    if (im.deserializeName.isEmpty()) continue;
                    options.hasError = true;
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Deserialization name is not supported in the DSL compiler. Found on: '" + im.element.getQualifiedName() + "' and used in: '" + info.element.getQualifiedName() + "'.", im.element, im.annotation);
                }
            }
            if (info.type == ObjectType.ENUM) {
                dsl.append("  enum ");
            } else if (info.type == ObjectType.MIXIN) {
                dsl.append("  mixin ");
            } else {
                dsl.append("  struct ");
            }
            dsl.append(info.name);
            dsl.append(" {\n");
            if (info.type == ObjectType.ENUM) {
                for (String c : info.constants) {
                    dsl.append("    ");
                    dsl.append(c);
                    dsl.append(";\n");
                }
            } else {
                for (StructInfo impl : info.implementations) {
                    dsl.append("    with mixin ");
                    dsl.append(impl.name);
                    dsl.append(";\n");
                }
                if (info.jsonObjectReaderPath != null) {
                    dsl.append("    external Java JSON converter;\n");
                } else if (info.converter != null) {
                    dsl.append("    external Java JSON converter '").append(info.converter.fullName).append("';\n");
                } else {
                    for (AttributeInfo attr : info.attributes.values()) {
                        String dslType = this.getDslType(attr, structs);
                        this.processProperty(dsl, options, checks, info, attr, dslType, structs);
                    }
                }
            }
            requiresExtraSetup = requiresExtraSetup || info.onUnknown != null || info.deserializeAs != null;
            dsl.append("    external name Java '");
            dsl.append(info.element.getQualifiedName());
            dsl.append("';\n  }\n");
        }
        if (requiresExtraSetup) {
            dsl.append("  JSON serialization {\n");
            for (StructInfo info : structs.values()) {
                if (info.onUnknown != null && info.onUnknown != CompiledJson.Behavior.DEFAULT) {
                    dsl.append("    in ").append(info.name);
                    dsl.append(info.onUnknown == CompiledJson.Behavior.FAIL ? " fail on" : " ignore");
                    dsl.append(" unknown;\n");
                    continue;
                }
                if (info.getDeserializeTarget() == null) continue;
                dsl.append("    deserialize ").append(info.name).append(" as ").append(info.getDeserializeTarget().name).append(";\n");
            }
            dsl.append("  }\n");
        }
        dsl.append("}");
        return dsl.toString();
    }

    @Nullable
    private String getDslType(AttributeInfo attr, Map<String, StructInfo> structs) {
        String simpleType = SupportedTypes.get(attr.typeName);
        boolean hasNonNullable = attr.notNull;
        if (simpleType != null) {
            return simpleType.endsWith("?") && hasNonNullable ? simpleType.substring(0, simpleType.length() - 1) : simpleType;
        }
        if (attr.type instanceof ArrayType) {
            ArrayType at = (ArrayType)attr.type;
            String elementType = at.getComponentType().toString();
            String string = hasNonNullable ? "[]" : "[]?";
            simpleType = SupportedTypes.get(elementType);
            if (simpleType != null) {
                return simpleType + string;
            }
            StructInfo item = structs.get(elementType);
            if (item != null) {
                return "json." + item.name + "?" + string;
            }
        }
        String collectionEnding = hasNonNullable ? ">" : ">?";
        for (Map.Entry entry : SupportedCollections.entrySet()) {
            if (!attr.typeName.startsWith((String)entry.getKey())) continue;
            String typeName = attr.typeName.substring(((String)entry.getKey()).length(), attr.typeName.length() - 1);
            simpleType = SupportedTypes.get(typeName);
            if (simpleType != null) {
                return (String)entry.getValue() + "<" + simpleType + collectionEnding;
            }
            StructInfo item = structs.get(typeName);
            if (item == null) continue;
            return (String)entry.getValue() + "<json." + item.name + "?" + collectionEnding;
        }
        StructInfo info = structs.get(attr.typeName);
        if (info != null) {
            return "json." + info.name + (hasNonNullable ? "" : "?");
        }
        return null;
    }

    private void processProperty(StringBuilder dsl, CompileOptions options, TypeCheck[] checks, StructInfo info, AttributeInfo attr, @Nullable String dslType, Map<String, StructInfo> structs) {
        String javaType = attr.typeName;
        boolean fieldAccess = attr.field != null;
        for (int i = 0; i < CheckTypes.size(); ++i) {
            boolean hasSecond;
            IncompatibleTypes it = CheckTypes.get(i);
            if (!javaType.startsWith(it.first) && !javaType.startsWith(it.second)) continue;
            TypeCheck tc = checks[i];
            boolean hasFirst = tc.hasFirst || javaType.startsWith(it.first);
            boolean bl = hasSecond = tc.hasSecond || javaType.startsWith(it.second);
            if (hasFirst && hasSecond && !tc.hasFirst && !tc.hasSecond) {
                options.hasError = true;
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Both Joda Time and Java Time detected as property types. Only one supported at once.", attr.element, info.annotation);
            }
            tc.hasFirst = hasFirst;
            tc.hasSecond = hasSecond;
        }
        if (dslType == null && attr.converter != null) {
            dslType = "String?";
        }
        if (dslType != null) {
            boolean excludeTypeSignature;
            options.useJodaTime = options.useJodaTime || javaType.startsWith("org.joda.time");
            options.useAndroid = options.useAndroid || javaType.startsWith("android.graphics");
            dsl.append("    ");
            dsl.append(dslType);
            dsl.append(" ");
            dsl.append(attr.name);
            StructInfo target = CompiledJsonProcessor.findReferenced(attr.type, attr.typeName, structs);
            String alias = attr.id;
            if (info.minifiedNames.containsKey(attr.id)) {
                alias = (String)info.minifiedNames.get(attr.id);
            }
            boolean bl = excludeTypeSignature = target != null && target.type == ObjectType.MIXIN && (CompiledJson.TypeSignature.EXCLUDE.equals((Object)attr.typeSignature) || attr.typeSignature == null && CompiledJson.TypeSignature.EXCLUDE.equals((Object)target.typeSignature));
            if (info.type == ObjectType.CLASS && (fieldAccess || !attr.name.equals(alias) || !attr.alternativeNames.isEmpty() || attr.fullMatch || attr.converter != null || attr.mandatory || excludeTypeSignature)) {
                dsl.append(" {");
                if (fieldAccess) {
                    dsl.append("  simple Java access;");
                }
                if (!attr.name.equals(alias)) {
                    dsl.append("  serialization name '");
                    dsl.append(alias);
                    dsl.append("';");
                }
                for (String da : attr.alternativeNames) {
                    dsl.append("  deserialization alias '");
                    dsl.append(da);
                    dsl.append("';");
                }
                if (attr.fullMatch) {
                    dsl.append("  deserialization match full;");
                }
                if (attr.mandatory) {
                    dsl.append("  mandatory;");
                }
                if (attr.converter != null) {
                    dsl.append("  external Java JSON converter '").append(attr.converter.fullName).append("' for '").append(javaType).append("';");
                }
                if (excludeTypeSignature) {
                    dsl.append("  exclude serialization signature;");
                }
                dsl.append("  }\n");
            } else {
                dsl.append(";\n");
            }
        } else {
            options.hasError = true;
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Specified type is not supported: '" + javaType + "'. If you wish to ignore this property, use one of the supported JsonIgnore annotations [such as Jackson @JsonIgnore or DSL-JSON @JsonAttribute(ignore = true) on " + (fieldAccess ? "field" : "getter") + "]. Alternatively register @JsonConverter for this type to support it with custom conversion.", attr.element, info.annotation);
        }
    }

    @Nullable
    private static StructInfo findReferenced(TypeMirror type, String typeName, Map<String, StructInfo> structs) {
        if (type instanceof ArrayType) {
            ArrayType at = (ArrayType)type;
            String elementType = at.getComponentType().toString();
            return structs.get(elementType);
        }
        for (Map.Entry<String, String> kv : SupportedCollections.entrySet()) {
            if (!typeName.startsWith(kv.getKey())) continue;
            String rawTypeName = typeName.substring(kv.getKey().length(), typeName.length() - 1);
            return structs.get(rawTypeName);
        }
        return structs.get(typeName);
    }

    static {
        SupportedTypes.put("int", "int");
        SupportedTypes.put("long", "long");
        SupportedTypes.put("float", "float");
        SupportedTypes.put("double", "double");
        SupportedTypes.put("boolean", "bool");
        SupportedTypes.put("java.lang.String", "string?");
        SupportedTypes.put("java.lang.Integer", "int?");
        SupportedTypes.put("java.lang.Long", "long?");
        SupportedTypes.put("java.lang.Float", "float?");
        SupportedTypes.put("java.lang.Double", "double?");
        SupportedTypes.put("java.lang.Boolean", "bool?");
        SupportedTypes.put("java.math.BigDecimal", "decimal?");
        SupportedTypes.put("java.time.LocalDate", "date?");
        SupportedTypes.put("java.time.OffsetDateTime", "timestamp?");
        SupportedTypes.put("org.joda.time.LocalDate", "date?");
        SupportedTypes.put("org.joda.time.DateTime", "timestamp?");
        SupportedTypes.put("byte[]", "binary");
        SupportedTypes.put("java.util.UUID", "uuid?");
        SupportedTypes.put("java.util.Map<java.lang.String,java.lang.String>", "properties?");
        SupportedTypes.put("java.util.Map<java.lang.String,java.lang.Object>", "map?");
        SupportedTypes.put("java.net.InetAddress", "ip?");
        SupportedTypes.put("java.net.URI", "url?");
        SupportedTypes.put("java.awt.Color", "color?");
        SupportedTypes.put("java.awt.geom.Rectangle2D", "rectangle?");
        SupportedTypes.put("java.awt.geom.Point2D", "location?");
        SupportedTypes.put("java.awt.Point", "point?");
        SupportedTypes.put("java.awt.image.BufferedImage", "image?");
        SupportedTypes.put("android.graphics.Rect", "rectangle?");
        SupportedTypes.put("android.graphics.PointF", "location?");
        SupportedTypes.put("android.graphics.Point", "point?");
        SupportedTypes.put("android.graphics.Bitmap", "image?");
        SupportedTypes.put("org.w3c.dom.Element", "xml?");
        SupportedCollections = new HashMap<String, String>();
        SupportedCollections.put("java.util.List<", "List");
        SupportedCollections.put("java.util.Set<", "Set");
        SupportedCollections.put("java.util.LinkedList<", "Linked List");
        SupportedCollections.put("java.util.Queue<", "Queue");
        SupportedCollections.put("java.util.Stack<", "Stack");
        SupportedCollections.put("java.util.Vector<", "Vector");
        SupportedCollections.put("java.util.Collection<", "Bag");
        JsonIgnore = new HashSet<String>();
        JsonIgnore.add("com.fasterxml.jackson.annotation.JsonIgnore");
        JsonIgnore.add("org.codehaus.jackson.annotate.JsonIgnore");
        NonNullable = new HashMap<String, List<Analysis.AnnotationMapping<Boolean>>>();
        NonNullable.put("javax.validation.constraints.NotNull", null);
        NonNullable.put("edu.umd.cs.findbugs.annotations.NonNull", null);
        NonNullable.put("javax.annotation.Nonnull", null);
        NonNullable.put("org.jetbrains.annotations.NotNull", null);
        NonNullable.put("lombok.NonNull", null);
        NonNullable.put("android.support.annotation.NonNull", null);
        PropertyAlias = new HashMap<String, String>();
        PropertyAlias.put("com.fasterxml.jackson.annotation.JsonProperty", "value()");
        PropertyAlias.put("com.google.gson.annotations.SerializedName", "value()");
        JsonRequired = new HashMap<String, List<Analysis.AnnotationMapping<Boolean>>>();
        JsonRequired.put("com.fasterxml.jackson.annotation.JsonProperty", Collections.singletonList(new Analysis.AnnotationMapping("required()", (Object)true)));
        PropertyIndex = new HashMap<String, String>();
        PropertyIndex.put("com.fasterxml.jackson.annotation.JsonProperty", "index()");
        CheckTypes = new ArrayList<IncompatibleTypes>();
        CheckTypes.add(new IncompatibleTypes("java.time", "org.joda.time", "Both Joda Time and Java Time detected as property types. Only one supported at once."));
        CheckTypes.add(new IncompatibleTypes("java.awt", "android.graphics", "Both Java AWT and Android graphics detected as property types. Only one supported at once."));
        final HashSet<String> collections = new HashSet<String>();
        for (String c : SupportedCollections.keySet()) {
            collections.add(c.substring(0, c.length() - 1));
        }
        TypeSupport = new TypeSupport(){

            public boolean isSupported(String type) {
                return SupportedTypes.containsKey(type) || collections.contains(type);
            }
        };
    }

    private static class TypeCheck {
        boolean hasFirst;
        boolean hasSecond;

        private TypeCheck() {
        }
    }

    private static class CompileOptions {
        boolean useJodaTime;
        boolean useAndroid;
        boolean hasError;

        private CompileOptions() {
        }

        AnnotationCompiler.CompileOptions toOptions(String namespace, String compiler) {
            AnnotationCompiler.CompileOptions options = new AnnotationCompiler.CompileOptions();
            options.namespace = namespace;
            options.compiler = compiler;
            options.useAndroid = this.useAndroid;
            options.useJodaTime = this.useJodaTime;
            return options;
        }
    }

    private static class IncompatibleTypes {
        final String first;
        final String second;
        final String description;

        IncompatibleTypes(String first, String second, String description) {
            this.first = first;
            this.second = second;
            this.description = description;
        }
    }
}

