/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.json.processor;

import com.dslplatform.json.Nullable;
import java.io.IOException;
import java.io.Writer;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

public class ConverterInfo {
    public final TypeElement converter;
    public final boolean legacyDeclaration;
    public final String fullName;
    public final String reader;
    public final String writer;
    public final String targetSignature;
    public final Element targetType;
    private final String readPrefix;
    private final String writePrefix;

    public ConverterInfo(TypeElement converter, boolean legacyDeclaration, String reader, String writer, String targetSignature, @Nullable Element targetType) {
        this.converter = converter;
        this.legacyDeclaration = legacyDeclaration;
        this.fullName = converter.getQualifiedName().toString();
        this.reader = reader;
        this.writer = writer;
        this.targetSignature = targetSignature;
        this.targetType = targetType;
        if (legacyDeclaration) {
            this.readPrefix = "." + reader;
            this.writePrefix = "." + writer;
        } else {
            int readInd = reader.lastIndexOf(46);
            int writeInd = writer.lastIndexOf(46);
            this.readPrefix = readInd != -1 ? "." + reader.substring(0, readInd) : "";
            this.writePrefix = writeInd != -1 ? "." + writer.substring(0, writeInd) : "";
        }
    }

    public void read(Writer code) throws IOException {
        code.append(this.fullName).append(this.readPrefix);
    }

    public void write(Writer code) throws IOException {
        code.append(this.fullName).append(this.writePrefix);
    }
}

