/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.json;

import com.dslplatform.json.JsonReader;
import com.dslplatform.json.JsonWriter;
import com.dslplatform.json.NumberConverter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class ObjectConverter {
    private static final JsonReader.ReadObject<Map<String, Object>> TypedMapReader = new JsonReader.ReadObject<Map<String, Object>>(){

        @Override
        public Map<String, Object> read(JsonReader reader) throws IOException {
            return reader.wasNull() ? null : ObjectConverter.deserializeMap(reader);
        }
    };
    static final JsonReader.ReadObject<LinkedHashMap> MapReader = new JsonReader.ReadObject<LinkedHashMap>(){

        @Override
        public LinkedHashMap read(JsonReader reader) throws IOException {
            return reader.wasNull() ? null : ObjectConverter.deserializeMap(reader);
        }
    };

    public static void serializeNullableMap(Map<String, Object> value, JsonWriter sw) {
        if (value == null) {
            sw.writeNull();
        } else {
            ObjectConverter.serializeMap(value, sw);
        }
    }

    public static void serializeMap(Map<String, Object> value, JsonWriter sw) {
        sw.writeByte((byte)123);
        int size = value.size();
        if (size > 0) {
            Iterator<Map.Entry<String, Object>> iterator = value.entrySet().iterator();
            Map.Entry<String, Object> kv = iterator.next();
            sw.writeString(kv.getKey());
            sw.writeByte((byte)58);
            sw.serializeObject(kv.getValue());
            for (int i = 1; i < size; ++i) {
                sw.writeByte((byte)44);
                kv = iterator.next();
                sw.writeString(kv.getKey());
                sw.writeByte((byte)58);
                sw.serializeObject(kv.getValue());
            }
        }
        sw.writeByte((byte)125);
    }

    public static void serializeObject(Object value, JsonWriter sw) throws IOException {
        sw.serializeObject(value);
    }

    public static Object deserializeObject(JsonReader reader) throws IOException {
        switch (reader.last()) {
            case 110: {
                if (!reader.wasNull()) {
                    throw reader.expecting("null");
                }
                return null;
            }
            case 116: {
                if (!reader.wasTrue()) {
                    throw reader.expecting("true");
                }
                return true;
            }
            case 102: {
                if (!reader.wasFalse()) {
                    throw reader.expecting("false");
                }
                return false;
            }
            case 34: {
                return reader.readString();
            }
            case 123: {
                return ObjectConverter.deserializeMap(reader);
            }
            case 91: {
                return ObjectConverter.deserializeList(reader);
            }
        }
        return NumberConverter.deserializeNumber(reader);
    }

    public static ArrayList<Object> deserializeList(JsonReader reader) throws IOException {
        if (reader.last() != 91) {
            throw reader.expecting("[");
        }
        byte nextToken = reader.getNextToken();
        if (nextToken == 93) {
            return new ArrayList<Object>(0);
        }
        ArrayList<Object> res = new ArrayList<Object>(4);
        res.add(ObjectConverter.deserializeObject(reader));
        while ((nextToken = reader.getNextToken()) == 44) {
            reader.getNextToken();
            res.add(ObjectConverter.deserializeObject(reader));
        }
        if (nextToken != 93) {
            throw reader.expecting("]", nextToken);
        }
        return res;
    }

    public static LinkedHashMap<String, Object> deserializeMap(JsonReader reader) throws IOException {
        if (reader.last() != 123) {
            throw reader.expecting("{");
        }
        byte nextToken = reader.getNextToken();
        if (nextToken == 125) {
            return new LinkedHashMap<String, Object>(0);
        }
        LinkedHashMap<String, Object> res = new LinkedHashMap<String, Object>();
        String key = reader.readKey();
        res.put(key, ObjectConverter.deserializeObject(reader));
        while ((nextToken = reader.getNextToken()) == 44) {
            reader.getNextToken();
            key = reader.readKey();
            res.put(key, ObjectConverter.deserializeObject(reader));
        }
        if (nextToken != 125) {
            throw reader.expecting("}", nextToken);
        }
        return res;
    }

    public static ArrayList<Map<String, Object>> deserializeMapCollection(JsonReader reader) throws IOException {
        return reader.deserializeCollection(TypedMapReader);
    }

    public static void deserializeMapCollection(JsonReader reader, Collection<Map<String, Object>> res) throws IOException {
        reader.deserializeCollection(TypedMapReader, res);
    }

    public static ArrayList<Map<String, Object>> deserializeNullableMapCollection(JsonReader reader) throws IOException {
        return reader.deserializeNullableCollection(TypedMapReader);
    }

    public static void deserializeNullableMapCollection(JsonReader reader, Collection<Map<String, Object>> res) throws IOException {
        reader.deserializeNullableCollection(TypedMapReader, res);
    }
}

