/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.json.processor;

import com.dslplatform.json.CompiledJson;
import com.dslplatform.json.Configuration;
import com.dslplatform.json.JsonAttribute;
import com.dslplatform.json.JsonConverter;
import com.dslplatform.json.JsonObject;
import com.dslplatform.json.processor.AnnotationUsage;
import com.dslplatform.json.processor.AttributeInfo;
import com.dslplatform.json.processor.ContainerSupport;
import com.dslplatform.json.processor.ConverterInfo;
import com.dslplatform.json.processor.LogLevel;
import com.dslplatform.json.processor.ObjectType;
import com.dslplatform.json.processor.StructInfo;
import com.dslplatform.json.processor.UnknownTypes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

public class Analysis {
    private final AnnotationUsage annotationUsage;
    private final LogLevel logLevel;
    private final UnknownTypes unknownTypes;
    private final boolean mustHaveEmptyCtor;
    private final boolean includeFields;
    private final boolean includeBeanMethods;
    private final boolean includeExactMethods;
    private final Elements elements;
    private final Types types;
    private final Messager messager;
    public final TypeElement compiledJsonElement;
    public final DeclaredType compiledJsonType;
    public final TypeElement attributeElement;
    public final DeclaredType attributeType;
    public final TypeElement converterElement;
    public final DeclaredType converterType;
    private final Set<String> supportedTypes;
    private final ContainerSupport containerSupport;
    private final Set<String> alternativeIgnore;
    private final Map<String, List<AnnotationMapping<Boolean>>> alternativeNonNullable;
    private final Map<String, String> alternativeAlias;
    private final Map<String, List<AnnotationMapping<Boolean>>> alternativeMandatory;
    private final Set<String> alternativeCtors;
    private final Map<String, String> alternativeIndex;
    private final Map<String, StructInfo> structs = new LinkedHashMap<String, StructInfo>();
    private boolean hasError;

    public boolean hasError() {
        return this.hasError;
    }

    public Analysis(ProcessingEnvironment processingEnv, AnnotationUsage annotationUsage, LogLevel logLevel, Set<String> supportedTypes, ContainerSupport containerSupport) {
        this(processingEnv, annotationUsage, logLevel, supportedTypes, containerSupport, null, null, null, null, null, null, UnknownTypes.ERROR, false, true, true, true);
    }

    public Analysis(ProcessingEnvironment processingEnv, AnnotationUsage annotationUsage, LogLevel logLevel, Set<String> supportedTypes, ContainerSupport containerSupport, Set<String> alternativeIgnore, Map<String, List<AnnotationMapping<Boolean>>> alternativeNonNullable, Map<String, String> alternativeAlias, Map<String, List<AnnotationMapping<Boolean>>> alternativeMandatory, Set<String> alternativeCtors, Map<String, String> alternativeIndex, UnknownTypes unknownTypes, boolean mustHaveEmptyCtor, boolean includeFields, boolean includeBeanMethods, boolean includeExactMethods) {
        this.annotationUsage = annotationUsage;
        this.logLevel = logLevel;
        this.elements = processingEnv.getElementUtils();
        this.types = processingEnv.getTypeUtils();
        this.messager = processingEnv.getMessager();
        this.compiledJsonElement = this.elements.getTypeElement(CompiledJson.class.getName());
        this.compiledJsonType = this.types.getDeclaredType(this.compiledJsonElement, new TypeMirror[0]);
        this.attributeElement = this.elements.getTypeElement(JsonAttribute.class.getName());
        this.attributeType = this.types.getDeclaredType(this.attributeElement, new TypeMirror[0]);
        this.converterElement = this.elements.getTypeElement(JsonConverter.class.getName());
        this.converterType = this.types.getDeclaredType(this.converterElement, new TypeMirror[0]);
        this.supportedTypes = supportedTypes;
        this.containerSupport = containerSupport;
        this.alternativeIgnore = alternativeIgnore == null ? new HashSet() : alternativeIgnore;
        this.alternativeNonNullable = alternativeNonNullable == null ? new HashMap() : alternativeNonNullable;
        this.alternativeAlias = alternativeAlias == null ? new HashMap() : alternativeAlias;
        this.alternativeMandatory = alternativeMandatory == null ? new HashMap() : alternativeMandatory;
        this.alternativeCtors = alternativeCtors == null ? new HashSet() : alternativeCtors;
        this.alternativeIndex = alternativeIndex == null ? new HashMap() : alternativeIndex;
        this.unknownTypes = unknownTypes == null ? UnknownTypes.ERROR : unknownTypes;
        this.mustHaveEmptyCtor = mustHaveEmptyCtor;
        this.includeFields = includeFields;
        this.includeBeanMethods = includeBeanMethods;
        this.includeExactMethods = includeExactMethods;
    }

    public List<String> processConverters(Set<? extends Element> converters) {
        ArrayList<String> configurations = new ArrayList<String>();
        block0: for (Element element : converters) {
            this.findConverters(element);
            if (!(element instanceof TypeElement)) continue;
            TypeElement te = (TypeElement)element;
            if (element.getModifiers().contains((Object)Modifier.ABSTRACT)) continue;
            for (TypeElement it : this.getTypeHierarchy((TypeElement)element)) {
                if (!Configuration.class.getName().equals(it.toString())) continue;
                if (te.getNestingKind().isNested()) {
                    configurations.add(((Object)te.getEnclosingElement().asType()).toString() + "$" + te.getSimpleName().toString());
                    continue block0;
                }
                configurations.add(((Object)te.asType()).toString());
                continue block0;
            }
        }
        return configurations;
    }

    public void processAnnotation(DeclaredType currentAnnotationType, Set<? extends Element> targets) {
        Stack<String> path = new Stack<String>();
        for (Element element : targets) {
            Element classElement = element instanceof TypeElement ? element : element.getEnclosingElement();
            this.findStructs(classElement, currentAnnotationType, currentAnnotationType + " requires accessible public constructor", path);
        }
        this.findRelatedReferences();
        this.findImplementations(this.structs.values());
    }

    public Map<String, StructInfo> analyze() {
        for (Map.Entry<String, StructInfo> it : this.structs.entrySet()) {
            StructInfo info = it.getValue();
            String className = it.getKey();
            if (info.type == ObjectType.CLASS && info.constructor == null && info.converter == null && info.matchingConstructors != null) {
                this.hasError = true;
                if (info.matchingConstructors.size() == 0) {
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "No matching constructors found for '" + info.element.asType() + "'. Make sure there is at least one matching constructor available.", info.element, info.annotation);
                } else {
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "Multiple matching constructors found for '" + info.element.asType() + "'. Use @CompiledJson or alternative annotations to select the appropriate constructor.", info.element, info.annotation);
                }
            }
            if (this.unknownTypes != UnknownTypes.ALLOW && !info.unknowns.isEmpty()) {
                for (Map.Entry entry : info.unknowns.entrySet()) {
                    AttributeInfo attr = info.attributes.get(entry.getKey());
                    if (attr != null && (attr.converter != null || attr.isJsonObject)) continue;
                    Map<String, Boolean> references = this.analyzeParts((TypeMirror)entry.getValue());
                    for (Map.Entry<String, Boolean> pair : references.entrySet()) {
                        Diagnostic.Kind kind;
                        if (pair.getValue().booleanValue()) continue;
                        this.hasError = this.hasError || this.unknownTypes == UnknownTypes.ERROR;
                        Diagnostic.Kind kind2 = kind = this.unknownTypes == UnknownTypes.ERROR ? Diagnostic.Kind.ERROR : Diagnostic.Kind.WARNING;
                        if (kind != Diagnostic.Kind.ERROR && !this.logLevel.isVisible(LogLevel.INFO)) continue;
                        if (((Object)((TypeMirror)entry.getValue())).toString().equals(pair.getKey())) {
                            this.messager.printMessage(kind, "Property " + (String)entry.getKey() + " is referencing unknown type: '" + entry.getValue() + "'. Register custom converter, mark property as ignored or enable unknown types", attr != null ? attr.element : info.element, info.annotation);
                            continue;
                        }
                        this.messager.printMessage(kind, "Property " + (String)entry.getKey() + " is referencing unknown type: '" + entry.getValue() + "' which has an unknown part: '" + pair.getKey() + "'. Register custom converter, mark property as ignored or enable unknown types", attr != null ? attr.element : info.element, info.annotation);
                    }
                }
            }
            if (this.unknownTypes != UnknownTypes.ALLOW) {
                for (AttributeInfo attributeInfo : info.attributes.values()) {
                    if (attributeInfo.converter != null || attributeInfo.isJsonObject) continue;
                    Map<String, Boolean> references = this.analyzeParts(attributeInfo.type);
                    for (String r : references.keySet()) {
                        StructInfo target = this.structs.get(r);
                        if (target == null || target.type != ObjectType.MIXIN || target.implementations.size() != 0) continue;
                        String what = target.element.getKind() == ElementKind.INTERFACE ? "interface" : "abstract class";
                        String one = target.element.getKind() == ElementKind.INTERFACE ? "implementation" : "concrete extension";
                        this.hasError = true;
                        this.messager.printMessage(Diagnostic.Kind.ERROR, "Property " + attributeInfo.name + " is referencing " + what + " (" + target.element.getQualifiedName() + ") which doesn't have registered " + "implementations with @CompiledJson. At least one " + one + " of specified " + what + " must be annotated " + "with CompiledJson annotation or allow unknown types during analysis", attributeInfo.element, info.annotation);
                    }
                }
            }
            if (this.unknownTypes != UnknownTypes.ALLOW && info.type == ObjectType.MIXIN && info.implementations.isEmpty()) {
                Diagnostic.Kind kind;
                String what = info.element.getKind() == ElementKind.INTERFACE ? "Interface" : "Abstract class";
                String string = info.element.getKind() == ElementKind.INTERFACE ? "implementation" : "concrete extension";
                this.hasError = this.hasError || this.unknownTypes == UnknownTypes.ERROR;
                Diagnostic.Kind kind3 = kind = this.unknownTypes == UnknownTypes.ERROR ? Diagnostic.Kind.ERROR : Diagnostic.Kind.WARNING;
                if (kind == Diagnostic.Kind.ERROR || this.logLevel.isVisible(LogLevel.INFO)) {
                    this.messager.printMessage(kind, what + " (" + className + ") is referenced, but it doesn't have registered " + "implementations with @CompiledJson. At least one " + string + " of specified " + what + " must be annotated " + "with CompiledJson annotation or allow unknown types during analysis", info.element, info.annotation);
                }
            }
            if (info.type == ObjectType.CLASS && info.converter == null && !info.hasEmptyCtor() && info.constructor != null) {
                for (VariableElement variableElement : info.constructor.getParameters()) {
                    boolean found = false;
                    String argName = variableElement.getSimpleName().toString();
                    for (AttributeInfo attr : info.attributes.values()) {
                        if (!attr.name.equals(argName)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    this.hasError = true;
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "Unable to find matching property: '" + argName + "' used in constructor. Either use annotation processor on source code, on bytecode with -parameters flag (to enable parameter names) or manually create an instance via converter", info.constructor, info.annotation);
                }
            }
            if (info.checkHashCollision()) {
                this.hasError = true;
                this.messager.printMessage(Diagnostic.Kind.ERROR, "Duplicate hash value detected. Unable to create binding for: '" + className + "'. Remove (or reduce) alternativeNames from @JsonAttribute to resolve this issue." + info.pathDescription(), info.element, info.annotation);
            }
            if (info.deserializeAs != null) {
                StructInfo target = this.structs.get(((Object)info.deserializeAs.asType()).toString());
                info.deserializeTarget(target);
                if (target == null) {
                    this.hasError = true;
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "Unable to find DSL-JSON metadata for: '" + info.deserializeAs.getQualifiedName() + "'. Add @CompiledJson annotation to target type.", info.element, info.annotation);
                }
            }
            if (info.deserializeAs == null && info.type == ObjectType.MIXIN) {
                HashSet<String> names = new HashSet<String>();
                for (StructInfo im : info.implementations) {
                    String actualName;
                    String string = actualName = im.deserializeName.isEmpty() ? im.element.getQualifiedName().toString() : im.deserializeName;
                    if (!names.add(actualName)) {
                        this.hasError = true;
                        this.messager.printMessage(Diagnostic.Kind.ERROR, "Duplicate deserialization name detected: '" + actualName + "' for mixin: " + className, info.element, info.annotation);
                        continue;
                    }
                    if (!actualName.contains("\\") && !actualName.contains("\"")) continue;
                    this.hasError = true;
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "Invalid deserialization name (with quotes or escape chars) detected: '" + actualName + "' for mixin: " + className, info.element, info.annotation);
                }
            }
            if (info.type == ObjectType.CLASS && this.mustHaveEmptyCtor && info.converter == null && !info.hasEmptyCtor()) {
                this.hasError = true;
                this.messager.printMessage(Diagnostic.Kind.ERROR, "'" + className + "' requires public no argument constructor" + info.pathDescription(), info.element, info.annotation);
            } else if (!(info.type != ObjectType.CLASS || this.mustHaveEmptyCtor || info.hasEmptyCtor() || info.converter != null || info.constructor != null && info.constructor.getParameters().size() == info.attributes.size())) {
                this.hasError = true;
                this.messager.printMessage(Diagnostic.Kind.ERROR, "'" + className + "' does not have an empty or matching constructor" + info.pathDescription(), info.element, info.annotation);
            }
            if (info.formats.contains((Object)CompiledJson.Format.ARRAY)) {
                HashSet<Integer> ids = new HashSet<Integer>();
                for (AttributeInfo attr : info.attributes.values()) {
                    if (attr.index == -1 && info.hasEmptyCtor()) {
                        this.hasError = true;
                        this.messager.printMessage(Diagnostic.Kind.ERROR, "When array format is used all properties must have index order defined. Property " + attr.name + " doesn't have index defined", attr.element, attr.annotation);
                        continue;
                    }
                    if (attr.index == -1 || ids.add(attr.index)) continue;
                    this.hasError = true;
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "Duplicate index detected on " + attr.name + ". Index values must be distinct to be used in array format", attr.element, attr.annotation);
                }
            }
            if (info.isMinified) {
                info.prepareMinifiedNames();
            }
            info.sortAttributes();
        }
        return new LinkedHashMap<String, StructInfo>(this.structs);
    }

    private void findConverters(Element el) {
        AnnotationMirror dslAnn = this.getAnnotation(el, this.converterType);
        if (!(el instanceof TypeElement) || dslAnn == null) {
            return;
        }
        TypeElement converter = (TypeElement)el;
        DeclaredType target = null;
        Map<? extends ExecutableElement, ? extends AnnotationValue> values = dslAnn.getElementValues();
        for (ExecutableElement executableElement : values.keySet()) {
            if (!executableElement.toString().equals("target()")) continue;
            target = (DeclaredType)values.get(executableElement).getValue();
            break;
        }
        if (target == null) {
            return;
        }
        ConverterInfo signature = this.validateConverter(converter, target.asElement(), target.toString());
        if (!this.structs.containsKey(target.toString())) {
            String string = "struct" + this.structs.size();
            TypeElement element = (TypeElement)target.asElement();
            StructInfo info = new StructInfo(converter, this.converterType, element, string, signature.reader, signature.writer);
            this.structs.put(target.toString(), info);
        }
    }

    private ConverterInfo validateConverter(TypeElement converter, Element target, String fullName) {
        String allowed;
        VariableElement jsonReaderField = null;
        VariableElement jsonWriterField = null;
        ExecutableElement jsonReaderMethod = null;
        ExecutableElement jsonWriterMethod = null;
        boolean hasInstance = false;
        for (VariableElement field : ElementFilter.fieldsIn(converter.getEnclosedElements())) {
            if ("INSTANCE".equals(field.getSimpleName().toString())) {
                if (!((Object)field.asType()).toString().equals(converter.getQualifiedName().toString()) || !field.getModifiers().contains((Object)Modifier.STATIC) || !field.getModifiers().contains((Object)Modifier.PUBLIC) || !field.getModifiers().contains((Object)Modifier.FINAL)) continue;
                hasInstance = true;
                continue;
            }
            if ("JSON_READER".equals(field.getSimpleName().toString())) {
                jsonReaderField = field;
                continue;
            }
            if (!"JSON_WRITER".equals(field.getSimpleName().toString())) continue;
            jsonWriterField = field;
        }
        if (!this.mustHaveEmptyCtor) {
            for (ExecutableElement method : ElementFilter.methodsIn(converter.getEnclosedElements())) {
                if ("JSON_READER".equals(method.getSimpleName().toString()) || "getJSON_READER".equals(method.getSimpleName().toString())) {
                    jsonReaderMethod = method;
                    continue;
                }
                if (!"JSON_WRITER".equals(method.getSimpleName().toString()) && !"getJSON_WRITER".equals(method.getSimpleName().toString())) continue;
                jsonWriterMethod = method;
            }
        }
        String string = allowed = this.mustHaveEmptyCtor ? "field" : "field/method";
        if (!converter.getModifiers().contains((Object)Modifier.PUBLIC)) {
            this.hasError = true;
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Specified converter: '" + converter.asType() + "' must be public", converter, this.getAnnotation(converter, this.converterType));
        } else if (!target.getModifiers().contains((Object)Modifier.PUBLIC)) {
            this.hasError = true;
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Specified converter target: '" + fullName + "' must be public", converter, this.getAnnotation(converter, this.converterType));
        } else if (converter.getNestingKind().isNested() && !converter.getModifiers().contains((Object)Modifier.STATIC)) {
            this.hasError = true;
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Specified converter: '" + converter.asType() + "' can't be a nested member. Only public static nested classes are supported", converter, this.getAnnotation(converter, this.converterType));
        } else if (converter.getQualifiedName().contentEquals(converter.getSimpleName()) || converter.getNestingKind().isNested() && converter.getModifiers().contains((Object)Modifier.STATIC) && converter.getEnclosingElement() instanceof TypeElement && ((TypeElement)converter.getEnclosingElement()).getQualifiedName().contentEquals(converter.getEnclosingElement().getSimpleName())) {
            this.hasError = true;
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Specified converter: '" + converter.getQualifiedName() + "' is defined without a package name and cannot be accessed", converter, this.getAnnotation(converter, this.converterType));
        } else if (jsonReaderField == null && jsonReaderMethod == null || jsonWriterField == null && jsonWriterMethod == null) {
            this.hasError = true;
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Specified converter: '" + converter.getQualifiedName() + "' doesn't have a JSON_READER or JSON_WRITER " + allowed + ". It must have public static JSON_READER/JSON_WRITER " + allowed + " for conversion.", converter, this.getAnnotation(converter, this.converterType));
        } else if (!((jsonReaderMethod != null || jsonReaderField.getModifiers().contains((Object)Modifier.PUBLIC) && jsonReaderField.getModifiers().contains((Object)Modifier.STATIC)) && (jsonWriterMethod != null || jsonWriterField.getModifiers().contains((Object)Modifier.PUBLIC) && jsonReaderField.getModifiers().contains((Object)Modifier.STATIC)) && (jsonReaderMethod == null || jsonReaderMethod.getModifiers().contains((Object)Modifier.PUBLIC) && (hasInstance || jsonReaderMethod.getModifiers().contains((Object)Modifier.STATIC))) && (jsonWriterMethod == null || jsonWriterMethod.getModifiers().contains((Object)Modifier.PUBLIC) && (hasInstance || jsonWriterMethod.getModifiers().contains((Object)Modifier.STATIC))))) {
            this.hasError = true;
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Specified converter: '" + converter.getQualifiedName() + "' doesn't have public and static JSON_READER and JSON_WRITER " + allowed + ". They must be public and static for converter to work properly.", converter, this.getAnnotation(converter, this.converterType));
        } else if (jsonReaderField != null && !("com.dslplatform.json.JsonReader.ReadObject<" + fullName + ">").equals(((Object)jsonReaderField.asType()).toString()) || jsonReaderMethod != null && !("com.dslplatform.json.JsonReader.ReadObject<" + fullName + ">").equals(((Object)jsonReaderMethod.getReturnType()).toString())) {
            this.hasError = true;
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Specified converter: '" + converter.getQualifiedName() + "' has invalid type for JSON_READER field. It must be of type: 'com.dslplatform.json.JsonReader.ReadObject<" + fullName + ">'", converter, this.getAnnotation(converter, this.converterType));
        } else if (jsonWriterField != null && !("com.dslplatform.json.JsonWriter.WriteObject<" + fullName + ">").equals(((Object)jsonWriterField.asType()).toString()) || jsonWriterMethod != null && !("com.dslplatform.json.JsonWriter.WriteObject<" + fullName + ">").equals(((Object)jsonWriterMethod.getReturnType()).toString())) {
            this.hasError = true;
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Specified converter: '" + converter.getQualifiedName() + "' has invalid type for JSON_WRITER " + allowed + ". It must be of type: 'com.dslplatform.json.JsonWriter.WriteObject<" + fullName + ">'", converter, this.getAnnotation(converter, this.converterType));
        }
        return new ConverterInfo(converter, jsonReaderMethod != null ? (hasInstance ? "INSTANCE." : "") + jsonReaderMethod.getSimpleName().toString() + "()" : (jsonReaderField != null ? jsonReaderField.getSimpleName().toString() : ""), jsonWriterMethod != null ? (hasInstance ? "INSTANCE." : "") + jsonWriterMethod.getSimpleName().toString() + "()" : (jsonWriterField != null ? jsonWriterField.getSimpleName().toString() : ""));
    }

    public List<TypeElement> getTypeHierarchy(TypeElement element) {
        ArrayList<TypeElement> result = new ArrayList<TypeElement>();
        result.add(element);
        for (TypeMirror typeMirror : this.types.directSupertypes(element.asType())) {
            Element current = this.types.asElement(typeMirror);
            if (!(current instanceof TypeElement)) continue;
            result.add((TypeElement)current);
        }
        return result;
    }

    public void findRelatedReferences() {
        int total;
        do {
            total = this.structs.size();
            ArrayList<StructInfo> items = new ArrayList<StructInfo>(this.structs.values());
            Stack<String> path = new Stack<String>();
            for (StructInfo info : items) {
                if (info.converter != null) continue;
                path.push(info.element.getSimpleName().toString());
                if (this.includeBeanMethods) {
                    for (Map.Entry<String, AccessElements> p : this.getBeanProperties(info.element, info.constructor).entrySet()) {
                        this.analyzeAttribute(info, p.getValue().read.getReturnType(), p.getKey(), p.getValue(), "bean property", path);
                    }
                }
                if (this.includeExactMethods) {
                    for (Map.Entry<String, AccessElements> p : this.getExactProperties(info.element, info.constructor).entrySet()) {
                        if (info.attributes.containsKey(p.getKey()) && info.annotation == null) continue;
                        this.analyzeAttribute(info, p.getValue().read.getReturnType(), p.getKey(), p.getValue(), "exact property", path);
                    }
                }
                if (this.includeFields) {
                    for (Map.Entry<String, AccessElements> f : this.getPublicFields(info.element, this.mustHaveEmptyCtor, info.constructor).entrySet()) {
                        if (info.attributes.containsKey(f.getKey()) && info.annotation == null) continue;
                        this.analyzeAttribute(info, f.getValue().field.asType(), f.getKey(), f.getValue(), "field", path);
                    }
                }
                path.pop();
            }
        } while (total != this.structs.size());
    }

    public static String objectName(String type) {
        return "int".equals(type) ? "java.lang.Integer" : ("long".equals(type) ? "java.lang.Long" : ("double".equals(type) ? "java.lang.Double" : ("float".equals(type) ? "java.lang.Float" : ("char".equals(type) ? "java.lang.Character" : ("byte".equals(type) ? "java.lang.Byte" : ("short".equals(type) ? "java.lang.Short" : ("boolean".equals(type) ? "java.lang.Boolean" : type)))))));
    }

    private void analyzeAttribute(StructInfo info, TypeMirror type, String name, AccessElements access, String target, Stack<String> path) {
        Element element = access.field != null ? access.field : access.read;
        path.push(name);
        if (!info.properties.contains(element) && !this.hasIgnoredAnnotation(element)) {
            AttributeInfo other;
            ConverterInfo converter;
            TypeMirror referenceType = access.field != null ? access.field.asType() : access.read.getReturnType();
            Element referenceElement = this.types.asElement(referenceType);
            TypeMirror converterMirror = this.findConverter(element);
            if (converterMirror != null) {
                TypeElement typeConverter = this.elements.getTypeElement(((Object)converterMirror).toString());
                String javaType = ((Object)type).toString();
                String objectType = Analysis.objectName(javaType);
                Element declaredType = objectType.equals(javaType) ? this.types.asElement(type) : this.elements.getTypeElement(objectType);
                converter = this.validateConverter(typeConverter, declaredType, objectType);
            } else {
                converter = null;
            }
            String referenceName = ((Object)referenceType).toString();
            boolean isJsonObject = this.isJsonObject(referenceElement);
            boolean typeResolved = converter != null || isJsonObject || this.supportedTypes.contains(referenceName) || this.structs.containsKey(referenceName);
            boolean hasUnknown = false;
            if (!typeResolved) {
                Map<String, Boolean> references = this.analyzeParts(referenceType);
                for (Map.Entry<String, Boolean> kv : references.entrySet()) {
                    if (kv.getValue().booleanValue()) continue;
                    hasUnknown = true;
                }
            }
            AnnotationMirror annotation = access.annotation;
            CompiledJson.TypeSignature typeSignature = this.typeSignatureValue(annotation);
            AttributeInfo attr = new AttributeInfo(name, access.read, access.write, access.field, type, annotation, this.hasNonNullable(element, annotation), this.hasMandatoryAnnotation(element, annotation), this.index(element, annotation), this.findNameAlias(element, annotation), this.isFullMatch(element, annotation), typeSignature, converter, isJsonObject);
            String[] alternativeNames = this.getAlternativeNames(attr.element);
            if (alternativeNames != null) {
                attr.alternativeNames.addAll(Arrays.asList(alternativeNames));
            }
            if ((other = info.attributes.get(attr.id)) != null && (other.annotation != null && attr.annotation == null || other.annotation == null && attr.annotation == null && other.field == null && attr.field != null)) {
                path.pop();
                return;
            }
            if (other != null && (!other.name.equals(attr.name) || other.id.equals(attr.id) && other.field == null && attr.field == null)) {
                this.hasError = true;
                this.messager.printMessage(Diagnostic.Kind.ERROR, "Duplicate alias detected on " + (attr.field != null ? "field: " : "property: ") + attr.name, attr.element, info.annotation);
            }
            if (!typeResolved && hasUnknown) {
                info.unknowns.put(attr.id, referenceType);
            }
            info.attributes.put(attr.id, attr);
            info.properties.add(attr.element);
            this.checkRelatedProperty(type, info.discoveredBy, target, info.element, element, path);
        }
        path.pop();
    }

    private void checkRelatedProperty(TypeMirror returnType, DeclaredType discoveredBy, String access, Element inside, Element property, Stack<String> path) {
        ArrayType at;
        TypeMirror converter = this.findConverter(property);
        if (converter != null) {
            return;
        }
        String typeName = ((Object)returnType).toString();
        if (this.supportedTypes.contains(typeName)) {
            return;
        }
        TypeElement el = this.elements.getTypeElement(typeName);
        if (el != null) {
            this.findStructs(el, discoveredBy, el + " is referenced as " + access + " from '" + inside.asType() + "' through CompiledJson annotation.", path);
            return;
        }
        if (returnType instanceof ArrayType && (el = this.elements.getTypeElement(((Object)(at = (ArrayType)returnType).getComponentType()).toString())) != null) {
            this.findStructs(el, discoveredBy, el + " is referenced as array " + access + " from '" + inside.asType() + "' through CompiledJson annotation.", path);
            return;
        }
        int genInd = typeName.indexOf(60);
        if (genInd == -1) {
            return;
        }
        String subtype = typeName.substring(genInd + 1, typeName.lastIndexOf(62));
        if (this.supportedTypes.contains(subtype)) {
            return;
        }
        LinkedHashSet<String> parts = new LinkedHashSet<String>();
        this.extractTypes(subtype, parts);
        for (String st : parts) {
            if (this.structs.containsKey(st) || this.supportedTypes.contains(st) || (el = this.elements.getTypeElement(st)) == null || !el.getTypeParameters().isEmpty() && this.containerSupport.isSupported(st)) continue;
            this.findStructs(el, discoveredBy, el + " is referenced as collection " + access + " from '" + inside.asType() + "' through CompiledJson annotation.", path);
        }
    }

    private void findStructs(Element el, DeclaredType discoveredBy, String errorMessge, Stack<String> path) {
        if (!(el instanceof TypeElement)) {
            return;
        }
        String typeName = ((Object)el.asType()).toString();
        if (this.structs.containsKey(typeName) || this.supportedTypes.contains(typeName)) {
            return;
        }
        TypeElement element = (TypeElement)el;
        boolean isMixin = element.getKind() == ElementKind.INTERFACE || element.getKind() == ElementKind.CLASS && element.getModifiers().contains((Object)Modifier.ABSTRACT);
        boolean isJsonObject = this.isJsonObject(element);
        AnnotationMirror annotation = this.scanClassForAnnotation(element, discoveredBy);
        if (!element.getModifiers().contains((Object)Modifier.PUBLIC)) {
            this.hasError = true;
            this.messager.printMessage(Diagnostic.Kind.ERROR, errorMessge + ", therefore '" + element.asType() + "' must be public ", element, annotation);
        } else if (element.getNestingKind().isNested() && !element.getModifiers().contains((Object)Modifier.STATIC)) {
            this.hasError = true;
            this.messager.printMessage(Diagnostic.Kind.ERROR, errorMessge + ", therefore '" + element.asType() + "' can't be a nested member. Only static nested classes are supported.", element, annotation);
        } else if (element.getQualifiedName().contentEquals(element.getSimpleName()) || element.getNestingKind().isNested() && element.getModifiers().contains((Object)Modifier.STATIC) && element.getEnclosingElement() instanceof TypeElement && ((TypeElement)element.getEnclosingElement()).getQualifiedName().contentEquals(element.getEnclosingElement().getSimpleName())) {
            this.hasError = true;
            this.messager.printMessage(Diagnostic.Kind.ERROR, errorMessge + ", but class '" + element.getQualifiedName() + "' is defined without a package name and cannot be accessed.", element, annotation);
        } else {
            CompiledJson.Format[] formats;
            ObjectType type = isMixin ? ObjectType.MIXIN : (element.getKind() == ElementKind.ENUM ? ObjectType.ENUM : ObjectType.CLASS);
            CompiledJson.Behavior onUnknown = CompiledJson.Behavior.DEFAULT;
            CompiledJson.TypeSignature typeSignature = CompiledJson.TypeSignature.DEFAULT;
            TypeElement deserializeAs = null;
            if (!isJsonObject) {
                if (annotation != null) {
                    onUnknown = this.onUnknownValue(annotation);
                    typeSignature = this.typeSignatureValue(annotation);
                    deserializeAs = Analysis.deserializeAs(annotation);
                    if (deserializeAs != null) {
                        String error = this.validateDeserializeAs(element, deserializeAs);
                        if (error != null) {
                            this.hasError = true;
                            this.messager.printMessage(Diagnostic.Kind.ERROR, errorMessge + ", but specified deserializeAs target: '" + deserializeAs.getQualifiedName() + "' " + error, element, annotation);
                            deserializeAs = null;
                        } else if (((Object)deserializeAs.asType()).toString().equals(((Object)element.asType()).toString())) {
                            deserializeAs = null;
                        } else {
                            this.findStructs(deserializeAs, discoveredBy, errorMessge, path);
                        }
                    }
                } else if (this.annotationUsage != AnnotationUsage.IMPLICIT) {
                    if (this.annotationUsage == AnnotationUsage.EXPLICIT) {
                        this.hasError = true;
                        this.messager.printMessage(Diagnostic.Kind.ERROR, "Annotation usage is set to explicit, but '" + element.getQualifiedName() + "' is used implicitly through references. " + "Either change usage to implicit, use @Ignore on property referencing this type or register custom converter for problematic type. " + errorMessge, element);
                    } else if (element.getQualifiedName().toString().startsWith("java.")) {
                        this.hasError = true;
                        this.messager.printMessage(Diagnostic.Kind.ERROR, "Annotation usage is set to non-java, but '" + element.getQualifiedName() + "' is found in java package. " + "Either change usage to implicit, use @Ignore on property referencing this type, register custom converter for problematic type or add annotation to this type. " + errorMessge, element);
                    }
                }
            }
            if (new HashSet<CompiledJson.Format>(Arrays.asList(formats = this.getFormats(annotation))).size() != formats.length) {
                this.hasError = true;
                this.messager.printMessage(Diagnostic.Kind.ERROR, "Duplicate format detected on '" + element.getQualifiedName() + "'.", element, annotation);
            }
            String name = "struct" + this.structs.size();
            StructInfo info = new StructInfo(element, discoveredBy, name, type, isJsonObject, this.findMatchingConstructors(element), this.findAnnotatedConstructor(element, discoveredBy), annotation, onUnknown, typeSignature, deserializeAs, Analysis.deserializeName(annotation), this.isMinified(annotation), formats);
            info.path.addAll(path);
            if (type == ObjectType.ENUM) {
                info.constants.addAll(Analysis.getEnumConstants(info.element));
            }
            this.structs.put(typeName, info);
        }
    }

    private String validateDeserializeAs(TypeElement source, TypeElement target) {
        if (!target.getModifiers().contains((Object)Modifier.PUBLIC)) {
            return "must be public";
        }
        if (target.getNestingKind().isNested() && !target.getModifiers().contains((Object)Modifier.STATIC)) {
            return "can't be a nested member. Only public static nested classes are supported";
        }
        if (target.getQualifiedName().contentEquals(target.getSimpleName()) || target.getNestingKind().isNested() && target.getModifiers().contains((Object)Modifier.STATIC) && target.getEnclosingElement() instanceof TypeElement && ((TypeElement)target.getEnclosingElement()).getQualifiedName().contentEquals(target.getEnclosingElement().getSimpleName())) {
            return "is defined without a package name and cannot be accessed";
        }
        if (target.getKind() == ElementKind.INTERFACE || target.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            return "must be a concrete type";
        }
        if (!((Object)source.asType()).toString().equals(((Object)target.asType()).toString()) && source.getKind() != ElementKind.INTERFACE && !source.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            return "can only be specified for interfaces and abstract classes. '" + source + "' is neither interface nor abstract class";
        }
        if (!this.types.isAssignable(target.asType(), source.asType())) {
            return "is not assignable to '" + source.getQualifiedName() + "'";
        }
        return null;
    }

    public List<ExecutableElement> findMatchingConstructors(Element element) {
        if (element.getKind() == ElementKind.INTERFACE || element.getKind() == ElementKind.ENUM || element.getKind() == ElementKind.CLASS && element.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            return null;
        }
        ArrayList<ExecutableElement> matchingCtors = new ArrayList<ExecutableElement>();
        for (ExecutableElement constructor : ElementFilter.constructorsIn(element.getEnclosedElements())) {
            if (!constructor.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
            matchingCtors.add(constructor);
        }
        return matchingCtors;
    }

    public ExecutableElement findAnnotatedConstructor(Element element, DeclaredType discoveredBy) {
        if (element.getKind() == ElementKind.INTERFACE || element.getKind() == ElementKind.ENUM || element.getKind() == ElementKind.CLASS && element.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            return null;
        }
        for (ExecutableElement constructor : ElementFilter.constructorsIn(element.getEnclosedElements())) {
            AnnotationMirror discAnn = this.getAnnotation(constructor, discoveredBy);
            if (discAnn != null) {
                if (!constructor.getModifiers().contains((Object)Modifier.PUBLIC)) {
                    this.hasError = true;
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "Constructor in '" + element.asType() + "' is annotated with " + discoveredBy + ", but it's not public.", constructor, discAnn);
                }
                return constructor;
            }
            for (AnnotationMirror annotationMirror : constructor.getAnnotationMirrors()) {
                if (!this.alternativeCtors.contains(annotationMirror.getAnnotationType().toString())) continue;
                if (!constructor.getModifiers().contains((Object)Modifier.PUBLIC)) {
                    this.hasError = true;
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "Constructor in '" + element.asType() + "' is annotated with " + annotationMirror.getAnnotationType() + ", but it's not public.", constructor, annotationMirror);
                }
                return constructor;
            }
        }
        return null;
    }

    private Map<String, Boolean> analyzeParts(TypeMirror target) {
        String subtype;
        String typeName = ((Object)target).toString();
        if (this.structs.containsKey(typeName)) {
            return Collections.singletonMap(typeName, true);
        }
        if (this.supportedTypes.contains(typeName)) {
            return Collections.singletonMap(typeName, true);
        }
        if (target instanceof ArrayType) {
            ArrayType at = (ArrayType)target;
            return this.analyzeParts(at.getComponentType());
        }
        int genInd = typeName.indexOf(60);
        if (genInd == -1) {
            return Collections.singletonMap(typeName, false);
        }
        LinkedHashMap<String, Boolean> found = new LinkedHashMap<String, Boolean>();
        String rawClass = typeName.substring(0, genInd);
        TypeElement raw = this.elements.getTypeElement(rawClass);
        if (raw != null) {
            if (this.supportedTypes.contains(rawClass)) {
                found.put(rawClass, true);
            } else {
                found.put(rawClass, this.containerSupport.isSupported(rawClass));
            }
        }
        if (this.structs.containsKey(subtype = typeName.substring(genInd + 1, typeName.lastIndexOf(62))) || this.supportedTypes.contains(subtype)) {
            found.put(subtype, true);
            return found;
        }
        LinkedHashSet<String> parts = new LinkedHashSet<String>();
        this.extractTypes(subtype, parts);
        for (String st : parts) {
            if (this.structs.containsKey(st) || this.supportedTypes.contains(st)) {
                found.put(st, true);
                continue;
            }
            TypeElement el = this.elements.getTypeElement(st);
            if (el == null || !el.getTypeParameters().isEmpty()) {
                found.put(st, this.containerSupport.isSupported(st));
                continue;
            }
            if (this.isJsonObject(el)) {
                found.put(st, true);
                continue;
            }
            found.putAll(this.analyzeParts(el.asType()));
        }
        return found;
    }

    private void extractTypes(String signature, Set<String> parts) {
        if (signature.isEmpty()) {
            return;
        }
        if (this.supportedTypes.contains(signature) || this.structs.containsKey(signature)) {
            parts.add(signature);
            return;
        }
        int nextComma = signature.indexOf(44);
        int nextGen = signature.indexOf(60);
        if (nextComma == -1 && nextGen == -1) {
            parts.add(signature);
        } else if (nextComma != -1 && (nextGen == -1 || nextGen > nextComma)) {
            String first = signature.substring(0, nextComma);
            String second = signature.substring(nextComma + 1, signature.length());
            parts.add(first);
            this.extractTypes(second, parts);
        } else {
            String first = signature.substring(0, nextGen);
            String second = signature.substring(nextGen + 1, signature.length() - 1);
            parts.add(first);
            this.extractTypes(second, parts);
        }
    }

    public static List<String> getEnumConstants(TypeElement element) {
        ArrayList<String> result = new ArrayList<String>();
        for (VariableElement field : ElementFilter.fieldsIn(element.getEnclosedElements())) {
            if (!((Object)field.asType()).toString().equals(((Object)element.asType()).toString())) continue;
            result.add(field.getSimpleName().toString());
        }
        return result;
    }

    public boolean isJsonObject(Element el) {
        if (!(el instanceof TypeElement)) {
            return false;
        }
        TypeElement element = (TypeElement)el;
        for (TypeMirror typeMirror : element.getInterfaces()) {
            if (!JsonObject.class.getName().equals(((Object)typeMirror).toString())) continue;
            for (VariableElement field : ElementFilter.fieldsIn(element.getEnclosedElements())) {
                String correctType;
                if (!"JSON_READER".equals(field.getSimpleName().toString())) continue;
                if (!field.getModifiers().contains((Object)Modifier.PUBLIC) || !field.getModifiers().contains((Object)Modifier.STATIC)) {
                    this.hasError = true;
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "'" + element.getQualifiedName() + "' is 'com.dslplatform.json.JsonObject', but it's JSON_READER field is not public and static. " + "It can't be used for serialization/deserialization this way. " + "You probably want to change JSON_READER field so it's public and static.", element);
                }
                if (!(correctType = "com.dslplatform.json.JsonReader.ReadJsonObject<" + element.getQualifiedName() + ">").equals(((Object)field.asType()).toString())) {
                    this.hasError = true;
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "'" + element.getQualifiedName() + "' is 'com.dslplatform.json.JsonObject', but it's JSON_READER field is not of correct type. " + "It can't be used for serialization/deserialization this way. " + "You probably want to change JSON_READER field to: '" + correctType + "'", element);
                }
                return true;
            }
            this.messager.printMessage(Diagnostic.Kind.ERROR, "'" + element.getQualifiedName() + "' is 'com.dslplatform.json.JsonObject', but it doesn't have JSON_READER field. " + "It can't be used for serialization/deserialization this way. " + "You probably want to add public static JSON_READER field.", element);
            return true;
        }
        return false;
    }

    private Map<String, VariableElement> getCtorArguments(ExecutableElement ctor) {
        if (ctor == null) {
            return Collections.emptyMap();
        }
        HashMap<String, VariableElement> arguments = new HashMap<String, VariableElement>();
        for (VariableElement variableElement : ctor.getParameters()) {
            arguments.put(variableElement.getSimpleName().toString(), variableElement);
        }
        return arguments;
    }

    private boolean isCompatibileType(TypeMirror left, TypeMirror right) {
        String rightStr;
        if (((Object)left).equals(right)) {
            return true;
        }
        String leftStr = ((Object)left).toString();
        if (leftStr.equals(rightStr = ((Object)right).toString())) {
            return true;
        }
        int ind = leftStr.indexOf(60);
        if (ind == -1 || rightStr.indexOf(60) != ind) {
            return false;
        }
        if (left.getKind() != right.getKind()) {
            return false;
        }
        if (!leftStr.substring(0, ind).equals(rightStr.substring(0, ind))) {
            return false;
        }
        return this.types.isAssignable(right, left);
    }

    public Map<String, AccessElements> getBeanProperties(TypeElement element, ExecutableElement ctor) {
        HashMap<String, ExecutableElement> setters = new HashMap<String, ExecutableElement>();
        HashMap<String, ExecutableElement> getters = new HashMap<String, ExecutableElement>();
        Map<String, VariableElement> arguments = this.getCtorArguments(ctor);
        for (TypeElement inheritance : this.getTypeHierarchy(element)) {
            boolean isPublicInterface = inheritance.getKind() == ElementKind.INTERFACE && inheritance.getModifiers().contains((Object)Modifier.PUBLIC);
            for (ExecutableElement method : ElementFilter.methodsIn(inheritance.getEnclosedElements())) {
                String property;
                boolean isAccessible;
                String name = method.getSimpleName().toString();
                boolean bl = isAccessible = isPublicInterface && !method.getModifiers().contains((Object)Modifier.PRIVATE) || method.getModifiers().contains((Object)Modifier.PUBLIC) && !method.getModifiers().contains((Object)Modifier.STATIC) && !method.getModifiers().contains((Object)Modifier.NATIVE) && !method.getModifiers().contains((Object)Modifier.TRANSIENT) && !method.getModifiers().contains((Object)Modifier.ABSTRACT);
                if (name.length() < 4 || !isAccessible) continue;
                String string = property = name.substring(3).toUpperCase().equals(name.substring(3)) && name.length() > 4 ? name.substring(3) : name.substring(3, 4).toLowerCase() + name.substring(4);
                if (name.startsWith("get") && method.getParameters().size() == 0 && method.getReturnType() != null) {
                    if (getters.containsKey(property)) continue;
                    getters.put(property, method);
                    continue;
                }
                if (!name.startsWith("set") || method.getParameters().size() != 1) continue;
                setters.put(property, method);
            }
        }
        HashMap<String, AccessElements> result = new HashMap<String, AccessElements>();
        for (Map.Entry kv : getters.entrySet()) {
            ExecutableElement setter = (ExecutableElement)setters.get(kv.getKey());
            VariableElement setterArgument = setter == null ? null : setter.getParameters().get(0);
            VariableElement ctorArg = arguments.get(kv.getKey());
            String returnType = ((Object)((ExecutableElement)kv.getValue()).getReturnType()).toString();
            AnnotationMirror annotation = this.annotation((ExecutableElement)kv.getValue(), setter, null, ctorArg);
            if (setterArgument != null && ((Object)setterArgument.asType()).toString().equals(returnType)) {
                result.put((String)kv.getKey(), AccessElements.readWrite((ExecutableElement)kv.getValue(), setter, annotation));
                continue;
            }
            if (setterArgument != null && (setterArgument.asType() + "<").startsWith(returnType)) {
                result.put((String)kv.getKey(), AccessElements.readWrite((ExecutableElement)kv.getValue(), setter, annotation));
                continue;
            }
            if (this.mustHaveEmptyCtor || ctorArg == null || !this.isCompatibileType(ctorArg.asType(), ((ExecutableElement)kv.getValue()).getReturnType())) continue;
            result.put((String)kv.getKey(), AccessElements.readOnly((ExecutableElement)kv.getValue(), ctorArg, annotation));
        }
        return result;
    }

    public Map<String, AccessElements> getExactProperties(TypeElement element, ExecutableElement ctor) {
        HashMap<String, ExecutableElement> setters = new HashMap<String, ExecutableElement>();
        HashMap<String, ExecutableElement> getters = new HashMap<String, ExecutableElement>();
        Map<String, VariableElement> arguments = this.getCtorArguments(ctor);
        for (TypeElement inheritance : this.getTypeHierarchy(element)) {
            boolean isPublicInterface = inheritance.getKind() == ElementKind.INTERFACE && inheritance.getModifiers().contains((Object)Modifier.PUBLIC);
            for (ExecutableElement method : ElementFilter.methodsIn(inheritance.getEnclosedElements())) {
                boolean isAccessible;
                String name = method.getSimpleName().toString();
                boolean bl = isAccessible = isPublicInterface && !method.getModifiers().contains((Object)Modifier.PRIVATE) || method.getModifiers().contains((Object)Modifier.PUBLIC) && !method.getModifiers().contains((Object)Modifier.STATIC) && !method.getModifiers().contains((Object)Modifier.NATIVE) && !method.getModifiers().contains((Object)Modifier.TRANSIENT) && !method.getModifiers().contains((Object)Modifier.ABSTRACT);
                if (name.startsWith("get") || name.startsWith("set") || !isAccessible) continue;
                if (method.getParameters().size() == 0 && method.getReturnType() != null) {
                    if (getters.containsKey(name)) continue;
                    getters.put(name, method);
                    continue;
                }
                if (method.getParameters().size() != 1) continue;
                setters.put(name, method);
            }
        }
        HashMap<String, AccessElements> result = new HashMap<String, AccessElements>();
        for (Map.Entry kv : getters.entrySet()) {
            ExecutableElement setter = (ExecutableElement)setters.get(kv.getKey());
            VariableElement setterArgument = setter == null ? null : setter.getParameters().get(0);
            VariableElement ctorArg = arguments.get(kv.getKey());
            String returnType = ((Object)((ExecutableElement)kv.getValue()).getReturnType()).toString();
            AnnotationMirror annotation = this.annotation((ExecutableElement)kv.getValue(), setter, null, ctorArg);
            if (setterArgument != null && ((Object)setterArgument.asType()).toString().equals(returnType)) {
                result.put((String)kv.getKey(), AccessElements.readWrite((ExecutableElement)kv.getValue(), setter, annotation));
                continue;
            }
            if (setterArgument != null && (setterArgument.asType() + "<").startsWith(returnType)) {
                result.put((String)kv.getKey(), AccessElements.readWrite((ExecutableElement)kv.getValue(), setter, annotation));
                continue;
            }
            if (this.mustHaveEmptyCtor || ctorArg == null || !this.isCompatibileType(ctorArg.asType(), ((ExecutableElement)kv.getValue()).getReturnType())) continue;
            result.put((String)kv.getKey(), AccessElements.readOnly((ExecutableElement)kv.getValue(), ctorArg, annotation));
        }
        return result;
    }

    public Map<String, AccessElements> getPublicFields(TypeElement element, boolean mustHaveEmptyCtor, ExecutableElement ctor) {
        HashMap<String, AccessElements> result = new HashMap<String, AccessElements>();
        Map<String, VariableElement> arguments = this.getCtorArguments(ctor);
        for (TypeElement inheritance : this.getTypeHierarchy(element)) {
            for (VariableElement field : ElementFilter.fieldsIn(inheritance.getEnclosedElements())) {
                boolean isAccessible;
                String name = field.getSimpleName().toString();
                boolean isFinal = field.getModifiers().contains((Object)Modifier.FINAL);
                boolean bl = isAccessible = field.getModifiers().contains((Object)Modifier.PUBLIC) && (!isFinal || !mustHaveEmptyCtor) && !field.getModifiers().contains((Object)Modifier.NATIVE) && !field.getModifiers().contains((Object)Modifier.TRANSIENT) && !field.getModifiers().contains((Object)Modifier.STATIC);
                if (!isAccessible) continue;
                VariableElement ctorArg = arguments.get(name);
                AnnotationMirror annotation = this.annotation(null, null, field, ctorArg);
                result.put(name, AccessElements.field(field, ctorArg, annotation));
            }
        }
        return result;
    }

    public void findImplementations(Collection<StructInfo> structs) {
        for (StructInfo current : structs) {
            if (current.type != ObjectType.MIXIN) continue;
            String iface = ((Object)current.element.asType()).toString();
            block1: for (StructInfo info : structs) {
                if (info.type != ObjectType.CLASS) continue;
                for (TypeMirror typeMirror : this.types.directSupertypes(info.element.asType())) {
                    if (!((Object)typeMirror).toString().equals(iface)) continue;
                    current.implementations.add(info);
                    continue block1;
                }
            }
        }
    }

    public String[] getAlternativeNames(Element property) {
        AnnotationMirror dslAnn = this.getAnnotation(property, this.attributeType);
        if (dslAnn == null) {
            return null;
        }
        Map<? extends ExecutableElement, ? extends AnnotationValue> values = dslAnn.getElementValues();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> ee : values.entrySet()) {
            if (!ee.getKey().toString().equals("alternativeNames()")) continue;
            List val = (List)ee.getValue().getValue();
            if (val == null) {
                return null;
            }
            String[] names = new String[val.size()];
            for (int i = 0; i < val.size(); ++i) {
                names[i] = ((AnnotationValue)val.get(i)).getValue().toString();
            }
            return names;
        }
        return null;
    }

    public boolean isFullMatch(Element property, AnnotationMirror dslAnn) {
        if (dslAnn == null) {
            return false;
        }
        Map<? extends ExecutableElement, ? extends AnnotationValue> values = dslAnn.getElementValues();
        for (ExecutableElement executableElement : values.keySet()) {
            if (!executableElement.toString().equals("hashMatch()")) continue;
            Object val = values.get(executableElement).getValue();
            return val != null && (Boolean)val == false;
        }
        return false;
    }

    public int index(Element property, AnnotationMirror dslAnn) {
        if (dslAnn != null) {
            Map<? extends ExecutableElement, ? extends AnnotationValue> values = dslAnn.getElementValues();
            for (ExecutableElement executableElement : values.keySet()) {
                if (!executableElement.toString().equals("index()")) continue;
                Object val = values.get(executableElement).getValue();
                if (val == null) {
                    return -1;
                }
                return (Integer)val;
            }
        }
        for (AnnotationMirror annotationMirror : property.getAnnotationMirrors()) {
            Integer n = Analysis.matchCustomInteger(annotationMirror, this.alternativeIndex);
            if (n == null || n == -1) continue;
            return n;
        }
        return -1;
    }

    private AnnotationMirror annotation(ExecutableElement read, ExecutableElement write, VariableElement field, VariableElement ctor) {
        AnnotationMirror dslAnn;
        AnnotationMirror annotationMirror = dslAnn = read == null ? null : this.getAnnotation(read, this.attributeType);
        if (dslAnn != null) {
            return dslAnn;
        }
        AnnotationMirror annotationMirror2 = dslAnn = write == null ? null : this.getAnnotation(write, this.attributeType);
        if (dslAnn != null) {
            return dslAnn;
        }
        AnnotationMirror annotationMirror3 = dslAnn = field == null ? null : this.getAnnotation(field, this.attributeType);
        if (dslAnn != null) {
            return dslAnn;
        }
        return ctor == null ? null : this.getAnnotation(ctor, this.attributeType);
    }

    public boolean hasIgnoredAnnotation(Element property) {
        AnnotationMirror dslAnn = this.getAnnotation(property, this.attributeType);
        if (dslAnn != null) {
            return Analysis.booleanAnnotationValue(dslAnn, "ignore()", false);
        }
        for (AnnotationMirror annotationMirror : property.getAnnotationMirrors()) {
            if (!this.alternativeIgnore.contains(annotationMirror.getAnnotationType().toString())) continue;
            return true;
        }
        return false;
    }

    public AnnotationMirror scanClassForAnnotation(TypeElement element, DeclaredType annotationType) {
        AnnotationMirror target = this.getAnnotation(element, annotationType);
        if (target != null) {
            return target;
        }
        for (ExecutableElement constructor : ElementFilter.constructorsIn(element.getEnclosedElements())) {
            AnnotationMirror discAnn = this.getAnnotation(constructor, annotationType);
            if (discAnn == null) continue;
            return discAnn;
        }
        return null;
    }

    public AnnotationMirror getAnnotation(Element element, DeclaredType annotationType) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!this.types.isSameType(annotationMirror.getAnnotationType(), annotationType)) continue;
            return annotationMirror;
        }
        return null;
    }

    public boolean hasNonNullable(Element property, AnnotationMirror dslAnn) {
        if (dslAnn != null) {
            Map<? extends ExecutableElement, ? extends AnnotationValue> values = dslAnn.getElementValues();
            for (ExecutableElement executableElement : values.keySet()) {
                if (!executableElement.toString().equals("nullable()")) continue;
                Object val = values.get(executableElement).getValue();
                return val != null && (Boolean)val == false;
            }
            return false;
        }
        for (AnnotationMirror annotationMirror : property.getAnnotationMirrors()) {
            Boolean bl = Analysis.matchCustomBoolean(annotationMirror, this.alternativeNonNullable);
            if (bl == null) continue;
            return bl;
        }
        return false;
    }

    public static TypeElement deserializeAs(AnnotationMirror annotation) {
        Map<? extends ExecutableElement, ? extends AnnotationValue> values = annotation.getElementValues();
        for (ExecutableElement executableElement : values.keySet()) {
            if (!executableElement.toString().equals("deserializeAs()")) continue;
            DeclaredType target = (DeclaredType)values.get(executableElement).getValue();
            return (TypeElement)target.asElement();
        }
        return null;
    }

    public static String deserializeName(AnnotationMirror annotation) {
        if (annotation == null) {
            return "";
        }
        Map<? extends ExecutableElement, ? extends AnnotationValue> values = annotation.getElementValues();
        for (ExecutableElement executableElement : values.keySet()) {
            if (!executableElement.toString().equals("deserializeName()")) continue;
            return values.get(executableElement).getValue().toString();
        }
        return "";
    }

    public boolean hasMandatoryAnnotation(Element property, AnnotationMirror dslAnn) {
        if (dslAnn != null) {
            return Analysis.booleanAnnotationValue(dslAnn, "mandatory()", false);
        }
        for (AnnotationMirror annotationMirror : property.getAnnotationMirrors()) {
            Boolean match = Analysis.matchCustomBoolean(annotationMirror, this.alternativeMandatory);
            if (match == null) continue;
            return match;
        }
        return false;
    }

    public static boolean booleanAnnotationValue(AnnotationMirror ann, String method, boolean defaultValue) {
        Map<? extends ExecutableElement, ? extends AnnotationValue> values = ann.getElementValues();
        for (ExecutableElement executableElement : values.keySet()) {
            if (!executableElement.toString().equals(method)) continue;
            Object val = values.get(executableElement).getValue();
            return val == null ? defaultValue : (Boolean)val;
        }
        return defaultValue;
    }

    public CompiledJson.Behavior onUnknownValue(AnnotationMirror annotation) {
        if (annotation == null) {
            return null;
        }
        Map<? extends ExecutableElement, ? extends AnnotationValue> values = annotation.getElementValues();
        for (ExecutableElement executableElement : values.keySet()) {
            if (!executableElement.toString().equals("onUnknown()")) continue;
            Object val = values.get(executableElement).getValue();
            if (val == null) {
                return null;
            }
            return CompiledJson.Behavior.valueOf(val.toString());
        }
        return null;
    }

    public CompiledJson.TypeSignature typeSignatureValue(AnnotationMirror annotation) {
        if (annotation == null) {
            return null;
        }
        Map<? extends ExecutableElement, ? extends AnnotationValue> values = annotation.getElementValues();
        for (ExecutableElement executableElement : values.keySet()) {
            if (!executableElement.toString().equals("typeSignature()")) continue;
            Object val = values.get(executableElement).getValue();
            if (val == null) {
                return null;
            }
            return CompiledJson.TypeSignature.valueOf(val.toString());
        }
        return null;
    }

    public CompiledJson.Format[] getFormats(AnnotationMirror ann) {
        if (ann == null) {
            return new CompiledJson.Format[]{CompiledJson.Format.OBJECT};
        }
        Map<? extends ExecutableElement, ? extends AnnotationValue> values = ann.getElementValues();
        for (ExecutableElement executableElement : values.keySet()) {
            if (!"formats()".equals(executableElement.toString())) continue;
            Object val = values.get(executableElement).getValue();
            if (val == null) {
                return new CompiledJson.Format[]{CompiledJson.Format.OBJECT};
            }
            List list = (List)val;
            CompiledJson.Format[] result = new CompiledJson.Format[list.size()];
            for (int i = 0; i < result.length; ++i) {
                AnnotationValue enumVal = (AnnotationValue)list.get(i);
                result[i] = CompiledJson.Format.valueOf(enumVal.getValue().toString());
            }
            return result;
        }
        return new CompiledJson.Format[]{CompiledJson.Format.OBJECT};
    }

    public boolean isMinified(AnnotationMirror ann) {
        if (ann == null) {
            return false;
        }
        for (ExecutableElement executableElement : ann.getElementValues().keySet()) {
            if (!"minified()".equals(executableElement.toString())) continue;
            AnnotationValue minified = ann.getElementValues().get(executableElement);
            return (Boolean)minified.getValue();
        }
        return false;
    }

    public TypeMirror findConverter(Element property) {
        AnnotationMirror dslAnn = this.getAnnotation(property, this.attributeType);
        if (dslAnn == null) {
            return null;
        }
        Map<? extends ExecutableElement, ? extends AnnotationValue> values = dslAnn.getElementValues();
        for (ExecutableElement executableElement : values.keySet()) {
            if (!executableElement.toString().equals("converter()")) continue;
            TypeMirror mirror = (TypeMirror)values.get(executableElement).getValue();
            return mirror != null && ((Object)mirror).toString().equals(JsonAttribute.class.getName()) ? null : mirror;
        }
        return null;
    }

    public String findNameAlias(Element property, AnnotationMirror dslAnn) {
        if (dslAnn != null) {
            Map<? extends ExecutableElement, ? extends AnnotationValue> values = dslAnn.getElementValues();
            for (ExecutableElement executableElement : values.keySet()) {
                if (!executableElement.toString().equals("name()")) continue;
                String val = (String)values.get(executableElement).getValue();
                if (val != null && val.length() == 0) {
                    return null;
                }
                return val;
            }
            return null;
        }
        for (AnnotationMirror annotationMirror : property.getAnnotationMirrors()) {
            String string = Analysis.matchCustomString(annotationMirror, this.alternativeAlias);
            if (string == null || string.isEmpty()) continue;
            return string;
        }
        return null;
    }

    private static Boolean matchCustomBoolean(AnnotationMirror ann, Map<String, List<AnnotationMapping<Boolean>>> alternatives) {
        String name = ann.getAnnotationType().toString();
        if (alternatives.containsKey(name)) {
            List<AnnotationMapping<Boolean>> mappings = alternatives.get(name);
            if (mappings == null || mappings.isEmpty()) {
                return true;
            }
            for (AnnotationMapping<Boolean> m : mappings) {
                Map<? extends ExecutableElement, ? extends AnnotationValue> values = ann.getElementValues();
                for (ExecutableElement executableElement : values.keySet()) {
                    if (!executableElement.toString().equals(m.name)) continue;
                    Object val = values.get(executableElement).getValue();
                    if (val == null && m.value == null) {
                        return true;
                    }
                    return val != null && val == m.value;
                }
            }
        }
        return null;
    }

    private static String matchCustomString(AnnotationMirror ann, Map<String, String> alternatives) {
        String value = alternatives.get(ann.getAnnotationType().toString());
        if (value != null) {
            Map<? extends ExecutableElement, ? extends AnnotationValue> values = ann.getElementValues();
            for (ExecutableElement executableElement : values.keySet()) {
                if (!executableElement.toString().equals(value)) continue;
                AnnotationValue val = values.get(executableElement);
                if (val == null) {
                    return null;
                }
                if (val.getValue() == null) {
                    return null;
                }
                return val.getValue().toString();
            }
        }
        return null;
    }

    private static Integer matchCustomInteger(AnnotationMirror ann, Map<String, String> alternatives) {
        String value = alternatives.get(ann.getAnnotationType().toString());
        if (value != null) {
            Map<? extends ExecutableElement, ? extends AnnotationValue> values = ann.getElementValues();
            for (ExecutableElement executableElement : values.keySet()) {
                if (!executableElement.toString().equals(value)) continue;
                AnnotationValue val = values.get(executableElement);
                if (val == null) {
                    return null;
                }
                if (val.getValue() == null) {
                    return null;
                }
                return (Integer)val.getValue();
            }
        }
        return null;
    }

    public static class AccessElements {
        public final ExecutableElement read;
        public final ExecutableElement write;
        public final VariableElement field;
        public final VariableElement ctor;
        public final AnnotationMirror annotation;

        private AccessElements(ExecutableElement read, ExecutableElement write, VariableElement ctor, VariableElement field, AnnotationMirror annotation) {
            this.read = read;
            this.write = write;
            this.field = field;
            this.ctor = ctor;
            this.annotation = annotation;
        }

        public static AccessElements readWrite(ExecutableElement read, ExecutableElement write, AnnotationMirror annotation) {
            return new AccessElements(read, write, null, null, annotation);
        }

        public static AccessElements field(VariableElement field, VariableElement ctor, AnnotationMirror annotation) {
            return new AccessElements(null, null, ctor, field, annotation);
        }

        public static AccessElements readOnly(ExecutableElement read, VariableElement ctor, AnnotationMirror annotation) {
            return new AccessElements(read, null, ctor, null, annotation);
        }
    }

    public static class AnnotationMapping<T> {
        public final String name;
        public final T value;

        public AnnotationMapping(String name, T value) {
            this.name = name;
            this.value = value;
        }
    }
}

