/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.json.processor;

import com.dslplatform.json.CompiledJson;
import com.dslplatform.json.processor.ConverterInfo;
import com.dslplatform.json.processor.ObjectType;
import com.dslplatform.json.processor.StructInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public class AttributeInfo {
    public final String id;
    public final String name;
    public final ExecutableElement readMethod;
    public final ExecutableElement writeMethod;
    public final VariableElement field;
    public final TypeMirror type;
    public final AnnotationMirror annotation;
    public final Element element;
    public final boolean notNull;
    public final boolean mandatory;
    public final int index;
    public final String alias;
    public final boolean fullMatch;
    public final CompiledJson.TypeSignature typeSignature;
    public final ConverterInfo converter;
    public final boolean isJsonObject;
    public final List<String> alternativeNames = new ArrayList<String>();
    public final String readProperty;
    public final String typeName;
    public final boolean isArray;
    public final boolean isList;

    public AttributeInfo(String name, ExecutableElement readMethod, ExecutableElement writeMethod, VariableElement field, TypeMirror type, AnnotationMirror annotation, boolean notNull, boolean mandatory, int index, String alias, boolean fullMatch, CompiledJson.TypeSignature typeSignature, ConverterInfo converter, boolean isJsonObject) {
        this.id = alias != null ? alias : name;
        this.name = name;
        this.readMethod = readMethod;
        this.writeMethod = writeMethod;
        this.field = field;
        this.element = field != null ? field : readMethod;
        this.type = type;
        this.annotation = annotation;
        this.notNull = notNull;
        this.mandatory = mandatory;
        this.index = index;
        this.alias = alias;
        this.fullMatch = fullMatch;
        this.typeSignature = typeSignature;
        this.converter = converter;
        this.isJsonObject = isJsonObject;
        this.typeName = ((Object)type).toString();
        this.readProperty = field != null ? field.getSimpleName().toString() : readMethod.getSimpleName() + "()";
        this.isArray = type.getKind() == TypeKind.ARRAY;
        this.isList = this.typeName.startsWith("java.util.List<") || this.typeName.startsWith("java.util.ArrayList<");
    }

    public boolean isEnum(Map<String, StructInfo> structs) {
        StructInfo struct = this.typeName == null ? null : structs.get(this.typeName);
        return struct != null && struct.type == ObjectType.ENUM;
    }

    public String collectionContent(Set<String> knownTypes) {
        if (this.isArray) {
            String content = this.typeName.substring(0, this.typeName.length() - 2);
            return knownTypes.contains(content) ? content : null;
        }
        if (this.isList) {
            int ind = this.typeName.indexOf(60);
            String content = this.typeName.substring(ind + 1, this.typeName.length() - 1);
            return knownTypes.contains(content) ? content : null;
        }
        return null;
    }
}

