/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.json;

import com.dslplatform.json.BinaryConverter;
import com.dslplatform.json.DslJson;
import com.dslplatform.json.JsonReader;
import com.dslplatform.json.JsonWriter;
import com.dslplatform.json.Nullable;
import com.dslplatform.json.NumberConverter;
import com.dslplatform.json.SerializationException;
import com.dslplatform.json.StringConverter;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.imageio.ImageIO;

public abstract class JavaGeomConverter {
    private static final JsonReader.ReadObject<Point2D.Double> LOCATION_READER = new JsonReader.ReadObject<Point2D.Double>(){

        @Override
        @Nullable
        public Point2D.Double read(JsonReader reader) throws IOException {
            return reader.wasNull() ? null : JavaGeomConverter.deserializeLocation(reader);
        }
    };
    private static final JsonReader.ReadObject<Point> POINT_READER = new JsonReader.ReadObject<Point>(){

        @Override
        @Nullable
        public Point read(JsonReader reader) throws IOException {
            return reader.wasNull() ? null : JavaGeomConverter.deserializePoint(reader);
        }
    };
    private static final JsonReader.ReadObject<Rectangle2D.Double> RECTANGLE_READER = new JsonReader.ReadObject<Rectangle2D.Double>(){

        @Override
        @Nullable
        public Rectangle2D.Double read(JsonReader reader) throws IOException {
            return reader.wasNull() ? null : JavaGeomConverter.deserializeRectangle(reader);
        }
    };
    private static final JsonReader.ReadObject<BufferedImage> IMAGE_READER = new JsonReader.ReadObject<BufferedImage>(){

        @Override
        @Nullable
        public BufferedImage read(JsonReader reader) throws IOException {
            return reader.wasNull() ? null : JavaGeomConverter.deserializeImage(reader);
        }
    };

    static <T> void registerDefault(DslJson<T> json) {
        json.registerReader(Point2D.Double.class, LOCATION_READER);
        json.registerReader(Point2D.class, LOCATION_READER);
        json.registerWriter(Point2D.class, (writer, value) -> JavaGeomConverter.serializeLocationNullable(value, writer));
        json.registerReader(Point.class, POINT_READER);
        json.registerWriter(Point.class, (writer, value) -> JavaGeomConverter.serializePointNullable(value, writer));
        json.registerReader(Rectangle2D.Double.class, RECTANGLE_READER);
        json.registerReader(Rectangle2D.class, RECTANGLE_READER);
        json.registerWriter(Rectangle2D.class, (writer, value) -> JavaGeomConverter.serializeRectangleNullable(value, writer));
        json.registerReader(BufferedImage.class, IMAGE_READER);
        json.registerReader(Image.class, IMAGE_READER);
        json.registerWriter(Image.class, (writer, value) -> JavaGeomConverter.serialize(value, writer));
    }

    public static void serializeLocationNullable(@Nullable Point2D value, JsonWriter sw) {
        if (value == null) {
            sw.writeNull();
        } else {
            JavaGeomConverter.serializeLocation(value, sw);
        }
    }

    public static void serializeLocation(Point2D value, JsonWriter sw) {
        sw.writeAscii("{\"X\":");
        NumberConverter.serialize(value.getX(), sw);
        sw.writeAscii(",\"Y\":");
        NumberConverter.serialize(value.getY(), sw);
        sw.writeByte((byte)125);
    }

    public static Point2D.Double deserializeLocation(JsonReader reader) throws IOException {
        if (reader.last() != 123) {
            throw reader.newParseError("Expecting '{' for object start");
        }
        byte nextToken = reader.getNextToken();
        if (nextToken == 125) {
            return new Point2D.Double();
        }
        double x = 0.0;
        double y = 0.0;
        String name = StringConverter.deserialize(reader);
        nextToken = reader.getNextToken();
        if (nextToken != 58) {
            throw reader.newParseError("Expecting ':' after attribute name");
        }
        reader.getNextToken();
        double value = NumberConverter.deserializeDouble(reader);
        if ("X".equalsIgnoreCase(name)) {
            x = value;
        } else if ("Y".equalsIgnoreCase(name)) {
            y = value;
        }
        while ((nextToken = reader.getNextToken()) == 44) {
            reader.getNextToken();
            name = StringConverter.deserialize(reader);
            nextToken = reader.getNextToken();
            if (nextToken != 58) {
                throw reader.newParseError("Expecting ':' after attribute name");
            }
            reader.getNextToken();
            value = NumberConverter.deserializeDouble(reader);
            if ("X".equalsIgnoreCase(name)) {
                x = value;
                continue;
            }
            if (!"Y".equalsIgnoreCase(name)) continue;
            y = value;
        }
        if (nextToken != 125) {
            throw reader.newParseError("Expecting '}' for object end");
        }
        return new Point2D.Double(x, y);
    }

    public static ArrayList<Point2D> deserializeLocationCollection(JsonReader reader) throws IOException {
        ArrayList<Point2D> res = new ArrayList<Point2D>(4);
        reader.deserializeCollection(LOCATION_READER, res);
        return res;
    }

    public static void deserializeLocationCollection(JsonReader reader, Collection<Point2D> res) throws IOException {
        reader.deserializeCollection(LOCATION_READER, res);
    }

    public static ArrayList<Point2D> deserializeLocationNullableCollection(JsonReader reader) throws IOException {
        ArrayList<Point2D> res = new ArrayList<Point2D>(4);
        reader.deserializeNullableCollection(LOCATION_READER, res);
        return res;
    }

    public static void deserializeLocationNullableCollection(JsonReader reader, Collection<Point2D> res) throws IOException {
        reader.deserializeNullableCollection(LOCATION_READER, res);
    }

    public static void serializePointNullable(@Nullable Point value, JsonWriter sw) {
        if (value == null) {
            sw.writeNull();
        } else {
            JavaGeomConverter.serializePoint(value, sw);
        }
    }

    public static void serializePoint(Point value, JsonWriter sw) {
        sw.writeAscii("{\"X\":");
        NumberConverter.serialize(value.x, sw);
        sw.writeAscii(",\"Y\":");
        NumberConverter.serialize(value.y, sw);
        sw.writeByte((byte)125);
    }

    public static Point deserializePoint(JsonReader reader) throws IOException {
        if (reader.last() != 123) {
            throw reader.newParseError("Expecting '{' for object start");
        }
        byte nextToken = reader.getNextToken();
        if (nextToken == 125) {
            return new Point();
        }
        int x = 0;
        int y = 0;
        String name = StringConverter.deserialize(reader);
        nextToken = reader.getNextToken();
        if (nextToken != 58) {
            throw reader.newParseError("Expecting ':' after attribute name");
        }
        reader.getNextToken();
        int value = NumberConverter.deserializeInt(reader);
        if ("X".equalsIgnoreCase(name)) {
            x = value;
        } else if ("Y".equalsIgnoreCase(name)) {
            y = value;
        }
        while ((nextToken = reader.getNextToken()) == 44) {
            reader.getNextToken();
            name = StringConverter.deserialize(reader);
            nextToken = reader.getNextToken();
            if (nextToken != 58) {
                throw reader.newParseError("Expecting ':' after attribute name");
            }
            reader.getNextToken();
            value = NumberConverter.deserializeInt(reader);
            if ("X".equalsIgnoreCase(name)) {
                x = value;
                continue;
            }
            if (!"Y".equalsIgnoreCase(name)) continue;
            y = value;
        }
        if (nextToken != 125) {
            throw reader.newParseError("Expecting '}' for object end");
        }
        return new Point(x, y);
    }

    public static ArrayList<Point> deserializePointCollection(JsonReader reader) throws IOException {
        return reader.deserializeCollection(POINT_READER);
    }

    public static void deserializePointCollection(JsonReader reader, Collection<Point> res) throws IOException {
        reader.deserializeCollection(POINT_READER, res);
    }

    public static ArrayList<Point> deserializePointNullableCollection(JsonReader reader) throws IOException {
        return reader.deserializeNullableCollection(POINT_READER);
    }

    public static void deserializePointNullableCollection(JsonReader reader, Collection<Point> res) throws IOException {
        reader.deserializeNullableCollection(POINT_READER, res);
    }

    public static void serializeRectangleNullable(@Nullable Rectangle2D value, JsonWriter sw) {
        if (value == null) {
            sw.writeNull();
        } else {
            JavaGeomConverter.serializeRectangle(value, sw);
        }
    }

    public static void serializeRectangle(Rectangle2D value, JsonWriter sw) {
        sw.writeAscii("{\"X\":");
        NumberConverter.serialize(value.getX(), sw);
        sw.writeAscii(",\"Y\":");
        NumberConverter.serialize(value.getY(), sw);
        sw.writeAscii(",\"Width\":");
        NumberConverter.serialize(value.getWidth(), sw);
        sw.writeAscii(",\"Height\":");
        NumberConverter.serialize(value.getHeight(), sw);
        sw.writeByte((byte)125);
    }

    public static Rectangle2D.Double deserializeRectangle(JsonReader reader) throws IOException {
        if (reader.last() != 123) {
            throw reader.newParseError("Expecting '{' for object start");
        }
        byte nextToken = reader.getNextToken();
        if (nextToken == 125) {
            return new Rectangle2D.Double();
        }
        double x = 0.0;
        double y = 0.0;
        double width = 0.0;
        double height = 0.0;
        String name = StringConverter.deserialize(reader);
        nextToken = reader.getNextToken();
        if (nextToken != 58) {
            throw reader.newParseError("Expecting ':' after attribute name");
        }
        reader.getNextToken();
        double value = NumberConverter.deserializeDouble(reader);
        if ("X".equalsIgnoreCase(name)) {
            x = value;
        } else if ("Y".equalsIgnoreCase(name)) {
            y = value;
        } else if ("Width".equalsIgnoreCase(name)) {
            width = value;
        } else if ("Height".equalsIgnoreCase(name)) {
            height = value;
        }
        while ((nextToken = reader.getNextToken()) == 44) {
            reader.getNextToken();
            name = StringConverter.deserialize(reader);
            nextToken = reader.getNextToken();
            if (nextToken != 58) {
                throw reader.newParseError("Expecting ':' after attribute name");
            }
            reader.getNextToken();
            value = NumberConverter.deserializeDouble(reader);
            if ("X".equalsIgnoreCase(name)) {
                x = value;
                continue;
            }
            if ("Y".equalsIgnoreCase(name)) {
                y = value;
                continue;
            }
            if ("Width".equalsIgnoreCase(name)) {
                width = value;
                continue;
            }
            if (!"Height".equalsIgnoreCase(name)) continue;
            height = value;
        }
        if (nextToken != 125) {
            throw reader.newParseError("Expecting '}' for object end");
        }
        return new Rectangle2D.Double(x, y, width, height);
    }

    public static ArrayList<Rectangle2D> deserializeRectangleCollection(JsonReader reader) throws IOException {
        ArrayList<Rectangle2D> res = new ArrayList<Rectangle2D>(4);
        reader.deserializeCollection(RECTANGLE_READER, res);
        return res;
    }

    public static void deserializeRectangleCollection(JsonReader reader, Collection<Rectangle2D> res) throws IOException {
        reader.deserializeCollection(RECTANGLE_READER, res);
    }

    public static ArrayList<Rectangle2D> deserializeRectangleNullableCollection(JsonReader reader) throws IOException {
        ArrayList<Rectangle2D> res = new ArrayList<Rectangle2D>(4);
        reader.deserializeNullableCollection(RECTANGLE_READER, res);
        return res;
    }

    public static void deserializeRectangleNullableCollection(JsonReader reader, Collection<Rectangle2D> res) throws IOException {
        reader.deserializeNullableCollection(RECTANGLE_READER, res);
    }

    public static void serialize(@Nullable Image value, JsonWriter sw) {
        RenderedImage image;
        if (value == null) {
            sw.writeNull();
            return;
        }
        if (value instanceof RenderedImage) {
            image = (RenderedImage)((Object)value);
        } else {
            BufferedImage bufferedImage = new BufferedImage(value.getWidth(null), value.getHeight(null), 6);
            Graphics2D bGr = bufferedImage.createGraphics();
            bGr.drawImage(value, 0, 0, null);
            bGr.dispose();
            image = bufferedImage;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write(image, "png", baos);
            BinaryConverter.serialize(baos.toByteArray(), sw);
        }
        catch (IOException e) {
            throw new SerializationException(e);
        }
    }

    public static BufferedImage deserializeImage(JsonReader reader) throws IOException {
        byte[] content = BinaryConverter.deserialize(reader);
        return ImageIO.read(new ByteArrayInputStream(content));
    }

    public static ArrayList<BufferedImage> deserializeImageCollection(JsonReader reader) throws IOException {
        return reader.deserializeCollection(IMAGE_READER);
    }

    public static void deserializeImageCollection(JsonReader reader, Collection<BufferedImage> res) throws IOException {
        reader.deserializeCollection(IMAGE_READER, res);
    }

    public static ArrayList<BufferedImage> deserializeImageNullableCollection(JsonReader reader) throws IOException {
        return reader.deserializeNullableCollection(IMAGE_READER);
    }

    public static void deserializeImageNullableCollection(JsonReader reader, Collection<BufferedImage> res) throws IOException {
        reader.deserializeNullableCollection(IMAGE_READER, res);
    }
}

