/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.json.processor;

import com.dslplatform.json.Nullable;
import com.dslplatform.json.processor.Analysis;
import com.dslplatform.json.processor.AttributeInfo;
import com.dslplatform.json.processor.ObjectType;
import com.dslplatform.json.processor.OptimizedConverter;
import com.dslplatform.json.processor.StructInfo;
import com.dslplatform.json.processor.TypeSupport;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;

final class Context {
    final Writer code;
    private final ProcessingEnvironment environment;
    final Map<String, OptimizedConverter> inlinedConverters;
    final Map<String, String> defaults;
    final Map<String, StructInfo> structs;
    final TypeSupport typeSupport;
    final boolean allowUnknown;

    Context(Writer code, ProcessingEnvironment environment, Map<String, OptimizedConverter> inlinedConverters, Map<String, String> defaults, Map<String, StructInfo> structs, TypeSupport typeSupport, boolean allowUnknown) {
        this.code = code;
        this.environment = environment;
        this.inlinedConverters = inlinedConverters;
        this.defaults = defaults;
        this.structs = structs;
        this.typeSupport = typeSupport;
        this.allowUnknown = allowUnknown;
    }

    String getDefault(AttributeInfo attr) {
        String type = attr.typeName;
        String defVal = this.defaults.get(type);
        if (defVal != null) {
            return defVal;
        }
        int genIndex = type.indexOf(60);
        if (genIndex != -1 && (defVal = this.defaults.get(type.substring(0, genIndex))) != null) {
            return defVal;
        }
        if (!attr.notNull) {
            return "null";
        }
        OptimizedConverter converter = this.inlinedConverters.get(type);
        if (converter != null && converter.defaultValue != null) {
            return converter.defaultValue;
        }
        int arrIndex = type.lastIndexOf(91);
        if (attr.isArray) {
            String rawType = genIndex != -1 ? type.substring(0, genIndex) : (arrIndex != -1 ? type.substring(0, arrIndex) : type);
            return "new " + rawType + "[]{}";
        }
        if (attr.isList && type.startsWith("java.util.List<")) {
            return "java.util.Collections.emptyList()";
        }
        if (attr.isSet && type.startsWith("java.util.Set<")) {
            return "java.util.Collections.emptySet()";
        }
        if (attr.isMap && type.startsWith("java.util.Map<")) {
            return "java.util.Collections.emptyMap()";
        }
        StructInfo target = this.structs.get(attr.typeName);
        if (target != null) {
            if (target.annotatedFactory != null && target.annotatedFactory.getParameters().isEmpty()) {
                return target.annotatedFactory.getEnclosingElement().toString() + "." + target.annotatedFactory.getSimpleName() + "()";
            }
            if (target.converter == null && target.hasEmptyCtor()) {
                return "new " + attr.typeName + "()";
            }
            if (target.type == ObjectType.ENUM && !target.constants.isEmpty()) {
                return attr.typeName + "." + target.constants.get(0);
            }
        }
        return "null";
    }

    static String nonGenericObject(String type) {
        String objectType = Analysis.objectName(type);
        int genInd = objectType.indexOf(60);
        if (genInd == -1) {
            return objectType;
        }
        return objectType.substring(0, genInd);
    }

    static String typeOrClass(String objectType, String typeName) {
        if (objectType.equals(typeName)) {
            return objectType + ".class";
        }
        int genInd = typeName.indexOf(60);
        if (genInd == -1) {
            return typeName + ".class";
        }
        return "new com.dslplatform.json.runtime.TypeDefinition<" + typeName + ">(){}.type";
    }

    static List<AttributeInfo> sortedAttributes(StructInfo info, boolean includeInherited) {
        ExecutableElement factoryOrCtor;
        ArrayList<AttributeInfo> result = new ArrayList<AttributeInfo>(info.attributes.values());
        if (includeInherited) {
            HashSet<String> properties = new HashSet<String>();
            for (AttributeInfo ai : result) {
                properties.add(ai.name);
            }
            for (AttributeInfo ai : info.inheritedAttributes()) {
                if (info.attributes.containsKey(ai.id) || properties.contains(ai.name)) continue;
                result.add(ai);
            }
        }
        result.sort((a, b) -> {
            if (b.index == -1) {
                return -1;
            }
            if (a.index == -1) {
                return 1;
            }
            return a.index - b.index;
        });
        ExecutableElement executableElement = factoryOrCtor = info.annotatedFactory != null ? info.annotatedFactory : info.selectedConstructor();
        if (factoryOrCtor != null && !factoryOrCtor.getParameters().isEmpty()) {
            int firstNonSet;
            for (firstNonSet = 0; firstNonSet < result.size() && result.get((int)firstNonSet).index != -1; ++firstNonSet) {
            }
            block3: for (VariableElement variableElement : factoryOrCtor.getParameters()) {
                for (int i = firstNonSet; i < result.size(); ++i) {
                    AttributeInfo attr = result.get(i);
                    if (!attr.name.equals(variableElement.getSimpleName().toString())) continue;
                    if (firstNonSet != i) {
                        result.remove(i);
                        result.add(firstNonSet, attr);
                    }
                    ++firstNonSet;
                    continue block3;
                }
            }
        }
        return result;
    }

    String extractRawType(TypeMirror type, Map<String, TypeMirror> genericSignatures) {
        TypeMirror mirror;
        if (type.getKind() == TypeKind.DECLARED) {
            return ((DeclaredType)type).asElement().toString();
        }
        String typeName = Analysis.unpackType(type, this.environment.getTypeUtils()).toString();
        if (type.getKind() == TypeKind.TYPEVAR && (mirror = genericSignatures.get(typeName)) != null && mirror != type) {
            return this.extractRawType(mirror, genericSignatures);
        }
        return typeName;
    }

    Types types() {
        return this.environment.getTypeUtils();
    }

    boolean useLazyResolution(String type) {
        OptimizedConverter converter = this.inlinedConverters.get(type);
        StructInfo found = this.structs.get(type);
        return converter == null && found != null && (found.type == ObjectType.MIXIN && this.findType(type) != null || found.hasCycles(this.structs));
    }

    void serializeKnownCollection(AttributeInfo attr, List<String> types, Map<String, TypeMirror> genericSignatures) throws IOException {
        if (attr.isArray) {
            String content = this.extractRawType(((ArrayType)attr.type).getComponentType(), genericSignatures);
            this.code.append("(").append(content).append("[])reader.readArray(reader_").append(attr.name);
            this.code.append(this.useLazyResolution(content) ? "()" : "");
            this.code.append(", emptyArray_").append(attr.name).append(")");
        } else if (attr.isList) {
            this.code.append("reader.readCollection(reader_").append(attr.name).append(this.useLazyResolution(types.get(0)) ? "()" : "").append(")");
        } else if (attr.isSet) {
            this.code.append("reader.readSet(reader_").append(attr.name).append(this.useLazyResolution(types.get(0)) ? "()" : "").append(")");
        } else if (attr.isMap) {
            this.code.append("reader.readMap(key_reader_").append(attr.name).append(this.useLazyResolution(types.get(0)) ? "()" : "");
            this.code.append(", value_reader_").append(attr.name).append(this.useLazyResolution(types.get(1)) ? "()" : "").append(")");
        } else {
            throw new IllegalArgumentException("Unknown attribute collection " + attr.name);
        }
    }

    @Nullable
    TypeMirror findType(String content) {
        TypeElement element = this.environment.getElementUtils().getTypeElement(content);
        return element != null ? element.asType() : null;
    }

    boolean isObjectInstance(AttributeInfo attr) {
        OptimizedConverter converter = this.inlinedConverters.get(attr.typeName);
        if (converter == null) {
            return false;
        }
        StructInfo target = this.structs.get(attr.typeName);
        return target != null && (target.annotatedFactory != null || target.hasEmptyCtor());
    }
}

