/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.json.processor;

import com.dslplatform.json.Nullable;
import java.io.IOException;
import java.io.Writer;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

public class ConverterInfo {
    public final TypeElement converter;
    public final boolean legacyDeclaration;
    public final String fullName;
    public final String reader;
    public final String binder;
    public final String writer;
    public final String targetSignature;
    public final Element targetType;
    private final String readPrefix;
    private final String bindPrefix;
    private final String writePrefix;

    public ConverterInfo(TypeElement converter, boolean legacyDeclaration, String reader, String binder, String writer, String targetSignature, @Nullable Element targetType) {
        this.converter = converter;
        this.legacyDeclaration = legacyDeclaration;
        this.fullName = converter.getQualifiedName().toString();
        this.reader = reader;
        this.binder = binder;
        this.writer = writer;
        this.targetSignature = targetSignature;
        this.targetType = targetType;
        this.readPrefix = ConverterInfo.detectPrefix(legacyDeclaration, reader);
        this.bindPrefix = ConverterInfo.detectPrefix(legacyDeclaration, binder);
        this.writePrefix = ConverterInfo.detectPrefix(legacyDeclaration, writer);
    }

    private static String detectPrefix(boolean legacy, String target) {
        if (legacy) {
            return "." + target;
        }
        int ind = target.lastIndexOf(46);
        return ind != -1 ? "." + target.substring(0, ind) : "";
    }

    public void read(Writer code) throws IOException {
        code.append(this.fullName).append(this.readPrefix);
    }

    public void bind(Writer code) throws IOException {
        code.append(this.fullName).append(this.bindPrefix);
    }

    public void write(Writer code) throws IOException {
        code.append(this.fullName).append(this.writePrefix);
    }
}

