/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.json.processor;

import com.dslplatform.json.processor.AttributeInfo;
import com.dslplatform.json.processor.NamingStrategy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class MinifiedNaming
implements NamingStrategy {
    private static String buildShortName(String name, Set<String> names, Map<Character, Integer> counters) {
        String shortName = name.substring(0, 1);
        Character first = Character.valueOf(name.charAt(0));
        if (!names.contains(shortName)) {
            names.add(shortName);
            counters.put(first, 0);
            return shortName;
        }
        Integer next = counters.get(first);
        if (next == null) {
            next = 0;
        }
        do {
            shortName = first.toString() + next;
            Integer n = next;
            Integer n2 = next = Integer.valueOf(next + 1);
        } while (names.contains(shortName));
        counters.put(first, next);
        names.add(shortName);
        return shortName;
    }

    @Override
    public Map<String, String> prepareNames(Map<String, AttributeInfo> attributes) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        HashMap<Character, Integer> counters = new HashMap<Character, Integer>();
        HashSet<String> processed = new HashSet<String>();
        HashSet<String> names = new HashSet<String>();
        for (AttributeInfo p : attributes.values()) {
            if (p.alias == null) continue;
            result.put(p.id, p.alias);
            processed.add(p.id);
            names.add(p.alias);
        }
        for (AttributeInfo p : attributes.values()) {
            if (processed.contains(p.id)) continue;
            String shortName = MinifiedNaming.buildShortName(p.id, names, counters);
            result.put(p.id, shortName);
        }
        return result;
    }
}

