/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.json.runtime;

import com.dslplatform.json.ConfigurationException;
import com.dslplatform.json.DslJson;
import com.dslplatform.json.JsonWriter;
import com.dslplatform.json.Nullable;
import com.dslplatform.json.runtime.ExplicitDescription;

public final class ArrayEncoder<T>
implements JsonWriter.WriteObject<T[]>,
ExplicitDescription {
    private final DslJson json;
    private final JsonWriter.WriteObject<T> encoder;
    private Class<?> lastCachedClass;
    private JsonWriter.WriteObject lastCachedWriter;
    private static final byte[] EMPTY = new byte[]{91, 93};

    public ArrayEncoder(DslJson json, @Nullable JsonWriter.WriteObject<T> encoder) {
        if (json == null) {
            throw new IllegalArgumentException("json can't be null");
        }
        this.json = json;
        this.encoder = encoder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(JsonWriter writer, @Nullable T[] value) {
        if (value == null) {
            writer.writeNull();
        } else if (value.length == 0) {
            writer.writeAscii(EMPTY);
        } else if (this.encoder != null) {
            writer.writeByte((byte)91);
            this.encoder.write(writer, value[0]);
            for (int i = 1; i < value.length; ++i) {
                writer.writeByte((byte)44);
                this.encoder.write(writer, value[i]);
            }
            writer.writeByte((byte)93);
        } else {
            boolean pastFirst = false;
            writer.writeByte((byte)91);
            Class<?> lastClass = null;
            JsonWriter.WriteObject<?> lastEncoder = null;
            for (T e : value) {
                if (pastFirst) {
                    writer.writeByte((byte)44);
                } else {
                    pastFirst = true;
                }
                if (e == null) {
                    writer.writeNull();
                    continue;
                }
                Class<?> currentClass = e.getClass();
                if (currentClass == this.lastCachedClass) {
                    lastEncoder = this.lastCachedWriter;
                    lastClass = this.lastCachedClass;
                } else if (currentClass != lastClass) {
                    lastClass = currentClass;
                    lastEncoder = this.json.tryFindWriter(lastClass);
                    if (lastEncoder == null) {
                        throw new ConfigurationException("Unable to find writer for " + lastClass);
                    }
                    if (this.lastCachedClass == null) {
                        ArrayEncoder arrayEncoder = this;
                        synchronized (arrayEncoder) {
                            if (this.lastCachedClass == null) {
                                this.lastCachedWriter = lastEncoder;
                                this.lastCachedClass = lastClass;
                            }
                        }
                    }
                }
                lastEncoder.write(writer, e);
            }
            writer.writeByte((byte)93);
        }
    }
}

