/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.json.runtime;

import com.dslplatform.json.DslJson;
import com.dslplatform.json.JsonReader;
import com.dslplatform.json.JsonWriter;
import com.dslplatform.json.Nullable;
import com.dslplatform.json.runtime.DecodePropertyInfo;
import com.dslplatform.json.runtime.FormatConverter;
import com.dslplatform.json.runtime.InstanceFactory;
import com.dslplatform.json.runtime.Reflection;
import com.dslplatform.json.runtime.Settings;
import com.dslplatform.json.runtime.WriteDescription;
import java.io.IOException;
import java.lang.reflect.Type;

public final class ObjectFormatDescription<B, T>
extends WriteDescription<T>
implements FormatConverter<T>,
JsonReader.BindObject<B> {
    private final Type manifest;
    private final InstanceFactory<B> newInstance;
    private final Settings.Function<B, T> finalize;
    private final DecodePropertyInfo<JsonReader.BindObject>[] decoders;
    private final boolean skipOnUnknown;
    private final boolean hasMandatory;
    private final long mandatoryFlag;
    private final String startError;
    private final String endError;
    private static final Settings.Function identity = new Settings.Function(){

        public Object apply(@Nullable Object t) {
            return t;
        }
    };

    public static <D> ObjectFormatDescription<D, D> create(Class<D> manifest, InstanceFactory<D> newInstance, JsonWriter.WriteObject[] encoders, DecodePropertyInfo<JsonReader.BindObject>[] decoders, DslJson json, boolean skipOnUnknown) {
        return new ObjectFormatDescription(manifest, newInstance, identity, encoders, decoders, json, skipOnUnknown);
    }

    public ObjectFormatDescription(Type manifest, InstanceFactory<B> newInstance, Settings.Function<B, T> finalize, JsonWriter.WriteObject[] encoders, DecodePropertyInfo<JsonReader.BindObject>[] decoders, DslJson json, boolean skipOnUnknown) {
        super(encoders, !json.omitDefaults);
        if (manifest == null) {
            throw new IllegalArgumentException("manifest can't be null");
        }
        if (newInstance == null) {
            throw new IllegalArgumentException("create can't be null");
        }
        if (finalize == null) {
            throw new IllegalArgumentException("finalize can't be null");
        }
        if (decoders == null) {
            throw new IllegalArgumentException("decoders can't be null");
        }
        this.manifest = manifest;
        this.newInstance = newInstance;
        this.finalize = finalize;
        this.decoders = DecodePropertyInfo.prepare(decoders, decoders.length);
        this.skipOnUnknown = skipOnUnknown;
        this.mandatoryFlag = DecodePropertyInfo.calculateMandatory(this.decoders);
        this.hasMandatory = this.mandatoryFlag != 0L;
        this.startError = String.format("Expecting '{' to start decoding %s", Reflection.typeDescription(manifest));
        this.endError = String.format("Expecting '}' or ',' while decoding %s", Reflection.typeDescription(manifest));
    }

    @Override
    @Nullable
    public T read(JsonReader reader) throws IOException {
        if (reader.wasNull()) {
            return null;
        }
        if (reader.last() != 123) {
            throw reader.newParseError(this.startError);
        }
        reader.getNextToken();
        return this.readContent(reader);
    }

    @Override
    public B bind(JsonReader reader, B instance) throws IOException {
        if (reader.last() != 123) {
            throw reader.newParseError(this.startError);
        }
        reader.getNextToken();
        this.bindContent(reader, instance);
        return instance;
    }

    @Override
    public T readContent(JsonReader reader) throws IOException {
        B instance = this.newInstance.create();
        this.bindContent(reader, instance);
        return this.finalize.apply(instance);
    }

    private void bindContent(JsonReader reader, B instance) throws IOException {
        if (reader.last() == 125) {
            if (this.hasMandatory) {
                DecodePropertyInfo.showMandatoryError(reader, this.mandatoryFlag, this.decoders);
            }
            return;
        }
        long currentMandatory = this.mandatoryFlag;
        int i = 0;
        while (i < this.decoders.length) {
            DecodePropertyInfo<JsonReader.BindObject> ri = this.decoders[i++];
            int weakHash = reader.fillNameWeakHash();
            if (weakHash != ri.weakHash || !reader.wasLastName(ri.nameBytes)) {
                this.bindObjectSlow(reader, instance, currentMandatory);
                return;
            }
            reader.getNextToken();
            if (ri.nonNull && reader.wasNull()) {
                throw reader.newParseErrorWith("Null value found for non-null attribute", ri.name);
            }
            ((JsonReader.BindObject)ri.value).bind(reader, instance);
            currentMandatory &= ri.mandatoryValue;
            if (reader.getNextToken() != 44 || i == this.decoders.length) break;
            reader.getNextToken();
        }
        this.finalChecks(reader, instance, currentMandatory);
    }

    private void bindObjectSlow(JsonReader reader, B instance, long currentMandatory) throws IOException {
        boolean processed = false;
        int oldHash = reader.getLastHash();
        for (DecodePropertyInfo<JsonReader.BindObject> ri : this.decoders) {
            if (oldHash != ri.hash || ri.exactName && !reader.wasLastName(ri.nameBytes)) continue;
            reader.getNextToken();
            if (ri.nonNull && reader.wasNull()) {
                throw reader.newParseErrorWith("Null value found for non-null attribute", ri.name);
            }
            ((JsonReader.BindObject)ri.value).bind(reader, instance);
            currentMandatory &= ri.mandatoryValue;
            processed = true;
            break;
        }
        if (!processed) {
            this.skip(reader);
        } else {
            reader.getNextToken();
        }
        while (reader.last() == 44) {
            reader.getNextToken();
            int hash = reader.fillName();
            processed = false;
            for (DecodePropertyInfo<JsonReader.BindObject> ri : this.decoders) {
                if (hash != ri.hash || ri.exactName && !reader.wasLastName(ri.nameBytes)) continue;
                reader.getNextToken();
                if (ri.nonNull && reader.wasNull()) {
                    throw reader.newParseErrorWith("Null value found for non-null attribute", ri.name);
                }
                ((JsonReader.BindObject)ri.value).bind(reader, instance);
                currentMandatory &= ri.mandatoryValue;
                processed = true;
                break;
            }
            if (!processed) {
                this.skip(reader);
                continue;
            }
            reader.getNextToken();
        }
        this.finalChecks(reader, instance, currentMandatory);
    }

    private void finalChecks(JsonReader reader, B instance, long currentMandatory) throws IOException {
        if (reader.last() != 125) {
            if (reader.last() == 44) {
                reader.getNextToken();
                reader.fillNameWeakHash();
                this.bindObjectSlow(reader, instance, currentMandatory);
                return;
            }
            throw reader.newParseError(this.endError);
        }
        if (this.hasMandatory && currentMandatory != 0L) {
            DecodePropertyInfo.showMandatoryError(reader, currentMandatory, this.decoders);
        }
    }

    private void skip(JsonReader reader) throws IOException {
        if (!this.skipOnUnknown) {
            String name = reader.getLastName();
            throw reader.newParseErrorFormat("Unknown property detected", name.length() + 3, "Unknown property detected: '%s' while reading %s", name, Reflection.typeDescription(this.manifest));
        }
        reader.getNextToken();
        reader.skip();
    }
}

