/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.json;

import com.dslplatform.json.DslJson;
import com.dslplatform.json.JsonReader;
import com.dslplatform.json.JsonWriter;
import com.dslplatform.json.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public abstract class BinaryConverter {
    public static final JsonReader.ReadObject<byte[]> READER = new JsonReader.ReadObject<byte[]>(){

        @Override
        @Nullable
        public byte[] read(JsonReader reader) throws IOException {
            return reader.wasNull() ? null : BinaryConverter.deserialize(reader);
        }
    };
    public static final JsonWriter.WriteObject<byte[]> WRITER = (writer, value) -> BinaryConverter.serialize(value, writer);
    public static final byte[] EMPTY_ARRAY = new byte[0];

    static <T> void registerDefault(DslJson<T> json) {
        json.registerReader(byte[].class, READER);
        json.registerWriter(byte[].class, (writer, value) -> BinaryConverter.serialize(value, writer));
    }

    public static void serialize(@Nullable byte[] value, JsonWriter sw) {
        if (value == null) {
            sw.writeNull();
        } else if (value.length == 0) {
            sw.writeAscii("\"\"");
        } else {
            sw.writeBinary(value);
        }
    }

    public static byte[] deserialize(JsonReader reader) throws IOException {
        return reader.readBase64();
    }

    public static ArrayList<byte[]> deserializeCollection(JsonReader reader) throws IOException {
        return reader.deserializeCollection(READER);
    }

    public static void deserializeCollection(JsonReader reader, Collection<byte[]> res) throws IOException {
        reader.deserializeCollection(READER, res);
    }

    public static ArrayList<byte[]> deserializeNullableCollection(JsonReader reader) throws IOException {
        return reader.deserializeNullableCollection(READER);
    }

    public static void deserializeNullableCollection(JsonReader reader, Collection<byte[]> res) throws IOException {
        reader.deserializeNullableCollection(READER, res);
    }
}

