/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.json;

import com.dslplatform.json.DslJson;
import com.dslplatform.json.JsonReader;
import com.dslplatform.json.JsonWriter;
import com.dslplatform.json.Nullable;
import com.dslplatform.json.StringConverter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;

public abstract class NetConverter {
    private static final JsonReader.ReadObject<URI> URI_READER = new JsonReader.ReadObject<URI>(){

        @Override
        @Nullable
        public URI read(JsonReader reader) throws IOException {
            return reader.wasNull() ? null : NetConverter.deserializeUri(reader);
        }
    };
    private static final JsonReader.ReadObject<InetAddress> ADDRESS_READER = new JsonReader.ReadObject<InetAddress>(){

        @Override
        @Nullable
        public InetAddress read(JsonReader reader) throws IOException {
            return reader.wasNull() ? null : NetConverter.deserializeIp(reader);
        }
    };

    static <T> void registerDefault(DslJson<T> json) {
        json.registerReader(URI.class, URI_READER);
        json.registerWriter(URI.class, (writer, value) -> NetConverter.serializeNullable(value, writer));
        json.registerReader(InetAddress.class, ADDRESS_READER);
        json.registerWriter(InetAddress.class, (writer, value) -> NetConverter.serializeNullable(value, writer));
    }

    public static void serializeNullable(@Nullable URI value, JsonWriter sw) {
        if (value == null) {
            sw.writeNull();
        } else {
            NetConverter.serialize(value, sw);
        }
    }

    public static void serialize(URI value, JsonWriter sw) {
        StringConverter.serializeShort(value.toString(), sw);
    }

    public static URI deserializeUri(JsonReader reader) throws IOException {
        return URI.create(reader.readString());
    }

    public static ArrayList<URI> deserializeUriCollection(JsonReader reader) throws IOException {
        return reader.deserializeCollection(URI_READER);
    }

    public static void deserializeUriCollection(JsonReader reader, Collection<URI> res) throws IOException {
        reader.deserializeCollection(URI_READER, res);
    }

    public static ArrayList<URI> deserializeUriNullableCollection(JsonReader reader) throws IOException {
        return reader.deserializeNullableCollection(URI_READER);
    }

    public static void deserializeUriNullableCollection(JsonReader reader, Collection<URI> res) throws IOException {
        reader.deserializeNullableCollection(URI_READER, res);
    }

    public static void serializeNullable(@Nullable InetAddress value, JsonWriter sw) {
        if (value == null) {
            sw.writeNull();
        } else {
            NetConverter.serialize(value, sw);
        }
    }

    public static void serialize(InetAddress value, JsonWriter sw) {
        sw.writeByte((byte)34);
        sw.writeAscii(value.getHostAddress());
        sw.writeByte((byte)34);
    }

    public static InetAddress deserializeIp(JsonReader reader) throws IOException {
        return InetAddress.getByName(reader.readSimpleString());
    }

    public static ArrayList<InetAddress> deserializeIpCollection(JsonReader reader) throws IOException {
        return reader.deserializeCollection(ADDRESS_READER);
    }

    public static void deserializeIpCollection(JsonReader reader, Collection<InetAddress> res) throws IOException {
        reader.deserializeCollection(ADDRESS_READER, res);
    }

    public static ArrayList<InetAddress> deserializeIpNullableCollection(JsonReader reader) throws IOException {
        return reader.deserializeNullableCollection(ADDRESS_READER);
    }

    public static void deserializeIpNullableCollection(JsonReader reader, Collection<InetAddress> res) throws IOException {
        reader.deserializeNullableCollection(ADDRESS_READER, res);
    }
}

