/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.json.runtime;

import com.dslplatform.json.DslJson;
import com.dslplatform.json.Nullable;
import com.dslplatform.json.runtime.EnumDescription;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;

public abstract class EnumAnalyzer {
    public static final DslJson.ConverterFactory<EnumDescription> CONVERTER = new DslJson.ConverterFactory<EnumDescription>(){

        @Override
        @Nullable
        public EnumDescription tryCreate(Type manifest, DslJson dslJson) {
            ParameterizedType pt;
            if (manifest instanceof Class && ((Class)manifest).isEnum()) {
                return EnumAnalyzer.analyze(manifest, (Class)manifest, dslJson);
            }
            if (manifest instanceof ParameterizedType && (pt = (ParameterizedType)manifest).getActualTypeArguments().length == 1 && ((Class)pt.getRawType()).isEnum()) {
                return EnumAnalyzer.analyze(manifest, (Class)pt.getRawType(), dslJson);
            }
            return null;
        }
    };

    @Nullable
    private static EnumDescription analyze(Type manifest, Class<Enum> raw, DslJson json) {
        if (raw.isArray() || Collection.class.isAssignableFrom(raw) || (raw.getModifiers() & 0x400) != 0 || raw.getDeclaringClass() != null && (raw.getModifiers() & 8) == 0) {
            return null;
        }
        EnumDescription converter = new EnumDescription(raw, raw.getEnumConstants());
        json.registerWriter(manifest, converter);
        json.registerReader(manifest, converter);
        return converter;
    }
}

