/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.json.runtime;

import com.dslplatform.json.ConfigurationException;
import com.dslplatform.json.DslJson;
import com.dslplatform.json.JsonWriter;
import com.dslplatform.json.Nullable;
import com.dslplatform.json.runtime.Settings;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;

class LazyAttributeObjectEncoder<T, R>
implements JsonWriter.WriteObject<T> {
    private final Settings.Function<T, R> read;
    private final byte[] quotedName;
    private final boolean alwaysSerialize;
    private JsonWriter.WriteObject<R> encoder;
    private final Object defaultValue;
    private final DslJson json;
    private final Type type;

    LazyAttributeObjectEncoder(Settings.Function<T, R> read, String name, DslJson json, @Nullable Type type) {
        if (read == null) {
            throw new IllegalArgumentException("read can't be null");
        }
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("name can't be null");
        }
        if (json == null) {
            throw new IllegalArgumentException("json can't be null");
        }
        this.read = read;
        this.quotedName = ("\"" + name + "\":").getBytes(StandardCharsets.UTF_8);
        this.alwaysSerialize = !json.omitDefaults;
        this.json = json;
        this.type = type;
        this.defaultValue = json.getDefault(type);
    }

    @Override
    public void write(JsonWriter writer, @Nullable T value) {
        if (this.type != null && this.encoder == null) {
            this.encoder = this.json.tryFindWriter(this.type);
            if (this.encoder == null) {
                throw new ConfigurationException("Unable to find writer for " + this.type);
            }
        }
        R attr = this.read.apply(value);
        if (this.type == null) {
            if (attr == null) {
                if (this.alwaysSerialize) {
                    writer.writeAscii(this.quotedName);
                    writer.writeNull();
                }
            } else {
                Object tmpDefault;
                Class<?> manifest = attr.getClass();
                JsonWriter.WriteObject<?> tmp = this.json.tryFindWriter(manifest);
                if (tmp == null) {
                    throw new ConfigurationException("Unable to find writer for " + manifest);
                }
                if (!this.alwaysSerialize && attr == (tmpDefault = this.json.getDefault(manifest))) {
                    return;
                }
                writer.writeAscii(this.quotedName);
                tmp.write(writer, attr);
            }
        } else if (this.alwaysSerialize || attr != this.defaultValue) {
            writer.writeAscii(this.quotedName);
            this.encoder.write(writer, attr);
        }
    }
}

