/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.json.runtime;

import com.dslplatform.json.DslJson;
import com.dslplatform.json.JsonReader;
import com.dslplatform.json.JsonWriter;
import com.dslplatform.json.Nullable;
import com.dslplatform.json.ObjectConverter;
import com.dslplatform.json.runtime.MapDecoder;
import com.dslplatform.json.runtime.MapEncoder;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;

public abstract class MapAnalyzer {
    private static final JsonReader.ReadObject<String> stringReader = new JsonReader.ReadObject<String>(){

        @Override
        @Nullable
        public String read(JsonReader reader) throws IOException {
            return reader.wasNull() ? null : reader.readString();
        }
    };
    public static final DslJson.ConverterFactory<MapDecoder> READER = new DslJson.ConverterFactory<MapDecoder>(){

        @Override
        @Nullable
        public MapDecoder tryCreate(Type manifest, DslJson dslJson) {
            ParameterizedType pt;
            if (manifest instanceof Class) {
                return MapAnalyzer.analyzeDecoder(manifest, Object.class, Object.class, (Class)manifest, dslJson);
            }
            if (manifest instanceof ParameterizedType && (pt = (ParameterizedType)manifest).getActualTypeArguments().length == 2) {
                return MapAnalyzer.analyzeDecoder(manifest, pt.getActualTypeArguments()[0], pt.getActualTypeArguments()[1], (Class)pt.getRawType(), dslJson);
            }
            return null;
        }
    };
    public static final DslJson.ConverterFactory<MapEncoder> WRITER = new DslJson.ConverterFactory<MapEncoder>(){

        @Override
        @Nullable
        public MapEncoder tryCreate(Type manifest, DslJson dslJson) {
            ParameterizedType pt;
            if (manifest instanceof Class) {
                return MapAnalyzer.analyzeEncoder(manifest, Object.class, Object.class, (Class)manifest, dslJson);
            }
            if (manifest instanceof ParameterizedType && (pt = (ParameterizedType)manifest).getActualTypeArguments().length == 2) {
                return MapAnalyzer.analyzeEncoder(manifest, pt.getActualTypeArguments()[0], pt.getActualTypeArguments()[1], (Class)pt.getRawType(), dslJson);
            }
            return null;
        }
    };

    private static boolean canNew(Class<?> map) {
        try {
            map.newInstance();
            return true;
        }
        catch (Exception ignore) {
            return false;
        }
    }

    @Nullable
    private static MapDecoder analyzeDecoder(Type manifest, Type key, Type value, final Class<?> map, DslJson json) {
        Callable newInstance;
        if (!Map.class.isAssignableFrom(map)) {
            return null;
        }
        if (!map.isInterface() && MapAnalyzer.canNew(map)) {
            newInstance = new Callable(){

                public Object call() throws Exception {
                    return map.newInstance();
                }
            };
        } else if (map.isAssignableFrom(LinkedHashMap.class)) {
            newInstance = new Callable(){

                public Object call() {
                    return new LinkedHashMap(4);
                }
            };
        } else {
            return null;
        }
        JsonReader.ReadObject<?> keyReader = json.tryFindReader(key);
        JsonReader.ReadObject<?> valueReader = json.tryFindReader(value);
        if (keyReader == null || valueReader == null) {
            return null;
        }
        MapDecoder decoder = new MapDecoder(manifest, newInstance, Object.class == key ? stringReader : keyReader, valueReader);
        json.registerReader(manifest, decoder);
        return decoder;
    }

    @Nullable
    private static MapEncoder analyzeEncoder(Type manifest, Type key, Type value, Class<?> map, DslJson json) {
        JsonWriter.WriteObject<?> valueWriter;
        if (!Map.class.isAssignableFrom(map)) {
            return null;
        }
        JsonWriter.WriteObject<?> keyWriter = Object.class == key ? null : json.tryFindWriter(key);
        JsonWriter.WriteObject<?> writeObject = valueWriter = Object.class == value ? null : json.tryFindWriter(value);
        if (Object.class != key && keyWriter == null || Object.class != value && valueWriter == null) {
            return null;
        }
        boolean checkForConversionToString = key instanceof Class && Number.class.isAssignableFrom((Class)key);
        MapEncoder encoder = new MapEncoder(json, checkForConversionToString, Object.class == key ? null : keyWriter, Object.class == value ? null : valueWriter);
        json.registerWriter(manifest, encoder);
        return encoder;
    }

    public static class Runtime {
        public static final JsonReader.ReadObject<Map<String, Object>> JSON_READER = new JsonReader.ReadObject<Map<String, Object>>(){

            @Override
            public Map<String, Object> read(JsonReader reader) throws IOException {
                if (reader.wasNull()) {
                    return null;
                }
                return ObjectConverter.deserializeMap(reader);
            }
        };
        public static final JsonWriter.WriteObject<Map<String, Object>> JSON_WRITER = new JsonWriter.WriteObject<Map<String, Object>>(){

            @Override
            public void write(JsonWriter writer, @Nullable Map<String, Object> value) {
                ObjectConverter.serializeNullableMap(value, writer);
            }
        };
    }
}

