/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.json.processor;

import com.dslplatform.json.CompiledJson;
import com.dslplatform.json.Configuration;
import com.dslplatform.json.DslJson;
import com.dslplatform.json.JsonConverter;
import com.dslplatform.json.Nullable;
import com.dslplatform.json.processor.Analysis;
import com.dslplatform.json.processor.AnnotationUsage;
import com.dslplatform.json.processor.CachedTypeSupport;
import com.dslplatform.json.processor.Context;
import com.dslplatform.json.processor.ConverterTemplate;
import com.dslplatform.json.processor.EnumTemplate;
import com.dslplatform.json.processor.LogLevel;
import com.dslplatform.json.processor.ObjectType;
import com.dslplatform.json.processor.OptimizedConverter;
import com.dslplatform.json.processor.StructInfo;
import com.dslplatform.json.processor.TypeSupport;
import com.dslplatform.json.processor.UnknownTypes;
import com.dslplatform.json.runtime.ArrayAnalyzer;
import com.dslplatform.json.runtime.CollectionAnalyzer;
import com.dslplatform.json.runtime.MapAnalyzer;
import com.dslplatform.json.runtime.Settings;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

@SupportedAnnotationTypes(value={"com.dslplatform.json.CompiledJson", "com.dslplatform.json.JsonAttribute", "com.dslplatform.json.JsonConverter", "com.dslplatform.json.JsonValue", "com.fasterxml.jackson.annotation.JsonCreator", "javax.json.bind.annotation.JsonbCreator"})
public class CompiledJsonAnnotationProcessor
extends AbstractProcessor {
    private static final Set<String> JsonIgnore = new HashSet<String>();
    private static final Map<String, List<Analysis.AnnotationMapping<Boolean>>> NonNullable;
    private static final Map<String, String> PropertyAlias;
    private static final Map<String, List<Analysis.AnnotationMapping<Boolean>>> JsonRequired;
    private static final Set<String> Creators;
    private static final Map<String, String> Indexes;
    private static final Map<String, OptimizedConverter> InlinedConverters;
    private static final Map<String, String> Defaults;
    private static final String CONFIG = "META-INF/services/com.dslplatform.json.Configuration";
    private static final String GRADLE_OPTION_ISOLATING = "org.gradle.annotation.processing.isolating";
    private static final String GRADLE_OPTION_AGGREGATING = "org.gradle.annotation.processing.aggregating";
    private LogLevel logLevel = LogLevel.ERRORS;
    private AnnotationUsage annotationUsage = AnnotationUsage.IMPLICIT;
    private UnknownTypes unknownTypes = UnknownTypes.ERROR;
    private boolean withJackson = false;
    private boolean withJsonb = false;
    private boolean withNullable = true;
    private String configurationFileName = null;
    private String generatedMarker = null;
    private TypeElement jacksonCreatorElement;
    private DeclaredType jacksonCreatorType;
    private TypeElement jsonbCreatorElement;
    private DeclaredType jsonbCreatorType;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        String nul;
        String con;
        String jsb;
        String jks;
        String unk;
        String au;
        super.init(processingEnv);
        Map<String, String> options = processingEnv.getOptions();
        String ll = options.get(Options.LOG_LEVEL.value);
        if (ll != null && ll.length() > 0) {
            this.logLevel = LogLevel.valueOf(ll);
        }
        if ((au = options.get(Options.ANNOTATION.value)) != null && au.length() > 0) {
            this.annotationUsage = AnnotationUsage.valueOf(au);
        }
        if ((unk = options.get(Options.UNKNOWN.value)) != null && unk.length() > 0) {
            this.unknownTypes = UnknownTypes.valueOf(unk);
        }
        if ((jks = options.get(Options.JACKSON.value)) != null && jks.length() > 0) {
            this.withJackson = Boolean.parseBoolean(jks);
        }
        if ((jsb = options.get(Options.JSONB.value)) != null && jsb.length() > 0) {
            this.withJsonb = Boolean.parseBoolean(jsb);
        }
        if ((con = options.get(Options.CONFIGURATION.value)) != null && con.length() > 0) {
            this.configurationFileName = con;
        }
        if ((nul = options.get(Options.NULLABLE.value)) != null && nul.length() > 0) {
            this.withNullable = Boolean.parseBoolean(nul);
        }
        if (options.containsKey(Options.GENERATED_MARKER.value)) {
            String gm = options.get(Options.GENERATED_MARKER.value);
            this.generatedMarker = gm != null ? gm.trim() : "";
        }
        this.jacksonCreatorElement = processingEnv.getElementUtils().getTypeElement("com.fasterxml.jackson.annotation.JsonCreator");
        this.jacksonCreatorType = this.jacksonCreatorElement != null ? processingEnv.getTypeUtils().getDeclaredType(this.jacksonCreatorElement, new TypeMirror[0]) : null;
        this.jsonbCreatorElement = processingEnv.getElementUtils().getTypeElement("javax.json.bind.annotation.JsonbCreator");
        DeclaredType declaredType = this.jsonbCreatorType = this.jsonbCreatorElement != null ? processingEnv.getTypeUtils().getDeclaredType(this.jsonbCreatorElement, new TypeMirror[0]) : null;
        if (this.generatedMarker == null && processingEnv.getElementUtils().getTypeElement("javax.annotation.processing.Generated") != null) {
            this.generatedMarker = "@javax.annotation.processing.Generated(\"dsl_json\")";
        } else if (this.generatedMarker == null && processingEnv.getElementUtils().getTypeElement("javax.annotation.Generated") != null) {
            this.generatedMarker = "@javax.annotation.Generated(\"dsl_json\")";
        }
    }

    @Override
    public Set<String> getSupportedOptions() {
        HashSet<String> options = new HashSet<String>();
        for (Options option : Options.values()) {
            options.add(option.value);
        }
        options.add(this.configurationFileName == null || this.configurationFileName.isEmpty() ? GRADLE_OPTION_ISOLATING : GRADLE_OPTION_AGGREGATING);
        return options;
    }

    private static boolean isAssignableFrom(Set<Type> known, Type test) {
        if (test instanceof Class) {
            Class tc = (Class)test;
            for (Type k : known) {
                Class kc;
                if (!(k instanceof Class) || !(kc = (Class)k).isAssignableFrom(tc)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Set<? extends Element> jsonConverters;
        Map<String, Element> configurations;
        HashSet jsonbCreators;
        if (roundEnv.processingOver()) return false;
        if (annotations.isEmpty()) {
            return false;
        }
        DslJson.Settings settings = new DslJson.Settings().resolveReader(Settings.UNKNOWN_READER).resolveWriter(Settings.UNKNOWN_WRITER).resolveReader(CollectionAnalyzer.READER).resolveWriter(CollectionAnalyzer.WRITER).resolveReader(ArrayAnalyzer.READER).resolveWriter(ArrayAnalyzer.WRITER).resolveReader(MapAnalyzer.READER).resolveWriter(MapAnalyzer.WRITER).includeServiceLoader(this.getClass().getClassLoader());
        DslJson dslJson = new DslJson(settings);
        Set<Type> knownEncoders = dslJson.getRegisteredEncoders();
        Set<Type> knownDecoders = dslJson.getRegisteredDecoders();
        HashSet<String> allTypes = new HashSet<String>();
        for (Type t : knownDecoders) {
            if (!knownEncoders.contains(t) && !CompiledJsonAnnotationProcessor.isAssignableFrom(knownEncoders, t)) continue;
            allTypes.add(t.getTypeName());
        }
        CachedTypeSupport typeSupport = new CachedTypeSupport(type -> {
            if (allTypes.contains(type)) {
                return true;
            }
            if ("java.lang.Object".equals(type)) {
                return false;
            }
            try {
                Class<?> raw = Class.forName(type);
                return dslJson.canSerialize(raw) && dslJson.canDeserialize(raw);
            }
            catch (Exception | NoClassDefFoundError ignore) {
                return false;
            }
        });
        Analysis analysis = new Analysis(this.processingEnv, this.annotationUsage, this.logLevel, typeSupport, JsonIgnore, this.withNullable ? NonNullable : new HashMap<String, List<Analysis.AnnotationMapping<Boolean>>>(), PropertyAlias, JsonRequired, Creators, Indexes, this.unknownTypes, true, true, true);
        Set<? extends Element> compiledJsons = roundEnv.getElementsAnnotatedWith(analysis.compiledJsonElement);
        HashSet jacksonCreators = this.withJackson && this.jacksonCreatorElement != null ? roundEnv.getElementsAnnotatedWith(this.jacksonCreatorElement) : new HashSet();
        Set<Object> set = jsonbCreators = this.withJsonb && this.jsonbCreatorElement != null ? roundEnv.getElementsAnnotatedWith(this.jsonbCreatorElement) : new HashSet();
        if (compiledJsons.isEmpty() && jacksonCreators.isEmpty()) {
            if (jsonbCreators.isEmpty()) return false;
        }
        if (!(configurations = analysis.processConverters(jsonConverters = roundEnv.getElementsAnnotatedWith(analysis.converterElement))).isEmpty() && "".equals(this.configurationFileName)) {
            Iterator<Map.Entry<String, Element>> iterator = configurations.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Element> kv = iterator.next();
                if (!this.logLevel.isVisible(LogLevel.INFO)) continue;
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Configuration file is disabled, but @" + JsonConverter.class.getName() + " which implements " + Configuration.class.getName() + " found: '" + kv.getKey() + "'. Manual converter registration with DslJson is required.", kv.getValue());
            }
            return false;
        }
        analysis.processAnnotation(analysis.compiledJsonType, compiledJsons);
        if (!jacksonCreators.isEmpty() && this.jacksonCreatorType != null) {
            analysis.processAnnotation(this.jacksonCreatorType, jacksonCreators);
        }
        if (!jsonbCreators.isEmpty() && this.jsonbCreatorType != null) {
            analysis.processAnnotation(this.jsonbCreatorType, jsonbCreators);
        }
        Map<String, StructInfo> structs = analysis.analyze();
        if (analysis.hasError()) {
            return false;
        }
        HashMap<String, StructInfo> generatedFiles = new HashMap<String, StructInfo>();
        ArrayList<Element> originatingElements = new ArrayList<Element>();
        for (Map.Entry<String, StructInfo> entry : structs.entrySet()) {
            StructInfo structInfo = entry.getValue();
            if (structInfo.type == ObjectType.CLASS && structInfo.attributes.isEmpty() && !structInfo.hasAnnotation()) continue;
            String classNamePath = CompiledJsonAnnotationProcessor.findConverterName(structInfo);
            try {
                JavaFileObject converterFile = this.processingEnv.getFiler().createSourceFile(classNamePath, structInfo.element);
                try {
                    Writer writer = converterFile.openWriter();
                    Throwable throwable = null;
                    try {
                        CompiledJsonAnnotationProcessor.buildCode(writer, this.processingEnv, entry.getKey(), structInfo, structs, typeSupport, this.unknownTypes != UnknownTypes.ERROR, this.generatedMarker);
                        generatedFiles.put(classNamePath, structInfo);
                        originatingElements.add(structInfo.element);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (writer == null) continue;
                        if (throwable != null) {
                            try {
                                writer.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        writer.close();
                    }
                }
                catch (IOException e) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed saving compiled json serialization file " + classNamePath);
                }
            }
            catch (IOException e) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed creating compiled json serialization file " + classNamePath);
            }
        }
        ArrayList<String> allConfigurations = new ArrayList<String>(configurations.keySet());
        if (this.configurationFileName != null) {
            try {
                JavaFileObject configFile = this.processingEnv.getFiler().createSourceFile(this.configurationFileName, originatingElements.toArray(new Element[0]));
                try (Writer writer = configFile.openWriter();){
                    if (!CompiledJsonAnnotationProcessor.buildRootConfiguration(writer, this.configurationFileName, generatedFiles, this.processingEnv)) {
                        boolean bl = false;
                        return bl;
                    }
                    allConfigurations.add(this.configurationFileName);
                }
                catch (Exception e) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed saving configuration file " + this.configurationFileName);
                }
            }
            catch (IOException e) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed creating configuration file " + this.configurationFileName);
            }
        }
        if (allConfigurations.isEmpty()) return false;
        originatingElements.addAll(configurations.values());
        this.saveToServiceConfigFile(allConfigurations, originatingElements);
        return false;
    }

    private void saveToServiceConfigFile(List<String> configurations, List<Element> elements) {
        try {
            FileObject configFile = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", CONFIG, elements.toArray(new Element[0]));
            try (Writer writer = configFile.openWriter();){
                for (String conf : configurations) {
                    writer.write(conf);
                    writer.write(10);
                }
            }
            catch (Exception e) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed saving config file META-INF/services/com.dslplatform.json.Configuration");
            }
        }
        catch (IOException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed creating config file META-INF/services/com.dslplatform.json.Configuration");
        }
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        SourceVersion latest = SourceVersion.latest();
        if ("RELEASE_9".equals(latest.name())) {
            return latest;
        }
        if (latest.name().length() > "RELEASE_9".length()) {
            return latest;
        }
        return SourceVersion.RELEASE_8;
    }

    static String findConverterName(StructInfo structInfo) {
        int dotIndex = structInfo.binaryName.lastIndexOf(46);
        String className = structInfo.binaryName.substring(dotIndex + 1);
        if (dotIndex == -1) {
            return String.format("_%s_DslJsonConverter", className);
        }
        String packageName = structInfo.binaryName.substring(0, dotIndex);
        Package packageClass = Package.getPackage(packageName);
        boolean useDslPackage = packageClass != null && packageClass.isSealed() || structInfo.binaryName.startsWith("java.");
        return String.format("%s%s._%s_DslJsonConverter", useDslPackage ? "dsl_json." : "", packageName, className);
    }

    private static void buildCode(Writer code, ProcessingEnvironment environment, String className, StructInfo si, Map<String, StructInfo> structs, TypeSupport typeSupport, boolean allowUnknown, @Nullable String generatedMarker) throws IOException {
        Context context = new Context(code, environment, InlinedConverters, Defaults, structs, typeSupport, allowUnknown);
        EnumTemplate enumTemplate = new EnumTemplate(context);
        ConverterTemplate converterTemplate = new ConverterTemplate(context, enumTemplate);
        String generateFullClassName = CompiledJsonAnnotationProcessor.findConverterName(si);
        int dotIndex = generateFullClassName.lastIndexOf(46);
        String generateClassName = generateFullClassName.substring(dotIndex + 1);
        if (dotIndex != -1) {
            String generatePackage = generateFullClassName.substring(0, dotIndex);
            code.append("package ").append(generatePackage).append(";\n\n");
        }
        code.append("\n\n");
        if (generatedMarker != null && !generatedMarker.isEmpty()) {
            code.append(generatedMarker).append("\n");
        }
        code.append("public class ").append(generateClassName).append(" implements com.dslplatform.json.Configuration {\n");
        code.append("\t@Override\n");
        code.append("\tpublic void configure(com.dslplatform.json.DslJson __dsljson) {\n");
        if (si.type == ObjectType.CLASS && si.isParameterized) {
            code.append("\t\tConverterFactory factory = new ConverterFactory();\n");
            code.append("\t\t__dsljson.registerReaderFactory(factory);\n");
            code.append("\t\t__dsljson.registerWriterFactory(factory);\n");
            if (si.createFromEmptyInstance()) {
                code.append("\t\t__dsljson.registerBinderFactory(factory);\n");
            }
        } else if (si.builder != null || si.type == ObjectType.CLASS && (si.selectedConstructor() != null || si.annotatedFactory != null)) {
            String objectFormatConverterName = "converter";
            if (si.formats.contains((Object)CompiledJson.Format.OBJECT)) {
                code.append("\t\tObjectFormatConverter objectConverter = new ObjectFormatConverter(__dsljson);\n");
                objectFormatConverterName = "objectConverter";
            }
            if (si.formats.contains((Object)CompiledJson.Format.ARRAY)) {
                code.append("\t\tArrayFormatConverter arrayConverter = new ArrayFormatConverter(__dsljson);\n");
                objectFormatConverterName = "arrayConverter";
            }
            if (si.formats.contains((Object)CompiledJson.Format.OBJECT) && si.formats.contains((Object)CompiledJson.Format.ARRAY)) {
                code.append("\t\tcom.dslplatform.json.runtime.FormatDescription description = new com.dslplatform.json.runtime.FormatDescription(\n");
                code.append("\t\t\t").append(className).append(".class,\n");
                code.append("\t\t\tobjectConverter,\n");
                code.append("\t\t\tarrayConverter,\n");
                if (si.isObjectFormatFirst) {
                    code.append("\t\t\ttrue,\n");
                } else {
                    code.append("\t\t\tfalse,\n");
                }
                String typeAlias = si.deserializeName.isEmpty() ? className : si.deserializeName;
                code.append("\t\t\t\"").append(typeAlias).append("\",\n");
                code.append("\t\t\t__dsljson);\n");
                if (si.createFromEmptyInstance()) {
                    code.append("\t\t__dsljson.registerBinder(").append(className).append(".class, description);\n");
                }
                code.append("\t\t__dsljson.registerReader(").append(className).append(".class, description);\n");
                code.append("\t\t__dsljson.registerWriter(").append(className).append(".class, description);\n");
            } else {
                if (si.createFromEmptyInstance()) {
                    code.append("\t\t__dsljson.registerBinder(").append(className).append(".class, ").append(objectFormatConverterName).append(");\n");
                }
                code.append("\t\t__dsljson.registerReader(").append(className).append(".class, ").append(objectFormatConverterName).append(");\n");
                code.append("\t\t__dsljson.registerWriter(").append(className).append(".class, ").append(objectFormatConverterName).append(");\n");
            }
        } else if (si.type == ObjectType.CONVERTER) {
            String type = Context.typeOrClass(Context.nonGenericObject(className), className);
            if (si.converter.legacyDeclaration) {
                code.append("\t\t__dsljson.registerWriter(").append(type).append(", ").append(si.converter.fullName).append(".").append(si.converter.writer).append(");\n");
                code.append("\t\t__dsljson.registerReader(").append(type).append(", ").append(si.converter.fullName).append(".").append(si.converter.reader).append(");\n");
            } else {
                String objectName = Analysis.objectName(className);
                code.append("\t\t__dsljson.registerWriter(").append(type).append(", ");
                code.append("new com.dslplatform.json.JsonWriter.WriteObject<").append(objectName).append(">() {\n");
                code.append("\t\t\t@Override\n\t\t\tpublic void write(com.dslplatform.json.JsonWriter writer, ").append(objectName).append(" value) {\n");
                code.append("\t\t\t\t");
                si.converter.write(code);
                code.append(".write(writer, value);\n");
                code.append("\t\t\t};\n\t\t});\n");
                code.append("\t\t__dsljson.registerReader(").append(type).append(", ");
                code.append("new com.dslplatform.json.JsonReader.ReadObject<").append(objectName).append(">() {\n");
                code.append("\t\t\t@Override\n\t\t\tpublic ").append(objectName).append(" read(com.dslplatform.json.JsonReader reader) throws java.io.IOException {\n");
                code.append("\t\t\t\treturn ");
                si.converter.read(code);
                code.append(".read(reader);\n");
                code.append("\t\t\t};\n\t\t});\n");
            }
        } else if (si.type == ObjectType.ENUM) {
            if (enumTemplate.isStatic(si)) {
                code.append("\t\tEnumConverter enumConverter = new EnumConverter();\n");
            } else {
                code.append("\t\tEnumConverter enumConverter = new EnumConverter(__dsljson);\n");
            }
            code.append("\t\t__dsljson.registerWriter(").append(className).append(".class, enumConverter);\n");
            code.append("\t\t__dsljson.registerReader(").append(className).append(".class, enumConverter);\n");
        }
        if (si.type == ObjectType.MIXIN && !si.implementations.isEmpty()) {
            CompiledJsonAnnotationProcessor.mixin(code, si.deserializeAs != null, si, className);
        }
        if (si.type == ObjectType.MIXIN && si.deserializeAs != null) {
            String typeMixin = Context.typeOrClass(Context.nonGenericObject(className), className);
            StructInfo target = si.getDeserializeTarget();
            code.append("\t\t__dsljson.registerReader(").append(typeMixin).append(", ");
            if (!target.formats.contains((Object)CompiledJson.Format.OBJECT)) {
                code.append("new ").append(CompiledJsonAnnotationProcessor.findConverterName(target)).append(".ArrayFormatConverter(__dsljson));\n");
            } else if (!target.formats.contains((Object)CompiledJson.Format.ARRAY)) {
                code.append("new ").append(CompiledJsonAnnotationProcessor.findConverterName(target)).append(".ObjectFormatConverter(__dsljson));\n");
            }
        }
        code.append("\t}\n");
        if (si.type == ObjectType.CLASS || si.builder != null) {
            String typeName;
            if (si.isParameterized) {
                converterTemplate.factoryForGenericConverter(si);
                typeName = className + "<" + String.join((CharSequence)", ", si.typeParametersNames) + ">";
            } else {
                typeName = className;
            }
            if (si.createFromEmptyInstance()) {
                if (si.formats.contains((Object)CompiledJson.Format.OBJECT)) {
                    converterTemplate.emptyObject(si, typeName);
                }
                if (si.formats.contains((Object)CompiledJson.Format.ARRAY)) {
                    converterTemplate.emptyArray(si, typeName);
                }
            } else if (si.selectedConstructor() != null || si.annotatedFactory != null || si.builder != null) {
                if (si.formats.contains((Object)CompiledJson.Format.OBJECT)) {
                    converterTemplate.fromObject(si, typeName);
                }
                if (si.formats.contains((Object)CompiledJson.Format.ARRAY)) {
                    converterTemplate.fromArray(si, typeName);
                }
            }
        } else if (si.type == ObjectType.ENUM) {
            enumTemplate.create(si, className);
        }
        code.append("}\n");
    }

    private static void mixin(Writer code, boolean writeOnly, StructInfo si, String className) throws IOException {
        String mixinType = writeOnly ? "MixinWriter" : "MixinDescription";
        code.append("\t\tcom.dslplatform.json.runtime.").append(mixinType).append("<").append(className).append("> description = new com.dslplatform.json.runtime.").append(mixinType).append("<>(\n");
        code.append("\t\t\t").append(className).append(".class,\n");
        code.append("\t\t\t__dsljson,\n");
        if (si.discriminator.length() > 0) {
            code.append("\t\t\t\"").append(si.discriminator).append("\",\n");
        }
        code.append("\t\t\tnew com.dslplatform.json.runtime.FormatDescription[] {\n");
        int i = si.implementations.size();
        for (StructInfo im : si.implementations) {
            code.append("\t\t\t\tnew com.dslplatform.json.runtime.FormatDescription(");
            code.append(im.element.getQualifiedName()).append(".class, ");
            if (im.formats.contains((Object)CompiledJson.Format.OBJECT)) {
                code.append("new ").append(CompiledJsonAnnotationProcessor.findConverterName(im)).append(".ObjectFormatConverter(__dsljson), ");
            } else {
                code.append("null, ");
            }
            if (im.formats.contains((Object)CompiledJson.Format.ARRAY)) {
                code.append("new ").append(CompiledJsonAnnotationProcessor.findConverterName(im)).append(".ArrayFormatConverter(__dsljson), ");
            } else {
                code.append("null, ");
            }
            if (im.isObjectFormatFirst) {
                code.append("true, ");
            } else {
                code.append("false, ");
            }
            String typeAlias = im.deserializeName.isEmpty() ? im.element.getQualifiedName().toString() : im.deserializeName;
            code.append("\"").append(typeAlias).append("\", __dsljson)");
            if (--i <= 0) continue;
            code.append(",\n");
        }
        code.append("\n\t\t\t}\n");
        code.append("\t\t);\n");
        if (!writeOnly) {
            code.append("\t\t__dsljson.registerReader(").append(className).append(".class, description);\n");
        }
        code.append("\t\t__dsljson.registerWriter(").append(className).append(".class, description);\n");
    }

    private static boolean buildRootConfiguration(Writer code, String configurationName, Map<String, StructInfo> configurations, ProcessingEnvironment processingEnv) throws IOException {
        boolean hasNamespace;
        int dotIndex = configurationName.lastIndexOf(46);
        String generateClassName = configurationName.substring(dotIndex + 1);
        boolean bl = hasNamespace = dotIndex != -1;
        if (hasNamespace) {
            code.append("package ").append(configurationName, 0, dotIndex).append(";\n\n");
        }
        code.append("public class ").append(generateClassName).append(" implements com.dslplatform.json.Configuration {\n");
        code.append("\t@Override\n");
        code.append("\tpublic void configure(com.dslplatform.json.DslJson __dsljson) {\n");
        boolean allValid = true;
        for (Map.Entry<String, StructInfo> kv : configurations.entrySet()) {
            if (hasNamespace && kv.getKey().indexOf(46) == -1) {
                processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Configuration file: '" + configurationName + "' is not in the root package, but referenced element does not have a package specified: '" + kv.getValue().binaryName + "'. Use configuration name without package, eg: 'dsl_json_Annotation_Processor_External_Serialization' to allow access to specified class.", kv.getValue().element, kv.getValue().annotation);
                allValid = false;
            }
            code.append("\t\tnew ").append(kv.getKey()).append("().configure(__dsljson);\n");
        }
        code.append("\t}\n");
        code.append("}");
        return allValid;
    }

    static {
        JsonIgnore.add("com.fasterxml.jackson.annotation.JsonIgnore");
        JsonIgnore.add("javax.json.bind.annotation.JsonbTransient");
        NonNullable = new HashMap<String, List<Analysis.AnnotationMapping<Boolean>>>();
        NonNullable.put("javax.validation.constraints.NotNull", null);
        NonNullable.put("javax.annotation.Nonnull", null);
        NonNullable.put("com.dslplatform.json.NonNull", null);
        NonNullable.put("android.support.annotation.NonNull", null);
        NonNullable.put("org.jetbrains.annotations.NotNull", null);
        NonNullable.put("javax.json.bind.annotation.JsonbNillable", Arrays.asList(new Analysis.AnnotationMapping<Object>("value()", null), new Analysis.AnnotationMapping<Boolean>("value()", true)));
        NonNullable.put("javax.json.bind.annotation.JsonbProperty", Collections.singletonList(new Analysis.AnnotationMapping<Boolean>("nillable()", true)));
        PropertyAlias = new HashMap<String, String>();
        PropertyAlias.put("com.fasterxml.jackson.annotation.JsonProperty", "value()");
        PropertyAlias.put("com.google.gson.annotations.SerializedName", "value()");
        PropertyAlias.put("javax.json.bind.annotation.JsonbProperty", "value()");
        JsonRequired = new HashMap<String, List<Analysis.AnnotationMapping<Boolean>>>();
        JsonRequired.put("com.fasterxml.jackson.annotation.JsonProperty", Collections.singletonList(new Analysis.AnnotationMapping<Boolean>("required()", true)));
        Creators = new HashSet<String>();
        Creators.add("com.fasterxml.jackson.annotation.JsonCreator");
        Creators.add("javax.json.bind.annotation.JsonbCreator");
        Indexes = new HashMap<String, String>();
        Indexes.put("com.fasterxml.jackson.annotation.JsonProperty", "index()");
        InlinedConverters = new HashMap<String, OptimizedConverter>();
        InlinedConverters.put("byte[]", new OptimizedConverter("com.dslplatform.json.BinaryConverter", "WRITER", "serialize", "READER", "deserialize", "com.dslplatform.json.BinaryConverter.EMPTY_ARRAY"));
        InlinedConverters.put("char[]", new OptimizedConverter("com.dslplatform.json.StringConverter", "WRITER_ARRAY", null, "READER_ARRAY", null, "com.dslplatform.json.StringConverter.EMPTY_ARRAY"));
        InlinedConverters.put("short", new OptimizedConverter("com.dslplatform.json.NumberConverter", "SHORT_WRITER", "serialize", "SHORT_READER", "deserializeShort", "(short)0"));
        InlinedConverters.put("short[]", new OptimizedConverter("com.dslplatform.json.NumberConverter", "SHORT_ARRAY_WRITER", "serialize", "SHORT_ARRAY_READER", null, "com.dslplatform.json.NumberConverter.SHORT_EMPTY_ARRAY"));
        InlinedConverters.put("java.lang.Short", new OptimizedConverter("com.dslplatform.json.NumberConverter", "SHORT_WRITER", "serialize", "NULLABLE_SHORT_READER", "deserializeShort", "com.dslplatform.json.NumberConverter.SHORT_ZERO"));
        InlinedConverters.put("int", new OptimizedConverter("com.dslplatform.json.NumberConverter", "INT_WRITER", "serialize", "INT_READER", "deserializeInt", "0"));
        InlinedConverters.put("int[]", new OptimizedConverter("com.dslplatform.json.NumberConverter", "INT_ARRAY_WRITER", "serialize", "INT_ARRAY_READER", null, "com.dslplatform.json.NumberConverter.INT_EMPTY_ARRAY"));
        InlinedConverters.put("java.lang.Integer", new OptimizedConverter("com.dslplatform.json.NumberConverter", "INT_WRITER", "serialize", "NULLABLE_INT_READER", "deserializeInt", "com.dslplatform.json.NumberConverter.INT_ZERO"));
        InlinedConverters.put("long", new OptimizedConverter("com.dslplatform.json.NumberConverter", "LONG_WRITER", "serialize", "LONG_READER", "deserializeLong", "0L"));
        InlinedConverters.put("long[]", new OptimizedConverter("com.dslplatform.json.NumberConverter", "LONG_ARRAY_WRITER", "serialize", "LONG_ARRAY_READER", null, "com.dslplatform.json.NumberConverter.LONG_EMPTY_ARRAY"));
        InlinedConverters.put("java.lang.Long", new OptimizedConverter("com.dslplatform.json.NumberConverter", "LONG_WRITER", "serialize", "NULLABLE_LONG_READER", "deserializeLong", "com.dslplatform.json.NumberConverter.LONG_ZERO"));
        InlinedConverters.put("float", new OptimizedConverter("com.dslplatform.json.NumberConverter", "FLOAT_WRITER", "serialize", "FLOAT_READER", "deserializeFloat", "0f"));
        InlinedConverters.put("float[]", new OptimizedConverter("com.dslplatform.json.NumberConverter", "FLOAT_ARRAY_WRITER", "serialize", "FLOAT_ARRAY_READER", null, "com.dslplatform.json.NumberConverter.FLOAT_EMPTY_ARRAY"));
        InlinedConverters.put("java.lang.Float", new OptimizedConverter("com.dslplatform.json.NumberConverter", "FLOAT_WRITER", "serialize", "NULLABLE_FLOAT_READER", "deserializeFloat", "com.dslplatform.json.NumberConverter.FLOAT_ZERO"));
        InlinedConverters.put("double", new OptimizedConverter("com.dslplatform.json.NumberConverter", "DOUBLE_WRITER", "serialize", "DOUBLE_READER", "deserializeDouble", "0.0"));
        InlinedConverters.put("double[]", new OptimizedConverter("com.dslplatform.json.NumberConverter", "DOUBLE_ARRAY_WRITER", "serialize", "DOUBLE_ARRAY_READER", null, "com.dslplatform.json.NumberConverter.DOUBLE_EMPTY_ARRAY"));
        InlinedConverters.put("java.lang.Double", new OptimizedConverter("com.dslplatform.json.NumberConverter", "DOUBLE_WRITER", "serialize", "NULLABLE_DOUBLE_READER", "deserializeDouble", "com.dslplatform.json.NumberConverter.DOUBLE_ZERO"));
        InlinedConverters.put("boolean", new OptimizedConverter("com.dslplatform.json.BoolConverter", "WRITER", "serialize", "READER", "deserialize", "false"));
        InlinedConverters.put("boolean[]", new OptimizedConverter("com.dslplatform.json.BoolConverter", "ARRAY_WRITER", "serialize", "ARRAY_READER", null, "com.dslplatform.json.BoolConverter.EMPTY_ARRAY"));
        InlinedConverters.put("java.lang.Boolean", new OptimizedConverter("com.dslplatform.json.BoolConverter", "WRITER", "serialize", "NULLABLE_READER", "deserialize", "Boolean.FALSE"));
        InlinedConverters.put("java.lang.String", new OptimizedConverter("com.dslplatform.json.StringConverter", "WRITER", "serialize", "READER", "deserialize", "\"\""));
        InlinedConverters.put("java.util.UUID", new OptimizedConverter("com.dslplatform.json.UUIDConverter", "WRITER", "serialize", "READER", "deserialize", "com.dslplatform.json.UUIDConverter.MIN_UUID"));
        InlinedConverters.put("java.time.LocalDate", new OptimizedConverter("com.dslplatform.json.JavaTimeConverter", "LOCAL_DATE_WRITER", "serialize", "LOCAL_DATE_READER", "deserializeLocalDate", null));
        InlinedConverters.put("java.time.OffsetDateTime", new OptimizedConverter("com.dslplatform.json.JavaTimeConverter", "DATE_TIME_WRITER", "serialize", "DATE_TIME_READER", "deserializeDateTime", null));
        Defaults = new HashMap<String, String>();
        Defaults.put("byte", "(byte)0");
        Defaults.put("boolean", "false");
        Defaults.put("int", "0");
        Defaults.put("long", "0L");
        Defaults.put("short", "(short)0");
        Defaults.put("double", "0.0");
        Defaults.put("float", "0.0f");
        Defaults.put("char", "'\u0000'");
        Defaults.put("java.util.OptionalLong", "java.util.OptionalLong.empty()");
        Defaults.put("java.util.OptionalInt", "java.util.OptionalInt.empty()");
        Defaults.put("java.util.OptionalDouble", "java.util.OptionalDouble.empty()");
        Defaults.put("java.util.Optional", "java.util.Optional.empty()");
    }

    private static enum Options {
        LOG_LEVEL("dsljson.loglevel"),
        ANNOTATION("dsljson.annotation"),
        UNKNOWN("dsljson.unknown"),
        JACKSON("dsljson.jackson"),
        JSONB("dsljson.jsonb"),
        CONFIGURATION("dsljson.configuration"),
        NULLABLE("dsljson.nullable"),
        GENERATED_MARKER("dsljson.generatedmarker");

        final String value;

        private Options(String value) {
            this.value = value;
        }
    }
}

