/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.json.runtime;

import com.dslplatform.json.JsonWriter;
import com.dslplatform.json.Nullable;
import com.dslplatform.json.runtime.Settings;
import java.nio.charset.StandardCharsets;

class AttributeObjectNonDefaultEncoder<T, R>
implements JsonWriter.WriteObject<T> {
    private final Settings.Function<T, R> read;
    private final byte[] quotedName;
    private final JsonWriter.WriteObject<R> encoder;
    private final R defaultValue;

    AttributeObjectNonDefaultEncoder(Settings.Function<T, R> read, String name, JsonWriter.WriteObject<R> encoder, @Nullable R defaultValue) {
        if (read == null) {
            throw new IllegalArgumentException("read can't be null");
        }
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("name can't be null");
        }
        if (encoder == null) {
            throw new IllegalArgumentException("encoder can't be null");
        }
        this.read = read;
        this.quotedName = ("\"" + name + "\":").getBytes(StandardCharsets.UTF_8);
        this.defaultValue = defaultValue;
        this.encoder = encoder;
    }

    @Override
    public void write(JsonWriter writer, @Nullable T value) {
        R attr = this.read.apply(value);
        if (attr != null && attr != this.defaultValue) {
            writer.writeAscii(this.quotedName);
            this.encoder.write(writer, attr);
        }
    }
}

