/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.json.runtime;

import com.dslplatform.json.JsonReader;
import com.dslplatform.json.JsonWriter;
import com.dslplatform.json.Nullable;
import com.dslplatform.json.runtime.DecodePropertyInfo;
import com.dslplatform.json.runtime.Reflection;
import com.dslplatform.json.runtime.Settings;
import com.dslplatform.json.runtime.WriteDescription;
import java.io.IOException;
import java.lang.reflect.Type;

public final class ImmutableDescription<T>
extends WriteDescription<T>
implements JsonReader.ReadObject<T> {
    private final Type manifest;
    private final Object[] defArgs;
    private final Settings.Function<Object[], T> newInstance;
    private final DecodePropertyInfo<JsonReader.ReadObject>[] decoders;
    private final boolean skipOnUnknown;
    private final boolean hasMandatory;
    private final long mandatoryFlag;
    private final String startError;
    private final String endError;

    public ImmutableDescription(Class<T> manifest, Object[] defArgs, Settings.Function<Object[], T> newInstance, JsonWriter.WriteObject[] encoders, DecodePropertyInfo<JsonReader.ReadObject>[] decoders, boolean alwaysSerialize, boolean skipOnUnknown) {
        this((Type)manifest, defArgs, newInstance, encoders, decoders, alwaysSerialize, skipOnUnknown);
    }

    ImmutableDescription(Type manifest, Object[] defArgs, Settings.Function<Object[], T> newInstance, JsonWriter.WriteObject[] encoders, DecodePropertyInfo<JsonReader.ReadObject>[] decoders, boolean alwaysSerialize, boolean skipOnUnknown) {
        super(encoders, alwaysSerialize);
        if (manifest == null) {
            throw new IllegalArgumentException("manifest can't be null");
        }
        if (defArgs == null) {
            throw new IllegalArgumentException("defArgs can't be null");
        }
        if (newInstance == null) {
            throw new IllegalArgumentException("create can't be null");
        }
        if (decoders == null) {
            throw new IllegalArgumentException("decoders can't be null");
        }
        this.manifest = manifest;
        this.defArgs = defArgs;
        this.newInstance = newInstance;
        this.decoders = DecodePropertyInfo.prepare(decoders, defArgs.length);
        this.skipOnUnknown = skipOnUnknown;
        this.mandatoryFlag = DecodePropertyInfo.calculateMandatory(this.decoders);
        this.hasMandatory = this.mandatoryFlag != 0L;
        this.startError = String.format("Expecting '{' to start decoding %s", Reflection.typeDescription(manifest));
        this.endError = String.format("Expecting '}' or ',' while decoding %s", Reflection.typeDescription(manifest));
    }

    @Override
    @Nullable
    public T read(JsonReader reader) throws IOException {
        if (reader.wasNull()) {
            return null;
        }
        if (reader.last() != 123) {
            throw reader.newParseError(this.startError);
        }
        if (reader.getNextToken() == 125) {
            if (this.hasMandatory) {
                DecodePropertyInfo.showMandatoryError(reader, this.mandatoryFlag, this.decoders);
            }
            return this.newInstance.apply(this.defArgs);
        }
        Object[] args = (Object[])this.defArgs.clone();
        long currentMandatory = this.mandatoryFlag;
        int i = 0;
        while (i < this.decoders.length) {
            DecodePropertyInfo<JsonReader.ReadObject> ri = this.decoders[i++];
            int weakHash = reader.fillNameWeakHash();
            if (weakHash != ri.weakHash || !reader.wasLastName(ri.nameBytes)) {
                return this.readObjectSlow(args, reader, currentMandatory);
            }
            reader.getNextToken();
            if (ri.nonNull && reader.wasNull()) {
                throw reader.newParseErrorWith("Null value found for non-null attribute", ri.name);
            }
            args[ri.index] = ((JsonReader.ReadObject)ri.value).read(reader);
            currentMandatory &= ri.mandatoryValue;
            if (reader.getNextToken() != 44 || i == this.decoders.length) break;
            reader.getNextToken();
        }
        return this.finalChecks(args, reader, currentMandatory);
    }

    @Nullable
    private T readObjectSlow(Object[] args, JsonReader reader, long currentMandatory) throws IOException {
        boolean processed = false;
        int oldHash = reader.getLastHash();
        for (DecodePropertyInfo<JsonReader.ReadObject> ri : this.decoders) {
            if (oldHash != ri.hash || ri.exactName && !reader.wasLastName(ri.nameBytes)) continue;
            reader.getNextToken();
            if (ri.nonNull && reader.wasNull()) {
                throw reader.newParseErrorWith("Null value found for non-null attribute", ri.name);
            }
            args[ri.index] = ((JsonReader.ReadObject)ri.value).read(reader);
            currentMandatory &= ri.mandatoryValue;
            processed = true;
            break;
        }
        if (!processed) {
            this.skip(reader);
        } else {
            reader.getNextToken();
        }
        while (reader.last() == 44) {
            reader.getNextToken();
            int hash = reader.fillName();
            processed = false;
            for (DecodePropertyInfo<JsonReader.ReadObject> ri : this.decoders) {
                if (hash != ri.hash || ri.exactName && !reader.wasLastName(ri.nameBytes)) continue;
                reader.getNextToken();
                if (ri.nonNull && reader.wasNull()) {
                    throw reader.newParseErrorWith("Null value found for non-null attribute", ri.name);
                }
                args[ri.index] = ((JsonReader.ReadObject)ri.value).read(reader);
                currentMandatory &= ri.mandatoryValue;
                processed = true;
                break;
            }
            if (!processed) {
                this.skip(reader);
                continue;
            }
            reader.getNextToken();
        }
        return this.finalChecks(args, reader, currentMandatory);
    }

    @Nullable
    private T finalChecks(Object[] args, JsonReader reader, long currentMandatory) throws IOException {
        if (reader.last() != 125) {
            if (reader.last() != 44) {
                throw reader.newParseError(this.endError);
            }
            reader.getNextToken();
            reader.fillNameWeakHash();
            return this.readObjectSlow(args, reader, currentMandatory);
        }
        if (this.hasMandatory && currentMandatory != 0L) {
            DecodePropertyInfo.showMandatoryError(reader, currentMandatory, this.decoders);
        }
        return this.newInstance.apply(args);
    }

    private void skip(JsonReader reader) throws IOException {
        if (!this.skipOnUnknown) {
            String name = reader.getLastName();
            throw reader.newParseErrorFormat("Unknown property detected", name.length() + 3, "Unknown property detected: '%s' while reading %s", name, Reflection.typeDescription(this.manifest));
        }
        reader.getNextToken();
        reader.skip();
    }
}

