/*
 * Decompiled with CFR 0.152.
 */
package org.dst.server.service;

import com.baidu.brpc.server.RpcServer;
import com.baidu.brpc.server.RpcServerOptions;
import org.dst.core.KVStore;
import org.dst.core.KVStoreImpl;
import org.dst.server.service.DstDictServiceImpl;
import org.dst.server.service.DstListServiceImpl;
import org.dst.server.service.DstSetServiceImpl;
import org.dst.server.service.DstStringServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DstRpcServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DstRpcServer.class);
    private static final int LISTENING_PORT = 8082;
    private static final int RECEIVE_BUFFER_SIZE = 0x4000000;
    private static final int SEND_BUFFER_SIZE = 0x4000000;
    private static final int KEEP_ALIVE_TIME = 20;
    private KVStore kvStore = new KVStoreImpl();
    private static String WELCOME_WORD = "                                   \n                                   \n    ,---,                  ___     \n  .'  .' `\\              ,--.'|_   \n,---.'     \\             |  | :,'  \n|   |  .`\\  |  .--.--.   :  : ' :  \n:   : |  '  | /  /    '.;__,'  /   \n|   ' '  ;  :|  :  /`./|  |   |    \n'   | ;  .  ||  :  ;_  :__,'| :    \n|   | :  |  ' \\  \\    `. '  : |__  \n'   : | /  ;   `----.   \\|  | '.'| \n|   | '` ,/   /  /`--'  /;  :    ; \n;   :  .'    '--'.     / |  ,   /  \n|   ,.'        `--'---'   ---`-'   \n'---'                              \n                                   ";

    private DstRpcServer() {
    }

    private KVStore getKvStore() {
        return this.kvStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        DstRpcServer rpcServer = new DstRpcServer();
        int listeningPort = 8082;
        if (args.length == 1) {
            try {
                listeningPort = Integer.valueOf(args[0]);
            }
            catch (NumberFormatException e) {
                LOGGER.error("Failed to start dst server, because the port is incorrect format: {}", (Object)args[0]);
                System.exit(0);
            }
        }
        RpcServerOptions options = new RpcServerOptions();
        options.setReceiveBufferSize(0x4000000);
        options.setSendBufferSize(0x4000000);
        options.setKeepAliveTime(20);
        RpcServer server = new RpcServer(listeningPort, options);
        server.registerService((Object)new DstStringServiceImpl(rpcServer.getKvStore()));
        server.registerService((Object)new DstSetServiceImpl(rpcServer.getKvStore()));
        server.registerService((Object)new DstListServiceImpl(rpcServer.getKvStore()));
        server.registerService((Object)new DstDictServiceImpl(rpcServer.getKvStore()));
        server.start();
        System.out.println(WELCOME_WORD);
        LOGGER.info("Succeeded to start dst server on port {}.", (Object)listeningPort);
        Class<DstRpcServer> clazz = DstRpcServer.class;
        synchronized (DstRpcServer.class) {
            try {
                DstRpcServer.class.wait();
            }
            catch (Throwable e) {
                LOGGER.error("Failed with the exception: {}", (Object)e.toString());
                System.exit(-1);
            }
            return;
        }
    }
}

