/*
 * Decompiled with CFR 0.152.
 */
package com.dteoh.treasuremap;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jdesktop.application.ResourceMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResourceMaps {
    private final Locale bundleLocale;
    private final ClassLoader cLoader;
    private final List<String> bundleNames = new ArrayList<String>();
    private ResourceMap parent = null;

    public ResourceMaps(Class<?> c) {
        this(c, Locale.getDefault());
    }

    public ResourceMaps(Class<?> c, Locale locale) {
        if (c == null) {
            throw new NullPointerException("Class cannot be null.");
        }
        if (locale == null) {
            throw new NullPointerException("Locale cannot be null.");
        }
        this.bundleLocale = locale;
        this.cLoader = c.getClassLoader();
        String baseName = ResourceMaps.createBundleName(c);
        this.bundleNames.add(String.valueOf(baseName) + "_" + locale.toString());
        this.bundleNames.add(baseName);
    }

    public ResourceMaps withParent(ResourceMap parentMap) {
        this.parent = parentMap;
        return this;
    }

    public ResourceMaps and(Class<?> c) {
        String baseName = ResourceMaps.createBundleName(c);
        this.bundleNames.add(String.valueOf(baseName) + "_" + this.bundleLocale.toString());
        this.bundleNames.add(baseName);
        return this;
    }

    public ResourceMap build() {
        return new ResourceMap(this.parent, this.cLoader, this.bundleNames);
    }

    private static String createBundleName(Class<?> c) {
        return String.valueOf(c.getPackage().getName()) + ".resources." + c.getSimpleName();
    }
}

