/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.springboot;

import com.dtflys.forest.spring.ForestBeanProcessor;
import com.dtflys.forest.springboot.ForestBeanRegister;
import com.dtflys.forest.springboot.annotation.ForestScannerRegister;
import com.dtflys.forest.springboot.properties.ForestConfigurationProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Role;

@Configuration(proxyBeanMethods=false)
@Role(value=2)
@ComponentScan(value={"com.dtflys.forest.springboot.properties"})
@EnableConfigurationProperties(value={ForestConfigurationProperties.class})
@Import(value={ForestScannerRegister.class})
public class ForestAutoConfiguration {
    @Autowired(required=false)
    private ConfigurableApplicationContext applicationContext;

    @Bean
    @ConditionalOnMissingBean
    public ForestBeanProcessor forestBeanProcessor() {
        return new ForestBeanProcessor();
    }

    @Bean
    @ConditionalOnMissingBean
    public ForestBeanRegister getForestBeanRegister(ForestConfigurationProperties forestConfigurationProperties) {
        ForestBeanRegister register = new ForestBeanRegister(this.applicationContext, forestConfigurationProperties);
        register.registerForestConfiguration(forestConfigurationProperties);
        register.registerScanner(forestConfigurationProperties);
        return register;
    }
}

