/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.springboot.properties;

import com.dtflys.forest.backend.AsyncAbortPolicy;
import com.dtflys.forest.callback.AddressSource;
import com.dtflys.forest.callback.RetryWhen;
import com.dtflys.forest.callback.SuccessWhen;
import com.dtflys.forest.http.ForestAsyncMode;
import com.dtflys.forest.interceptor.Interceptor;
import com.dtflys.forest.logging.DefaultLogHandler;
import com.dtflys.forest.logging.ForestLogHandler;
import com.dtflys.forest.retryer.BackOffRetryer;
import com.dtflys.forest.springboot.properties.ForestConvertProperties;
import com.dtflys.forest.springboot.properties.ForestSSLKeyStoreProperties;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.RejectedExecutionHandler;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Role;
import org.springframework.stereotype.Component;

@Component
@Role(value=2)
@ConfigurationProperties(prefix="forest", ignoreUnknownFields=true)
public class ForestConfigurationProperties {
    private String beanId;
    private int maxConnections = 500;
    private int maxRouteConnections = 500;
    private int maxRequestQueueSize = 200;
    private int maxAsyncThreadSize = 200;
    private int maxAsyncQueueSize = 100;
    private Class<? extends RejectedExecutionHandler> asyncRejectPolicyClass = AsyncAbortPolicy.class;
    private ForestAsyncMode asyncMode = ForestAsyncMode.PLATFORM;
    private int timeout = 3000;
    private Integer connectTimeout = null;
    private Integer readTimeout = null;
    private String charset = "UTF-8";
    private String baseAddressScheme;
    private String baseAddressHost;
    private Integer baseAddressPort;
    private Class<? extends AddressSource> baseAddressSource;
    private Class retryer = BackOffRetryer.class;
    private Integer maxRetryCount = 0;
    private long maxRetryInterval = 0L;
    private boolean autoRedirection = true;
    private boolean logEnabled = true;
    private boolean logRequest = true;
    private boolean logResponseStatus = true;
    private boolean logResponseContent = false;
    private Class<? extends ForestLogHandler> logHandler = DefaultLogHandler.class;
    private String sslProtocol = "TLSv1.2";
    private String backend = "okhttp3";
    private Integer backendClientCacheMaxSize = 128;
    private Duration backendClientCacheExpireTime;
    private Map<String, Object> variables = new HashMap<String, Object>();
    private List<Class<? extends Interceptor>> interceptors = new ArrayList<Class<? extends Interceptor>>();
    private Class<? extends SuccessWhen> successWhen;
    private Class<? extends RetryWhen> retryWhen;
    private List<ForestSSLKeyStoreProperties> sslKeyStores = new ArrayList<ForestSSLKeyStoreProperties>();
    private ForestConvertProperties converters = new ForestConvertProperties();
    private Map<String, Class> filters = new HashMap<String, Class>();

    public String getBeanId() {
        return this.beanId;
    }

    public void setBeanId(String beanId) {
        this.beanId = beanId;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public int getMaxRouteConnections() {
        return this.maxRouteConnections;
    }

    public void setMaxRouteConnections(int maxRouteConnections) {
        this.maxRouteConnections = maxRouteConnections;
    }

    public int getMaxRequestQueueSize() {
        return this.maxRequestQueueSize;
    }

    public void setMaxRequestQueueSize(int maxRequestQueueSize) {
        this.maxRequestQueueSize = maxRequestQueueSize;
    }

    public int getMaxAsyncThreadSize() {
        return this.maxAsyncThreadSize;
    }

    public void setMaxAsyncThreadSize(int maxAsyncThreadSize) {
        this.maxAsyncThreadSize = maxAsyncThreadSize;
    }

    public int getMaxAsyncQueueSize() {
        return this.maxAsyncQueueSize;
    }

    public void setMaxAsyncQueueSize(int maxAsyncQueueSize) {
        this.maxAsyncQueueSize = maxAsyncQueueSize;
    }

    public Class<? extends RejectedExecutionHandler> getAsyncRejectPolicyClass() {
        return this.asyncRejectPolicyClass;
    }

    public void setAsyncRejectPolicyClass(Class<? extends RejectedExecutionHandler> asyncRejectPolicyClass) {
        this.asyncRejectPolicyClass = asyncRejectPolicyClass;
    }

    public ForestAsyncMode getAsyncMode() {
        return this.asyncMode;
    }

    public void setAsyncMode(ForestAsyncMode asyncMode) {
        this.asyncMode = asyncMode;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public Integer getConnectTimeout() {
        return this.connectTimeout;
    }

    public Integer getConnectTimeoutMillis() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(Integer connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    public Integer getReadTimeoutMillis() {
        return this.readTimeout;
    }

    public void setReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getBaseAddressScheme() {
        return this.baseAddressScheme;
    }

    public void setBaseAddressScheme(String baseAddressScheme) {
        this.baseAddressScheme = baseAddressScheme;
    }

    public String getBaseAddressHost() {
        return this.baseAddressHost;
    }

    public void setBaseAddressHost(String baseAddressHost) {
        this.baseAddressHost = baseAddressHost;
    }

    public Integer getBaseAddressPort() {
        return this.baseAddressPort;
    }

    public void setBaseAddressPort(Integer baseAddressPort) {
        this.baseAddressPort = baseAddressPort;
    }

    public Class<? extends AddressSource> getBaseAddressSource() {
        return this.baseAddressSource;
    }

    public void setBaseAddressSource(Class<? extends AddressSource> baseAddressSource) {
        this.baseAddressSource = baseAddressSource;
    }

    public Class getRetryer() {
        return this.retryer;
    }

    public void setRetryer(Class retryer) {
        this.retryer = retryer;
    }

    @Deprecated
    public int getRetryCount() {
        return this.maxRetryCount;
    }

    @Deprecated
    public void setRetryCount(int retryCount) {
        this.maxRetryCount = retryCount;
    }

    public int getMaxRetryCount() {
        return this.maxRetryCount;
    }

    public void setMaxRetryCount(int retryCount) {
        this.maxRetryCount = retryCount;
    }

    public long getMaxRetryInterval() {
        return this.maxRetryInterval;
    }

    public void setMaxRetryInterval(long maxRetryInterval) {
        this.maxRetryInterval = maxRetryInterval;
    }

    public boolean isAutoRedirection() {
        return this.autoRedirection;
    }

    public void setAutoRedirection(boolean autoRedirection) {
        this.autoRedirection = autoRedirection;
    }

    public boolean isLogEnabled() {
        return this.logEnabled;
    }

    public void setLogEnabled(boolean logEnabled) {
        this.logEnabled = logEnabled;
    }

    public boolean isLogRequest() {
        return this.logRequest;
    }

    public void setLogRequest(boolean logRequest) {
        this.logRequest = logRequest;
    }

    public boolean isLogResponseStatus() {
        return this.logResponseStatus;
    }

    public void setLogResponseStatus(boolean logResponseStatus) {
        this.logResponseStatus = logResponseStatus;
    }

    public boolean isLogResponseContent() {
        return this.logResponseContent;
    }

    public void setLogResponseContent(boolean logResponseContent) {
        this.logResponseContent = logResponseContent;
    }

    public Class<? extends ForestLogHandler> getLogHandler() {
        return this.logHandler;
    }

    public void setLogHandler(Class<? extends ForestLogHandler> logHandler) {
        this.logHandler = logHandler;
    }

    public String getSslProtocol() {
        return this.sslProtocol;
    }

    public void setSslProtocol(String sslProtocol) {
        this.sslProtocol = sslProtocol;
    }

    public String getBackend() {
        return this.backend;
    }

    public void setBackend(String backend) {
        this.backend = backend;
    }

    public Integer getBackendClientCacheMaxSize() {
        return this.backendClientCacheMaxSize;
    }

    public void setBackendClientCacheMaxSize(Integer backendClientCacheMaxSize) {
        this.backendClientCacheMaxSize = backendClientCacheMaxSize;
    }

    public Duration getBackendClientCacheExpireTime() {
        return this.backendClientCacheExpireTime;
    }

    public void setBackendClientCacheExpireTime(Duration backendClientCacheExpireTime) {
        this.backendClientCacheExpireTime = backendClientCacheExpireTime;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, Object> variables) {
        this.variables = variables;
    }

    public List<Class<? extends Interceptor>> getInterceptors() {
        return this.interceptors;
    }

    public void setInterceptors(List<Class<? extends Interceptor>> interceptors) {
        this.interceptors = interceptors;
    }

    public Class<? extends SuccessWhen> getSuccessWhen() {
        return this.successWhen;
    }

    public void setSuccessWhen(Class<? extends SuccessWhen> successWhen) {
        this.successWhen = successWhen;
    }

    public Class<? extends RetryWhen> getRetryWhen() {
        return this.retryWhen;
    }

    public void setRetryWhen(Class<? extends RetryWhen> retryWhen) {
        this.retryWhen = retryWhen;
    }

    public List<ForestSSLKeyStoreProperties> getSslKeyStores() {
        return this.sslKeyStores;
    }

    public void setSslKeyStores(List<ForestSSLKeyStoreProperties> sslKeyStores) {
        this.sslKeyStores = sslKeyStores;
    }

    public ForestConvertProperties getConverters() {
        return this.converters;
    }

    public void setConverters(ForestConvertProperties converters) {
        this.converters = converters;
    }

    public Map<String, Class> getFilters() {
        return this.filters;
    }

    public void setFilters(Map<String, Class> filters) {
        this.filters = filters;
    }
}

