/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.springboot;

import com.dtflys.forest.config.SpringForestProperties;
import com.dtflys.forest.interceptor.SpringInterceptorFactory;
import com.dtflys.forest.reflection.SpringForestObjectFactory;
import com.dtflys.forest.spring.ForestBeanProcessor;
import com.dtflys.forest.springboot.ForestBeanRegister;
import com.dtflys.forest.springboot.annotation.ForestScannerRegister;
import com.dtflys.forest.springboot.properties.ForestConfigurationProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Role;

@Configuration
@EnableConfigurationProperties(value={ForestConfigurationProperties.class})
@Import(value={ForestScannerRegister.class})
@Role(value=2)
public class ForestAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @Role(value=2)
    public SpringForestProperties forestProperties() {
        return new SpringForestProperties();
    }

    @Bean
    @ConditionalOnMissingBean
    @Role(value=2)
    public SpringForestObjectFactory forestObjectFactory() {
        return new SpringForestObjectFactory();
    }

    @Bean
    @ConditionalOnMissingBean
    @Role(value=2)
    public SpringInterceptorFactory forestInterceptorFactory() {
        return new SpringInterceptorFactory();
    }

    @Bean
    @DependsOn(value={"forestBeanProcessor"})
    @ConditionalOnMissingBean
    @Role(value=2)
    public ForestBeanRegister forestBeanRegister(ConfigurableApplicationContext applicationContext, SpringForestProperties properties, SpringForestObjectFactory forestObjectFactory, SpringInterceptorFactory forestInterceptorFactory, ForestConfigurationProperties forestConfigurationProperties) {
        ForestBeanRegister register = new ForestBeanRegister(applicationContext, forestConfigurationProperties, properties, forestObjectFactory, forestInterceptorFactory);
        register.registerForestConfiguration();
        register.registerScanner();
        return register;
    }

    @Bean
    @ConditionalOnMissingBean
    @Role(value=2)
    public ForestBeanProcessor forestBeanProcessor() {
        return new ForestBeanProcessor();
    }
}

