/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.schema;

import com.dtflys.forest.config.ForestConfiguration;
import com.dtflys.forest.exceptions.ForestRuntimeException;
import com.dtflys.forest.http.ForestAsyncMode;
import com.dtflys.forest.interceptor.SpringInterceptorFactory;
import com.dtflys.forest.logging.ForestLogHandler;
import com.dtflys.forest.reflection.SpringForestObjectFactory;
import com.dtflys.forest.ssl.SpringSSLKeyStore;
import com.dtflys.forest.utils.ClientFactoryBeanUtils;
import com.dtflys.forest.utils.ForestDataType;
import com.dtflys.forest.utils.StringUtils;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ForestConfigurationBeanDefinitionParser
implements BeanDefinitionParser {
    private static final Logger LOG = LoggerFactory.getLogger(ForestConfigurationBeanDefinitionParser.class);
    private static final Class<?> FOREST_CONFIGURATION_CLASS = ForestConfiguration.class;
    private static final Class<?> SPRING_SSL_KEY_STORE_CLASS = SpringSSLKeyStore.class;

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        Method[] methods;
        RootBeanDefinition beanDefinition = new RootBeanDefinition();
        beanDefinition.setBeanClass(FOREST_CONFIGURATION_CLASS);
        beanDefinition.setLazyInit(false);
        beanDefinition.setFactoryMethodName("configuration");
        BeanDefinition interceptorBean = this.createInterceptorFactoryBean();
        beanDefinition.getPropertyValues().addPropertyValue("interceptorFactory", (Object)interceptorBean);
        BeanDefinition forestObjectFactoryBean = this.createForestObjectFactoryBean();
        beanDefinition.getPropertyValues().addPropertyValue("forestObjectFactory", (Object)forestObjectFactoryBean);
        String id = element.getAttribute("id");
        id = ClientFactoryBeanUtils.getBeanId(id, FOREST_CONFIGURATION_CLASS, parserContext);
        if (id != null && id.length() > 0) {
            if (parserContext.getRegistry().containsBeanDefinition(id)) {
                throw new IllegalStateException("Duplicate spring bean id " + id);
            }
            parserContext.getRegistry().registerBeanDefinition(id, (BeanDefinition)beanDefinition);
            ConstructorArgumentValues argumentValues = new ConstructorArgumentValues();
            argumentValues.addIndexedArgumentValue(0, (Object)id);
            beanDefinition.setConstructorArgumentValues(argumentValues);
        }
        for (Method method : methods = FOREST_CONFIGURATION_CLASS.getMethods()) {
            String attributeName;
            String attributeValue;
            Class<?> paramType;
            String methodName = method.getName();
            Class<?>[] paramTypes = method.getParameterTypes();
            if (paramTypes.length == 0 || paramTypes.length > 1 || Collections.class.isAssignableFrom(paramType = paramTypes[0]) || Map.class.isAssignableFrom(paramType) || methodName.length() < 3 || !methodName.startsWith("set") || !StringUtils.isNotEmpty((CharSequence)(attributeValue = element.getAttribute(attributeName = methodName.substring(3, 4).toLowerCase() + methodName.substring(4))))) continue;
            if ("backend".equals(attributeName)) {
                beanDefinition.getPropertyValues().addPropertyValue("backendName", (Object)attributeValue);
                continue;
            }
            if ("asyncMode".equals(attributeName)) {
                if (StringUtils.isEmpty((CharSequence)attributeValue)) {
                    throw new ForestRuntimeException("Can not resolve async mode '" + attributeValue + "'");
                }
                String enumName = attributeValue.trim().toUpperCase();
                ForestAsyncMode mode = ForestAsyncMode.valueOf((String)enumName);
                if (mode == null) {
                    throw new ForestRuntimeException("Can not resolve async mode '" + enumName + "'");
                }
                beanDefinition.getPropertyValues().addPropertyValue("asyncMode", (Object)mode);
                continue;
            }
            if ("logHandler".equals(attributeName)) {
                try {
                    Class<?> clazz = Class.forName(attributeValue);
                    if (!ForestLogHandler.class.isAssignableFrom(clazz)) {
                        throw new ForestRuntimeException("property 'logHandler' must be a class extending from com.dtflys.forest.logging.ForestLogHandler");
                    }
                    ForestLogHandler handler = (ForestLogHandler)clazz.newInstance();
                    beanDefinition.getPropertyValues().addPropertyValue("logHandler", (Object)handler);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    throw new ForestRuntimeException((Throwable)e);
                }
                catch (IllegalAccessException e) {
                    throw new ForestRuntimeException((Throwable)e);
                }
                catch (InstantiationException e) {
                    throw new ForestRuntimeException((Throwable)e);
                }
            }
            beanDefinition.getPropertyValues().addPropertyValue(attributeName, (Object)attributeValue);
        }
        this.parseChildren(element.getChildNodes(), beanDefinition);
        LOG.info("[Forest] Created Forest Configuration Bean: " + beanDefinition);
        return beanDefinition;
    }

    public void parseChildren(NodeList nodeList, RootBeanDefinition beanDefinition) {
        int nodesLength = nodeList.getLength();
        if (nodesLength > 0) {
            ManagedMap varMap = new ManagedMap();
            ManagedMap sslKeyStoreMap = new ManagedMap();
            ManagedMap converterMap = new ManagedMap();
            for (int i = 0; i < nodesLength; ++i) {
                Node node = nodeList.item(i);
                if (!(node instanceof Element)) continue;
                Element elem = (Element)node;
                String elemName = elem.getLocalName();
                if (elemName.equals("var")) {
                    this.parseVariable(elem, (ManagedMap<String, Object>)varMap);
                    continue;
                }
                if (elemName.equals("ssl-keystore")) {
                    this.parseSSLKeyStore(elem, (ManagedMap<String, BeanDefinition>)sslKeyStoreMap);
                    continue;
                }
                if (!elemName.equals("converter")) continue;
                ForestConfigurationBeanDefinitionParser.parseConverter(elem, (ManagedMap<ForestDataType, BeanDefinition>)converterMap);
            }
            beanDefinition.getPropertyValues().addPropertyValue("variables", (Object)varMap);
            beanDefinition.getPropertyValues().addPropertyValue("sslKeyStores", (Object)sslKeyStoreMap);
            beanDefinition.getPropertyValues().addPropertyValue("toMergeConverterMap", (Object)converterMap);
        }
    }

    public void parseVariable(Element elem, ManagedMap<String, Object> varMap) {
        String name = elem.getAttribute("name");
        String value = elem.getAttribute("value");
        varMap.put((Object)name, (Object)value);
    }

    public void parseSSLKeyStore(Element elem, ManagedMap<String, BeanDefinition> sslKeyStoreMap) {
        String id = elem.getAttribute("id");
        String filePath = elem.getAttribute("file");
        String keystoreType = elem.getAttribute("type");
        String keystorePass = elem.getAttribute("keystorePass");
        String certPass = elem.getAttribute("certPass");
        String protocolsStr = elem.getAttribute("protocols");
        String cipherSuitesStr = elem.getAttribute("cipher-suites");
        String trustManager = elem.getAttribute("trustManager");
        String hostnameVerifier = elem.getAttribute("hostnameVerifier");
        String sslSocketFactoryBuilder = elem.getAttribute("sslSocketFactoryBuilder");
        if (StringUtils.isEmpty((CharSequence)keystoreType)) {
            keystoreType = "jks";
        }
        BeanDefinition beanDefinition = ForestConfigurationBeanDefinitionParser.createSSLKeyStoreBean(id, keystoreType, filePath, keystorePass, certPass, protocolsStr, cipherSuitesStr, trustManager, hostnameVerifier, sslSocketFactoryBuilder);
        sslKeyStoreMap.put((Object)id, (Object)beanDefinition);
    }

    public static BeanDefinition createSSLKeyStoreBean(String id, String keystoreType, String filePath, String keystorePass, String certPass, String protocolsStr, String cipherSuitesStr, String trustManagerClass, String hostnameVerifierClass, String sslSocketFactoryBuilder) {
        int i;
        String[] strs;
        GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
        beanDefinition.setBeanClassName(SPRING_SSL_KEY_STORE_CLASS.getName());
        ConstructorArgumentValues beanDefValues = beanDefinition.getConstructorArgumentValues();
        beanDefValues.addGenericArgumentValue((Object)id);
        beanDefValues.addGenericArgumentValue((Object)keystoreType);
        beanDefValues.addGenericArgumentValue((Object)filePath);
        beanDefValues.addGenericArgumentValue((Object)keystorePass);
        beanDefValues.addGenericArgumentValue((Object)certPass);
        beanDefValues.addGenericArgumentValue((Object)trustManagerClass);
        beanDefValues.addGenericArgumentValue((Object)hostnameVerifierClass);
        beanDefValues.addGenericArgumentValue((Object)sslSocketFactoryBuilder);
        if (StringUtils.isNotEmpty((CharSequence)protocolsStr)) {
            strs = protocolsStr.split("[ /t]*,[ /t]*");
            String[] protocols = new String[strs.length];
            for (i = 0; i < strs.length; ++i) {
                protocols[i] = strs[i].trim();
            }
            beanDefinition.getPropertyValues().add("protocols", (Object)protocols);
        }
        if (StringUtils.isNotEmpty((CharSequence)cipherSuitesStr)) {
            strs = cipherSuitesStr.split("[ /t]*,[ /t]*");
            String[] cipherSuites = new String[strs.length];
            for (i = 0; i < strs.length; ++i) {
                cipherSuites[i] = strs[i].trim();
            }
            beanDefinition.getPropertyValues().add("cipherSuites", (Object)cipherSuites);
        }
        return beanDefinition;
    }

    private static void parseConverter(Element elem, ManagedMap<ForestDataType, BeanDefinition> converterMap) {
        String dataTypeName = elem.getAttribute("dataType");
        ForestDataType dataType = ForestDataType.findOrCreateDataType((String)dataTypeName);
        if (dataType == null) {
            throw new ForestRuntimeException("Cannot find data type named '" + dataTypeName + "'");
        }
        String className = elem.getAttribute("class");
        BeanDefinition definition = ForestConfigurationBeanDefinitionParser.createConverterBean(className);
        NodeList nodeList = elem.getChildNodes();
        int nodeLength = nodeList.getLength();
        if (nodeLength > 0) {
            for (int i = 0; i < nodeLength; ++i) {
                Element childElem;
                String childElemName;
                Node node = nodeList.item(i);
                if (!(node instanceof Element) || !(childElemName = (childElem = (Element)node).getLocalName()).equals("parameter")) continue;
                String paramName = childElem.getAttribute("name");
                String paramValue = childElem.getAttribute("value");
                definition.getPropertyValues().addPropertyValue(paramName, (Object)paramValue);
            }
        }
        converterMap.put((Object)dataType, (Object)definition);
    }

    public static BeanDefinition createConverterBean(String className) {
        GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
        beanDefinition.setBeanClassName(className);
        return beanDefinition;
    }

    public BeanDefinition createInterceptorFactoryBean() {
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(SpringInterceptorFactory.class);
        AbstractBeanDefinition beanDefinition = beanDefinitionBuilder.getRawBeanDefinition();
        return beanDefinition;
    }

    public BeanDefinition createForestObjectFactoryBean() {
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(SpringForestObjectFactory.class);
        AbstractBeanDefinition beanDefinition = beanDefinitionBuilder.getRawBeanDefinition();
        return beanDefinition;
    }
}

