/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.fx.icons.ikonli;

import com.dua3.fx.icons.Icon;
import com.dua3.fx.icons.IconProvider;
import java.util.Objects;
import java.util.ServiceLoader;
import javafx.scene.Node;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.IkonHandler;
import org.kordamp.ikonli.javafx.FontIcon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IkonliIconProvider
implements IconProvider {
    private static final Logger LOG = LoggerFactory.getLogger(IkonliIconProvider.class);

    public String name() {
        return this.getClass().getSimpleName();
    }

    public IkonliIcon forName(String name) {
        for (IkonHandler handler : ServiceLoader.load(IkonHandler.class)) {
            if (!handler.supports(name)) continue;
            LOG.debug("using: {}", (Object)handler.getClass().getName());
            Ikon ikon = handler.resolve(name);
            return new IkonliIcon(ikon, name);
        }
        LOG.debug("icon not found: {}", (Object)name);
        return null;
    }

    static class IkonliIcon
    extends FontIcon
    implements Icon {
        private final String name;

        IkonliIcon(Ikon ikon, String name) {
            super(ikon);
            this.name = Objects.requireNonNull(name);
        }

        public String getIconIdentifier() {
            return this.name;
        }

        public Node node() {
            return this;
        }
    }
}

