/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.fx.icons;

import com.dua3.fx.icons.EmptyIcon;
import com.dua3.fx.icons.Icon;
import com.dua3.fx.icons.IconProvider;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IconUtil {
    private static final Logger LOG = LoggerFactory.getLogger(IconUtil.class);

    private IconUtil() {
    }

    public static Optional<Icon> iconFromName(String name) {
        Class<IconProvider> iconProviderClass = IconProvider.class;
        return ServiceLoader.load(iconProviderClass).stream().peek(provider -> LOG.debug("found {} implementation: {}", (Object)iconProviderClass.getName(), (Object)provider.getClass().getName())).map(provider -> ((IconProvider)provider.get()).forName(name)).filter(Objects::nonNull).findFirst();
    }

    public static Collection<String> iconProviderNames() {
        Class<IconProvider> iconProviderClass = IconProvider.class;
        return ServiceLoader.load(iconProviderClass).stream().map(p -> p.type().getName()).toList();
    }

    public static Icon emptyIcon() {
        return new EmptyIcon();
    }
}

