/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.fx.icons;

import com.dua3.fx.icons.Icon;
import com.dua3.fx.icons.IconUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javafx.beans.value.ObservableValue;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableIntegerProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.StyleableStringProperty;
import javafx.css.converter.PaintConverter;
import javafx.css.converter.SizeConverter;
import javafx.css.converter.StringConverter;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IconView
extends Control {
    private static final Logger LOG = LoggerFactory.getLogger(IconView.class);
    private static final String DEFAULT_ICON_IDENTIFIER = "";
    private static final int DEFAULT_ICON_SIZE = 10;
    private static final Paint DEFAULT_ICON_COLOR = Paint.valueOf((String)"BLACK");
    private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;
    private final StackPane pane;
    private Icon icon;
    private final StyleableStringProperty iconIdentifier = new StyleableStringProperty(""){

        public CssMetaData<IconView, String> getCssMetaData() {
            return StyleableProperties.ICON_IDENTIFIER;
        }

        public Object getBean() {
            return IconView.this;
        }

        public String getName() {
            return "iconIdentifier";
        }
    };
    private final StyleableObjectProperty<Paint> iconColor = new StyleableObjectProperty<Paint>(DEFAULT_ICON_COLOR){

        public CssMetaData<IconView, Paint> getCssMetaData() {
            return StyleableProperties.ICON_COLOR;
        }

        public Object getBean() {
            return IconView.this;
        }

        public String getName() {
            return "iconColor";
        }
    };
    private final StyleableIntegerProperty iconSize = new StyleableIntegerProperty(10){

        public CssMetaData<IconView, Number> getCssMetaData() {
            return StyleableProperties.ICON_SIZE;
        }

        public Object getBean() {
            return IconView.this;
        }

        public String getName() {
            return "iconSize";
        }
    };

    public IconView() {
        this.pane = new StackPane();
        this.getChildren().setAll((Object[])new Node[]{this.pane});
        this.iconIdentifier.addListener((v, o, n) -> this.setIcon((String)n));
    }

    public IconView(String iconId, int size, Paint color) {
        this();
        this.setIcon(iconId);
        this.setIconSize(size);
        this.setIconColor(color);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return STYLEABLES;
    }

    private void setIcon(String iconId) {
        int size = this.getIconSize();
        Paint color = this.getIconColor();
        Optional<Icon> icon = IconUtil.iconFromName(iconId);
        if (icon.isPresent()) {
            this.icon = icon.get();
        } else {
            LOG.warn("icon not found: {}", (Object)iconId);
            this.icon = IconUtil.emptyIcon();
        }
        this.icon.iconSizeProperty().bind((ObservableValue)this.iconSize);
        this.icon.iconColorProperty().bind(this.iconColor);
        this.iconSize.set(size);
        this.iconColor.set((Object)color);
        this.pane.getChildren().setAll((Object[])new Node[]{this.icon.node()});
    }

    protected Skin<?> createDefaultSkin() {
        return new IconViewSkin(this);
    }

    public String toString() {
        return this.iconIdentifier.get();
    }

    public String getIconIdentifier() {
        return this.iconIdentifier.getValue();
    }

    public void setIconIdentifier(String icon) {
        this.iconIdentifier.set(icon);
    }

    public Paint getIconColor() {
        return (Paint)this.iconColor.getValue();
    }

    public void setIconColor(Paint color) {
        this.iconColor.set((Object)color);
    }

    public int getIconSize() {
        return this.iconSize.get();
    }

    public void setIconSize(int size) {
        this.iconSize.set(size);
    }

    static {
        ArrayList<Object> styleables = new ArrayList<Object>(Control.getClassCssMetaData());
        styleables.add(StyleableProperties.ICON_IDENTIFIER);
        styleables.add(StyleableProperties.ICON_COLOR);
        styleables.add(StyleableProperties.ICON_SIZE);
        STYLEABLES = Collections.unmodifiableList(styleables);
    }

    private static class IconViewSkin
    extends SkinBase<IconView> {
        protected IconViewSkin(IconView control) {
            super((Control)control);
            this.consumeMouseEvents(false);
        }
    }

    private static final class StyleableProperties {
        public static final CssMetaData<IconView, Number> ICON_SIZE = new CssMetaData<IconView, Number>("-fx-icon-size", SizeConverter.getInstance(), (Number)16.0){

            public boolean isSettable(IconView icon) {
                return true;
            }

            public StyleableProperty<Number> getStyleableProperty(IconView iv) {
                return iv.iconSize;
            }
        };
        public static final CssMetaData<IconView, Paint> ICON_COLOR = new CssMetaData<IconView, Paint>("-fx-icon-color", PaintConverter.getInstance(), (Paint)Color.BLACK){

            public boolean isSettable(IconView node) {
                return true;
            }

            public StyleableProperty<Paint> getStyleableProperty(IconView iv) {
                return iv.iconColor;
            }
        };
        public static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;
        private static final CssMetaData<IconView, String> ICON_IDENTIFIER;

        private StyleableProperties() {
        }

        static {
            ICON_IDENTIFIER = new CssMetaData<IconView, String>("-fx-icon-identifier", StringConverter.getInstance(), IconView.DEFAULT_ICON_IDENTIFIER){

                public boolean isSettable(IconView iv) {
                    return true;
                }

                public StyleableProperty<String> getStyleableProperty(IconView iv) {
                    return iv.iconIdentifier;
                }
            };
            ArrayList<Object> styleables = new ArrayList<Object>(Node.getClassCssMetaData());
            styleables.add(ICON_SIZE);
            styleables.add(ICON_COLOR);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

