/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.fx.controls;

import com.dua3.utility.fx.controls.AboutDialog;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.StackPane;
import javafx.scene.text.Text;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jspecify.annotations.Nullable;

public class AboutDialogBuilder {
    private static final Logger LOG = LogManager.getLogger(AboutDialogBuilder.class);
    private String title = "";
    private String name = "";
    private String copyright = "";
    private String version = "";
    private String mailText = "";
    private String mailAddress = "";
    private final @Nullable Window parentWindow;
    private @Nullable URL css;
    private @Nullable Node graphic;
    private @Nullable Node expandableContent;

    AboutDialogBuilder(@Nullable Window parentWindow) {
        this.parentWindow = parentWindow;
    }

    public AboutDialogBuilder title(String title) {
        if (title == null) {
            throw new NullPointerException("arg#1 is null");
        }
        this.title = title;
        return this;
    }

    public AboutDialogBuilder name(String name) {
        if (name == null) {
            throw new NullPointerException("arg#1 is null");
        }
        this.name = name;
        return this;
    }

    public AboutDialogBuilder version(String version) {
        if (version == null) {
            throw new NullPointerException("arg#1 is null");
        }
        this.version = version;
        return this;
    }

    public AboutDialogBuilder copyright(String text) {
        if (text == null) {
            throw new NullPointerException("arg#1 is null");
        }
        this.copyright = text;
        return this;
    }

    public AboutDialogBuilder mail(String address) {
        if (address == null) {
            throw new NullPointerException("arg#1 is null");
        }
        this.mailText = address;
        this.mailAddress = "mailto:" + address;
        return this;
    }

    public AboutDialogBuilder mail(String text, String mailtoUri) {
        if (text == null) {
            throw new NullPointerException("arg#1 is null");
        }
        if (mailtoUri == null) {
            throw new NullPointerException("arg#2 is null");
        }
        this.mailText = text;
        this.mailAddress = mailtoUri;
        return this;
    }

    public AboutDialogBuilder css(URL css) {
        if (css == null) {
            throw new NullPointerException("arg#1 is null");
        }
        this.css = css;
        return this;
    }

    public AboutDialogBuilder graphic(@Nullable URL url) {
        if (url == null) {
            this.graphic = null;
            return this;
        }
        try (InputStream in = url.openStream();){
            Image image = new Image(in);
            this.graphic((Node)new ImageView(image));
        }
        catch (IOException e) {
            LOG.warn("could not read image: {}", (Object)url, (Object)e);
            this.graphic = null;
        }
        return this;
    }

    public AboutDialogBuilder graphic(Node graphic) {
        if (graphic == null) {
            throw new NullPointerException("arg#1 is null");
        }
        this.graphic = graphic;
        return this;
    }

    public AboutDialogBuilder expandableContent(Node c) {
        if (c == null) {
            throw new NullPointerException("arg#1 is null");
        }
        this.expandableContent = c;
        return this;
    }

    public AboutDialogBuilder expandableContent(@Nullable String text) {
        if (text == null || text.isBlank()) {
            this.expandableContent = null;
            return this;
        }
        this.expandableContent = new StackPane(new Node[]{new Text(text)});
        return this;
    }

    public void showAndWait() {
        this.build().showAndWait();
    }

    public AboutDialog build() {
        AboutDialog dlg = new AboutDialog(this.css);
        if (this.parentWindow != null) {
            Stage stage = (Stage)dlg.getDialogPane().getScene().getWindow();
            stage.getIcons().addAll((Collection)((Stage)this.parentWindow).getIcons());
        }
        if (this.graphic != null) {
            dlg.setGraphic(this.graphic);
        }
        if (!this.title.isBlank()) {
            dlg.setTitle(this.title);
        }
        if (!this.name.isBlank()) {
            dlg.setName(this.name);
        }
        if (!this.copyright.isBlank()) {
            dlg.setCopyright(this.copyright);
        }
        if (!this.version.isBlank()) {
            dlg.setVersion(this.version);
        }
        if (!this.mailText.isBlank()) {
            dlg.setEmailText(this.mailText);
        }
        if (this.mailAddress != null) {
            dlg.setEmailAddress(this.mailAddress);
        }
        if (this.expandableContent != null) {
            dlg.getDialogPane().setExpandableContent(this.expandableContent);
        }
        return dlg;
    }
}

