/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.fx.controls;

import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javafx.scene.control.ButtonType;
import org.jspecify.annotations.Nullable;

public abstract class AbstractDialogPaneBuilder<D, B extends AbstractDialogPaneBuilder<D, B, R>, R> {
    private final BiConsumer<? super D, ? super String> headerSetter;
    private Supplier<? extends D> dialogSupplier;
    private String header;
    private ResultHandler<R> resultHandler;

    AbstractDialogPaneBuilder(BiConsumer<? super D, ? super String> headerSetter) {
        assert (headerSetter != null) : "arg#1 is null";
        this.header = null;
        this.resultHandler = (b, r) -> true;
        this.dialogSupplier = () -> {
            throw new IllegalStateException("call setDialogSupplier() first");
        };
        this.headerSetter = headerSetter;
    }

    protected final void setDialogSupplier(Supplier<? extends D> dialogSupplier) {
        assert (dialogSupplier != null) : "arg#1 is null";
        this.dialogSupplier = dialogSupplier;
    }

    public D build() {
        D dlg = this.dialogSupplier.get();
        AbstractDialogPaneBuilder.applyIfNotNull(this.headerSetter, dlg, this.header);
        return dlg;
    }

    protected static <C, D> void applyIfNotNull(BiConsumer<C, D> consumer, @Nullable C a, @Nullable D b) {
        assert (consumer != null) : "arg#1 is null";
        if (a != null && b != null) {
            consumer.accept(a, b);
        }
    }

    public B header(String fmt, Object ... args) {
        if (fmt == null) {
            throw new NullPointerException("arg#1 is null");
        }
        if (args == null) {
            throw new NullPointerException("arg#2 is null");
        }
        this.header = String.format(fmt, args);
        return (B)this;
    }

    public B resultHandler(ResultHandler<R> resultHandler) {
        if (resultHandler == null) {
            throw new NullPointerException("arg#1 is null");
        }
        this.resultHandler = resultHandler;
        return (B)this;
    }

    public ResultHandler<R> getResultHandler() {
        return this.resultHandler;
    }

    @FunctionalInterface
    public static interface ResultHandler<R> {
        public boolean handleResult(ButtonType var1, R var2);
    }
}

