/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.fx.controls;

import com.dua3.utility.fx.controls.AbstractPaneBuilder;
import com.dua3.utility.fx.controls.InputDialogPane;
import javafx.scene.control.Alert;
import javafx.scene.control.DialogPane;
import org.jspecify.annotations.Nullable;

public class AlertPaneBuilder
extends AbstractPaneBuilder<InputDialogPane<Void>, AlertPaneBuilder, Void> {
    private @Nullable String text;

    AlertPaneBuilder(Alert.AlertType type) {
        assert (type != null) : "arg#1 is null";
        this.setDialogSupplier(() -> AlertPaneBuilder.createPane(type));
    }

    private static InputDialogPane<Void> createPane(Alert.AlertType type) {
        assert (type != null) : "arg#1 is null";
        return new InputDialogPane<Void>(){

            @Override
            public void init() {
                this.valid.set(true);
            }

            @Override
            public Void get() {
                return null;
            }
        };
    }

    public AlertPaneBuilder text(String fmt, Object ... args) {
        if (fmt == null) {
            throw new NullPointerException("arg#1 is null");
        }
        if (args == null) {
            throw new NullPointerException("arg#2 is null");
        }
        this.text = String.format(fmt, args);
        return this;
    }

    @Override
    public InputDialogPane<Void> build() {
        InputDialogPane inputPane = (InputDialogPane)super.build();
        AlertPaneBuilder.applyIfNotNull(DialogPane::setContentText, inputPane, this.text);
        return inputPane;
    }
}

