/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.fx.controls;

import java.util.function.Supplier;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.Tooltip;

public class ButtonBuilder<B extends ButtonBase> {
    private final Supplier<? extends B> factory;
    private String text;
    private Node graphic;
    private String tooltip;
    private EventHandler<ActionEvent> action;
    private ObservableValue<Boolean> disabled;

    ButtonBuilder(Supplier<? extends B> factory) {
        assert (factory != null) : "arg#1 is null";
        this.text = null;
        this.graphic = null;
        this.tooltip = null;
        this.action = null;
        this.disabled = null;
        this.factory = factory;
    }

    public ButtonBuilder<B> text(String text) {
        if (text == null) {
            throw new NullPointerException("arg#1 is null");
        }
        this.text = text;
        return this;
    }

    public ButtonBuilder<B> graphic(Node graphic) {
        if (graphic == null) {
            throw new NullPointerException("arg#1 is null");
        }
        this.graphic = graphic;
        return this;
    }

    public ButtonBuilder<B> tooltip(String tooltip) {
        if (tooltip == null) {
            throw new NullPointerException("arg#1 is null");
        }
        this.tooltip = tooltip;
        return this;
    }

    public ButtonBuilder<B> action(EventHandler<ActionEvent> action) {
        if (action == null) {
            throw new NullPointerException("arg#1 is null");
        }
        this.action = action;
        return this;
    }

    public ButtonBuilder<B> action(Runnable action) {
        if (action == null) {
            throw new NullPointerException("arg#1 is null");
        }
        this.action = evt -> action.run();
        return this;
    }

    public ButtonBuilder<B> bindDisabled(ObservableValue<Boolean> disabled) {
        if (disabled == null) {
            throw new NullPointerException("arg#1 is null");
        }
        this.disabled = disabled;
        return this;
    }

    public B build() {
        ButtonBase control = (ButtonBase)this.factory.get();
        if (this.text != null) {
            control.setText(this.text);
        }
        if (this.graphic != null) {
            control.setGraphic(this.graphic);
        }
        if (this.tooltip != null) {
            control.setTooltip(new Tooltip(this.tooltip));
        }
        if (this.action != null) {
            control.setOnAction(this.action);
        }
        if (this.disabled != null) {
            control.disableProperty().bind(this.disabled);
        }
        return (B)control;
    }
}

