/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.fx.controls;

import com.dua3.utility.fx.controls.InputControl;
import com.dua3.utility.options.ChoiceOption;
import java.util.function.Supplier;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;

public class ChoiceInputControl<T>
implements InputControl<T> {
    private final ComboBox<ChoiceOption.Choice<T>> control;
    private final ChoiceOption<T> option;
    private final Supplier<? extends T> dfltValue;
    private final Property<T> valueProperty;

    public ChoiceInputControl(ChoiceOption<T> option, Supplier<? extends T> dfltValue) {
        if (option == null) {
            throw new NullPointerException("arg#1 is null");
        }
        if (dfltValue == null) {
            throw new NullPointerException("arg#2 is null");
        }
        this.option = option;
        this.dfltValue = dfltValue;
        this.control = new ComboBox();
        this.valueProperty = new SimpleObjectProperty();
        this.control.valueProperty().addListener((v, o, n) -> this.valueProperty.setValue(n == null ? null : n.value()));
        this.valueProperty.addListener((v, o, n) -> this.control.getSelectionModel().select(n == null ? null : option.choice(n)));
        this.control.getItems().setAll(option.choices());
        this.control.getSelectionModel().select((Object)option.choice(dfltValue.get()));
    }

    @Override
    public Node node() {
        return this.control;
    }

    @Override
    public Property<T> valueProperty() {
        return this.valueProperty;
    }

    @Override
    public void reset() {
        this.valueProperty.setValue(this.dfltValue.get());
    }

    @Override
    public ReadOnlyBooleanProperty validProperty() {
        return new SimpleBooleanProperty(true);
    }

    @Override
    public ReadOnlyStringProperty errorProperty() {
        return new SimpleStringProperty("");
    }
}

