/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.fx.controls;

import com.dua3.utility.data.Color;
import com.dua3.utility.fx.FxUtil;
import com.dua3.utility.fx.controls.ButtonBuilder;
import com.dua3.utility.fx.controls.DragResizer;
import com.dua3.utility.fx.controls.FileDialogMode;
import com.dua3.utility.fx.controls.FileInputBuilder;
import com.dua3.utility.fx.controls.Position;
import com.dua3.utility.fx.controls.SliderBuilder;
import com.dua3.utility.fx.controls.SliderWithButtons;
import com.dua3.utility.fx.controls.TextFieldBuilder;
import com.dua3.utility.fx.icons.Icon;
import com.dua3.utility.fx.icons.IconUtil;
import com.dua3.utility.fx.icons.IconView;
import java.io.File;
import java.nio.file.Path;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Separator;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.Region;
import javafx.scene.paint.Paint;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jspecify.annotations.Nullable;

public final class Controls {
    private static final Logger LOG = LogManager.getLogger(Controls.class);

    private Controls() {
    }

    public static ButtonBuilder<Button> button() {
        return new ButtonBuilder<Button>(Button::new);
    }

    public static ButtonBuilder<ToggleButton> toggleButton() {
        return new ButtonBuilder<ToggleButton>(ToggleButton::new);
    }

    public static ButtonBuilder<ToggleButton> toggleButton(boolean selected) {
        return new ButtonBuilder<ToggleButton>(() -> {
            ToggleButton b = new ToggleButton();
            b.setSelected(selected);
            return b;
        });
    }

    public static ButtonBuilder<CheckBox> checkbox() {
        return new ButtonBuilder<CheckBox>(CheckBox::new);
    }

    public static ButtonBuilder<CheckBox> checkbox(boolean selected) {
        return new ButtonBuilder<CheckBox>(() -> {
            CheckBox b = new CheckBox();
            b.setSelected(selected);
            return b;
        });
    }

    public static FileInputBuilder fileInput(FileDialogMode mode) {
        if (mode == null) {
            throw new NullPointerException("arg#1 is null");
        }
        return new FileInputBuilder(mode);
    }

    public static SliderBuilder slider() {
        return new SliderBuilder(SliderWithButtons.Mode.SLIDER_ONLY, (v, t) -> "");
    }

    public static SliderBuilder slider(SliderWithButtons.Mode mode, BiFunction<Double, Double, String> formatter) {
        if (mode == null) {
            throw new NullPointerException("arg#1 is null");
        }
        if (formatter == null) {
            throw new NullPointerException("arg#2 is null");
        }
        return new SliderBuilder(mode, formatter);
    }

    public static Node separator(Orientation orientation) {
        if (orientation == null) {
            throw new NullPointerException("arg#1 is null");
        }
        return new Separator(orientation);
    }

    public static Node graphic(String name) {
        if (name == null) {
            throw new NullPointerException("arg#1 is null");
        }
        return Controls.icon(name).node();
    }

    public static Icon icon(String name) {
        if (name == null) {
            throw new NullPointerException("arg#1 is null");
        }
        return (Icon)IconUtil.iconFromName((String)name).orElseThrow(() -> new IllegalStateException("unknown icon: " + name));
    }

    public static Label rigidLabel(String text) {
        if (text == null) {
            throw new NullPointerException("arg#1 is null");
        }
        Label label = new Label(text);
        label.setMinWidth(Double.NEGATIVE_INFINITY);
        return label;
    }

    public static Label rigidLabel(String text, Node node) {
        if (text == null) {
            throw new NullPointerException("arg#1 is null");
        }
        if (node == null) {
            throw new NullPointerException("arg#2 is null");
        }
        Label label = new Label(text, node);
        label.setMinWidth(Double.NEGATIVE_INFINITY);
        return label;
    }

    public static Node graphic(String name, int size) {
        if (name == null) {
            throw new NullPointerException("arg#1 is null");
        }
        Icon icon = Controls.icon(name);
        icon.setIconSize(size);
        return icon.node();
    }

    public static Node graphic(String name, int size, Paint paint) {
        if (name == null) {
            throw new NullPointerException("arg#1 is null");
        }
        if (paint == null) {
            throw new NullPointerException("arg#3 is null");
        }
        Icon icon = Controls.icon(name);
        icon.setIconSize(size);
        icon.setIconColor(paint);
        return icon.node();
    }

    public static Node graphic(String name, int size, Color color) {
        if (name == null) {
            throw new NullPointerException("arg#1 is null");
        }
        if (color == null) {
            throw new NullPointerException("arg#3 is null");
        }
        return Controls.graphic(name, size, (Paint)FxUtil.convert((Color)color));
    }

    public static Node tooltipIcon(String name, int size, Paint paint, String tooltipText) {
        if (name == null) {
            throw new NullPointerException("arg#1 is null");
        }
        if (paint == null) {
            throw new NullPointerException("arg#3 is null");
        }
        if (tooltipText == null) {
            throw new NullPointerException("arg#4 is null");
        }
        IconView iv = new IconView(name, size, paint);
        if (!tooltipText.isBlank()) {
            iv.setTooltip(new Tooltip(tooltipText));
        }
        return iv;
    }

    public static Node tooltipIcon(String name, int size, Color color, String tooltipText) {
        if (name == null) {
            throw new NullPointerException("arg#1 is null");
        }
        if (color == null) {
            throw new NullPointerException("arg#3 is null");
        }
        if (tooltipText == null) {
            throw new NullPointerException("arg#4 is null");
        }
        return Controls.tooltipIcon(name, size, (Paint)FxUtil.convert((Color)color), tooltipText);
    }

    public static TextFieldBuilder textField() {
        return new TextFieldBuilder();
    }

    public static void makeResizable(Region region, Position ... borders) {
        if (region == null) {
            throw new NullPointerException("arg#1 is null");
        }
        if (borders == null) {
            throw new NullPointerException("arg#2 is null");
        }
        DragResizer.makeResizable(region, 6, borders);
    }

    public static void makeResizable(Region region, int resizeMargin, Position ... borders) {
        if (region == null) {
            throw new NullPointerException("arg#1 is null");
        }
        if (borders == null) {
            throw new NullPointerException("arg#3 is null");
        }
        DragResizer.makeResizable(region, resizeMargin, borders);
    }

    public static Menu menu(@Nullable String text, MenuItem ... items) {
        if (items == null) {
            throw new NullPointerException("arg#2 is null");
        }
        return new Menu(text, null, items);
    }

    public static Menu menu(@Nullable String text, @Nullable Node graphic, MenuItem ... items) {
        if (items == null) {
            throw new NullPointerException("arg#3 is null");
        }
        return new Menu(text, graphic, items);
    }

    public static MenuItem menuItem(@Nullable String text, @Nullable Node graphic, Runnable action) {
        if (action == null) {
            throw new NullPointerException("arg#3 is null");
        }
        return Controls.menuItem(text, graphic, action, true);
    }

    public static MenuItem menuItem(@Nullable String text, @Nullable Node graphic, Runnable action, boolean enabled) {
        if (action == null) {
            throw new NullPointerException("arg#3 is null");
        }
        MenuItem mi = new MenuItem(text, graphic);
        mi.setDisable(!enabled);
        mi.setOnAction(evt -> action.run());
        return mi;
    }

    public static MenuItem menuItem(@Nullable String text, Runnable action) {
        if (action == null) {
            throw new NullPointerException("arg#2 is null");
        }
        return Controls.menuItem(text, action, true);
    }

    public static MenuItem menuItem(@Nullable String text, Runnable action, boolean enabled) {
        if (action == null) {
            throw new NullPointerException("arg#2 is null");
        }
        MenuItem mi = new MenuItem(text);
        mi.setDisable(!enabled);
        mi.setOnAction(evt -> action.run());
        return mi;
    }

    static void setInitialDirectory(Consumer<File> setInitialDirectory, @Nullable Path dir) {
        assert (setInitialDirectory != null) : "arg#1 is null";
        if (dir != null) {
            try {
                File initialFile = dir.toFile();
                if (initialFile.isDirectory()) {
                    setInitialDirectory.accept(initialFile);
                }
            }
            catch (UnsupportedOperationException e) {
                LOG.warn("could not set initial directory", (Throwable)e);
            }
        }
    }
}

