/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.fx.controls;

import com.dua3.utility.fx.controls.DecorationPane;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.geometry.HPos;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;

public final class Decoration {
    private static final String DECORATION_LIST = Decoration.class.getName() + ".decoration_list";
    private static final String OWNER = Decoration.class.getName() + ":owner";
    private static final String POSITION = Decoration.class.getName() + ":position";
    private static final String PREFIX = Decoration.class.getName() + ":";

    private Decoration() {
    }

    public static ObservableList<Decoration> getDecorations(Node node) {
        if (node == null) {
            throw new NullPointerException("arg#1 is null");
        }
        ObservableList decorations = (ObservableList)node.getProperties().get((Object)DECORATION_LIST);
        if (decorations == null) {
            decorations = FXCollections.observableArrayList();
            node.getProperties().put((Object)DECORATION_LIST, (Object)decorations);
        }
        return decorations;
    }

    public static void addDecoration(Node node, Pos position, Node decoration, String id) {
        if (node == null) {
            throw new NullPointerException("arg#1 is null");
        }
        if (position == null) {
            throw new NullPointerException("arg#2 is null");
        }
        if (decoration == null) {
            throw new NullPointerException("arg#3 is null");
        }
        if (id == null) {
            throw new NullPointerException("arg#4 is null");
        }
        DecorationPane decorationPane = DecorationPane.getDecorationPane(node);
        decoration.getProperties().put((Object)OWNER, (Object)node);
        decoration.getProperties().put((Object)POSITION, (Object)position);
        Decoration.updateDecorationPosition(decoration);
        Object oldDecoration = node.getProperties().put((Object)Decoration.getDecorationId(id), (Object)decoration);
        if (oldDecoration != null) {
            decorationPane.removeDecoration(oldDecoration);
        }
        decorationPane.getChildren().add((Object)decoration);
    }

    static void updateDecorationPosition(Node decoration) {
        assert (decoration != null) : "arg#1 is null";
        Node node = (Node)decoration.getProperties().get((Object)OWNER);
        if (node == null) {
            return;
        }
        Pos position = (Pos)decoration.getProperties().get((Object)POSITION);
        Bounds bounds = node.getLayoutBounds();
        Bounds decorationBounds = decoration.getLayoutBounds();
        double x = switch (position.getHpos()) {
            default -> throw new IncompatibleClassChangeError();
            case HPos.LEFT -> bounds.getMinX() - decorationBounds.getWidth() / 2.0;
            case HPos.CENTER -> bounds.getCenterX() - decorationBounds.getWidth() / 2.0;
            case HPos.RIGHT -> bounds.getMaxX() - decorationBounds.getWidth() / 2.0;
        };
        double y = switch (position.getVpos()) {
            default -> throw new IncompatibleClassChangeError();
            case VPos.TOP -> bounds.getMinY() - decorationBounds.getHeight() / 2.0;
            case VPos.CENTER -> bounds.getCenterY() - decorationBounds.getHeight() / 2.0;
            case VPos.BOTTOM -> bounds.getMaxY() - decorationBounds.getHeight() / 2.0;
            case VPos.BASELINE -> bounds.getMaxY() - decorationBounds.getHeight() / 2.0;
        };
        decoration.setLayoutX(x + node.getLayoutX());
        decoration.setLayoutY(y + node.getLayoutY());
    }

    private static String getDecorationId(String id) {
        assert (id != null) : "arg#1 is null";
        return PREFIX + id;
    }

    public static void removeDecoration(Node node, String id) {
        if (node == null) {
            throw new NullPointerException("arg#1 is null");
        }
        if (id == null) {
            throw new NullPointerException("arg#2 is null");
        }
        Object oldDecoration = node.getProperties().remove((Object)Decoration.getDecorationId(id));
        if (oldDecoration != null) {
            DecorationPane decorationPane = DecorationPane.getDecorationPane(node);
            decorationPane.removeDecoration(oldDecoration);
        }
    }
}

