/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.fx.controls;

import com.dua3.utility.fx.FxUtil;
import com.dua3.utility.fx.controls.Position;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javafx.event.EventType;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;

final class DragResizer {
    private final Region region;
    private final Set<Position> borders;
    private final int resizeMargin;
    private boolean draggingTop;
    private boolean draggingRight;
    private boolean draggingBottom;
    private boolean draggingLeft;

    private DragResizer(Region region, int resizeMargin, Position ... borders) {
        if (!$assertionsDisabled) {
            if (region == null) {
                throw new AssertionError((Object)"arg#1 is null");
            }
            if (borders == null) {
                throw new AssertionError((Object)"arg#3 is null");
            }
        }
        this.draggingTop = false;
        this.draggingRight = false;
        this.draggingBottom = false;
        this.draggingLeft = false;
        this.region = region;
        this.resizeMargin = resizeMargin;
        this.borders = EnumSet.noneOf(Position.class);
        this.borders.addAll(List.of(borders));
    }

    public static void makeResizable(Region region, int resizeMargin, Position ... borders) {
        if (!$assertionsDisabled) {
            if (region == null) {
                throw new AssertionError((Object)"arg#1 is null");
            }
            if (borders == null) {
                throw new AssertionError((Object)"arg#3 is null");
            }
        }
        DragResizer resizer = new DragResizer(region, resizeMargin, borders);
        FxUtil.addMouseEventHandler((Node)region, (EventType)MouseEvent.MOUSE_PRESSED, resizer::mousePressed);
        FxUtil.addMouseEventHandler((Node)region, (EventType)MouseEvent.MOUSE_DRAGGED, resizer::mouseDragged);
        FxUtil.addMouseEventHandler((Node)region, (EventType)MouseEvent.MOUSE_MOVED, resizer::mouseOver);
        FxUtil.addMouseEventHandler((Node)region, (EventType)MouseEvent.MOUSE_RELEASED, resizer::mouseReleased);
    }

    private boolean isDragging() {
        return this.draggingTop || this.draggingRight || this.draggingBottom || this.draggingLeft;
    }

    private void mousePressed(MouseEvent event) {
        assert (event != null) : "arg#1 is null";
        this.draggingTop = this.isInDraggableZoneTop(event);
        this.draggingRight = this.isInDraggableZoneRight(event);
        this.draggingBottom = this.isInDraggableZoneBottom(event);
        this.draggingLeft = this.isInDraggableZoneLeft(event);
        if (this.isDragging()) {
            event.consume();
        }
    }

    private void mouseDragged(MouseEvent event) {
        assert (event != null) : "arg#1 is null";
        if (this.isDragging()) {
            event.consume();
        }
        if (this.draggingBottom) {
            this.resizeBottom(event);
        }
        if (this.draggingRight) {
            this.resizeRight(event);
        }
        if (this.draggingTop) {
            this.resizeTop(event);
        }
        if (this.draggingLeft) {
            this.resizeLeft(event);
        }
    }

    private void mouseOver(MouseEvent event) {
        assert (event != null) : "arg#1 is null";
        if (this.isInDraggableZoneTop(event) || this.draggingTop) {
            if (this.isInDraggableZoneRight(event) || this.draggingRight) {
                this.region.setCursor(Cursor.NE_RESIZE);
            } else if (this.isInDraggableZoneLeft(event) || this.draggingLeft) {
                this.region.setCursor(Cursor.NW_RESIZE);
            } else {
                this.region.setCursor(Cursor.N_RESIZE);
            }
        } else if (this.isInDraggableZoneBottom(event) || this.draggingBottom) {
            if (this.isInDraggableZoneRight(event) || this.draggingRight) {
                this.region.setCursor(Cursor.SE_RESIZE);
            } else if (this.isInDraggableZoneLeft(event) || this.draggingLeft) {
                this.region.setCursor(Cursor.SW_RESIZE);
            } else {
                this.region.setCursor(Cursor.S_RESIZE);
            }
        } else if (this.isInDraggableZoneRight(event) || this.draggingRight) {
            this.region.setCursor(Cursor.E_RESIZE);
        } else if (this.isInDraggableZoneLeft(event) || this.draggingLeft) {
            this.region.setCursor(Cursor.W_RESIZE);
        } else {
            this.region.setCursor(Cursor.DEFAULT);
        }
    }

    private void mouseReleased(MouseEvent event) {
        assert (event != null) : "arg#1 is null";
        this.draggingLeft = false;
        this.draggingBottom = false;
        this.draggingRight = false;
        this.draggingTop = false;
        this.region.setCursor(Cursor.DEFAULT);
    }

    private boolean isInDraggableZoneTop(MouseEvent event) {
        assert (event != null) : "arg#1 is null";
        return this.borders.contains((Object)Position.TOP) && event.getY() < (double)this.resizeMargin;
    }

    private boolean isInDraggableZoneRight(MouseEvent event) {
        assert (event != null) : "arg#1 is null";
        return this.borders.contains((Object)Position.RIGHT) && event.getX() > this.region.getWidth() - (double)this.resizeMargin;
    }

    private boolean isInDraggableZoneBottom(MouseEvent event) {
        assert (event != null) : "arg#1 is null";
        return this.borders.contains((Object)Position.BOTTOM) && event.getY() > this.region.getHeight() - (double)this.resizeMargin;
    }

    private boolean isInDraggableZoneLeft(MouseEvent event) {
        assert (event != null) : "arg#1 is null";
        return this.borders.contains((Object)Position.LEFT) && event.getX() < (double)this.resizeMargin;
    }

    private void resizeBottom(MouseEvent event) {
        assert (event != null) : "arg#1 is null";
        this.region.setMinHeight(event.getY());
    }

    private void resizeRight(MouseEvent event) {
        assert (event != null) : "arg#1 is null";
        this.region.setMinWidth(event.getX());
    }

    private void resizeTop(MouseEvent event) {
        assert (event != null) : "arg#1 is null";
        double prevMin = this.region.getMinHeight();
        this.region.setMinHeight(this.region.getMinHeight() - event.getY());
        if (this.region.getMinHeight() < this.region.getPrefHeight()) {
            this.region.setMinHeight(this.region.getPrefHeight());
            this.region.setTranslateY(this.region.getTranslateY() - (this.region.getPrefHeight() - prevMin));
            return;
        }
        if (this.region.getMinHeight() > this.region.getPrefHeight() || event.getY() < 0.0) {
            this.region.setTranslateY(this.region.getTranslateY() + event.getY());
        }
    }

    private void resizeLeft(MouseEvent event) {
        assert (event != null) : "arg#1 is null";
        double prevMin = this.region.getMinWidth();
        this.region.setMinWidth(this.region.getMinWidth() - event.getX());
        if (this.region.getMinWidth() < this.region.getPrefWidth()) {
            this.region.setMinWidth(this.region.getPrefWidth());
            this.region.setTranslateX(this.region.getTranslateX() - (this.region.getPrefWidth() - prevMin));
            return;
        }
        if (this.region.getMinWidth() > this.region.getPrefWidth() || event.getX() < 0.0) {
            this.region.setTranslateX(this.region.getTranslateX() + event.getX());
        }
    }
}

