/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.fx.controls;

import com.dua3.utility.fx.controls.Controls;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.jspecify.annotations.Nullable;

public class FileChooserBuilder {
    private static final Logger LOG = LogManager.getLogger(FileChooserBuilder.class);
    private static final Path USER_HOME = Paths.get(System.getProperty("user.home"), new String[0]);
    private Path initialDir = USER_HOME;
    private String initialFileName = "";
    private List<FileChooser.ExtensionFilter> filters = new ArrayList<FileChooser.ExtensionFilter>();
    private FileChooser.ExtensionFilter selectedFilter = null;

    FileChooserBuilder() {
    }

    public Optional<Path> showOpenDialog(@Nullable Window parent) {
        FileChooser chooser = this.build();
        return Optional.ofNullable(chooser.showOpenDialog(parent)).map(File::toPath);
    }

    private FileChooser build() {
        FileChooser chooser = new FileChooser();
        chooser.getExtensionFilters().setAll(this.filters);
        if (this.selectedFilter != null) {
            chooser.setSelectedExtensionFilter(this.selectedFilter);
        }
        Controls.setInitialDirectory(arg_0 -> ((FileChooser)chooser).setInitialDirectory(arg_0), this.initialDir);
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = () -> ((FileChooser)chooser).getInitialDirectory();
        LOG.debug("initial directory: {}", supplierArray);
        chooser.setInitialFileName(this.initialFileName);
        return chooser;
    }

    public List<Path> showOpenMultipleDialog(@Nullable Window parent) {
        FileChooser chooser = this.build();
        List files = chooser.showOpenMultipleDialog(parent);
        return files == null ? Collections.emptyList() : files.stream().map(File::toPath).toList();
    }

    public Optional<Path> showSaveDialog(@Nullable Window parent) {
        FileChooser chooser = this.build();
        return Optional.ofNullable(chooser.showSaveDialog(parent)).map(File::toPath);
    }

    public FileChooserBuilder initialFile(Path file) {
        if (file == null) {
            throw new NullPointerException("arg#1 is null");
        }
        Path fileName = file.getFileName();
        this.initialFileName(fileName == null ? null : fileName.toString());
        this.initialDir(file.getParent());
        return this;
    }

    public FileChooserBuilder initialFileName(@Nullable String initialFileName) {
        this.initialFileName = initialFileName != null ? initialFileName : "";
        return this;
    }

    public FileChooserBuilder initialDir(@Nullable Path initialDir) {
        this.initialDir = initialDir != null ? initialDir : USER_HOME;
        return this;
    }

    public FileChooserBuilder addFilter(String name, String ... pattern) {
        if (name == null) {
            throw new NullPointerException("arg#1 is null");
        }
        if (pattern == null) {
            throw new NullPointerException("arg#2 is null");
        }
        FileChooser.ExtensionFilter f = new FileChooser.ExtensionFilter(name, pattern);
        this.filters.add(f);
        return this;
    }

    public FileChooserBuilder filter(Collection<FileChooser.ExtensionFilter> filters) {
        if (filters == null) {
            throw new NullPointerException("arg#1 is null");
        }
        this.filters = new ArrayList<FileChooser.ExtensionFilter>(filters);
        return this;
    }

    public FileChooserBuilder filter(FileChooser.ExtensionFilter ... filters) {
        if (filters == null) {
            throw new NullPointerException("arg#1 is null");
        }
        this.filters = new ArrayList<FileChooser.ExtensionFilter>(List.of(filters));
        return this;
    }

    public FileChooserBuilder selectedFilter(// Could not load outer class - annotation placement on inner may be incorrect
    @Nullable FileChooser.ExtensionFilter f) {
        this.selectedFilter = f;
        if (f != null && !this.filters.contains(f)) {
            this.filters.add(f);
        }
        return this;
    }
}

