/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.fx.controls;

import com.dua3.utility.fx.FxUtil;
import com.dua3.utility.fx.controls.CustomControl;
import com.dua3.utility.fx.controls.Dialogs;
import com.dua3.utility.fx.controls.FileDialogMode;
import com.dua3.utility.fx.controls.InputControl;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.stage.FileChooser;
import javafx.util.StringConverter;
import org.jspecify.annotations.Nullable;

public class FileInput
extends CustomControl<HBox>
implements InputControl<Path> {
    private static final StringConverter<Path> PATH_CONVERTER = new PathConverter();
    private final ObjectProperty<Path> value;
    private final FileDialogMode mode;
    private final FileChooser.ExtensionFilter[] filters;
    private final Supplier<Path> dflt;
    private final StringProperty error;
    private final BooleanProperty valid;

    public FileInput(FileDialogMode mode, boolean existingOnly, Supplier<Path> dflt, Collection<FileChooser.ExtensionFilter> filters, Function<Path, Optional<String>> validate) {
        if (mode == null) {
            throw new NullPointerException("arg#1 is null");
        }
        if (dflt == null) {
            throw new NullPointerException("arg#3 is null");
        }
        if (filters == null) {
            throw new NullPointerException("arg#4 is null");
        }
        if (validate == null) {
            throw new NullPointerException("arg#5 is null");
        }
        super(new HBox());
        this.value = new SimpleObjectProperty();
        this.error = new SimpleStringProperty("");
        this.valid = new SimpleBooleanProperty(true);
        this.getStyleClass().setAll((Object[])new String[]{"file-input"});
        this.mode = mode;
        this.filters = (FileChooser.ExtensionFilter[])filters.toArray(FileChooser.ExtensionFilter[]::new);
        this.dflt = dflt;
        TextField tfFilename = new TextField();
        Button button = new Button("\u2026");
        HBox.setHgrow((Node)tfFilename, (Priority)Priority.ALWAYS);
        button.setOnAction(evt -> {
            Path initialDir = (Path)this.value.get();
            if (initialDir != null && !Files.isDirectory(initialDir, new LinkOption[0])) {
                initialDir = initialDir.getParent();
            }
            if (initialDir == null) {
                initialDir = Paths.get(".", new String[0]);
            }
            switch (this.mode) {
                case OPEN: {
                    Dialogs.chooseFile().initialDir(initialDir).filter(this.filters).showOpenDialog(null).ifPresent(arg_0 -> this.value.setValue(arg_0));
                    break;
                }
                case SAVE: {
                    Dialogs.chooseFile().initialDir(initialDir).filter(this.filters).showSaveDialog(null).ifPresent(arg_0 -> this.value.setValue(arg_0));
                    break;
                }
                case DIRECTORY: {
                    Dialogs.chooseDirectory().initialDir(initialDir).showDialog(null).ifPresent(arg_0 -> this.value.setValue(arg_0));
                }
            }
        });
        ((HBox)this.container).getChildren().setAll((Object[])new Node[]{tfFilename, button});
        tfFilename.textProperty().bindBidirectional(this.valueProperty(), PATH_CONVERTER);
        StringBinding errorText = Bindings.createStringBinding(() -> {
            Path file = (Path)this.value.get();
            if (file == null) {
                return "No file selected.";
            }
            if (mode == FileDialogMode.OPEN && !Files.exists(file, new LinkOption[0])) {
                return "File does not exist: " + file;
            }
            return "";
        }, (Observable[])new Observable[]{this.value});
        this.error.bind((ObservableValue)errorText);
        this.valid.bind((ObservableValue)Bindings.createBooleanBinding(() -> ((Optional)validate.apply(this.getPath())).isEmpty(), (Observable[])new Observable[]{this.value}));
        Function<List, List> acceptPath = list -> list.isEmpty() ? Collections.emptyList() : List.of(TransferMode.MOVE);
        tfFilename.setOnDragOver(FxUtil.dragEventHandler(acceptPath));
        tfFilename.setOnDragDropped(FxUtil.dropEventHandler(list -> this.valueProperty().setValue((Object)((Path)list.get(0)))));
        Path p = dflt.get();
        if (p != null) {
            this.set(p);
        }
    }

    public static Function<Path, Optional<String>> defaultValidate(FileDialogMode mode, boolean existingOnly) {
        if (mode == null) {
            throw new NullPointerException("arg#1 is null");
        }
        return p -> {
            if (p == null) {
                return Optional.of("Nothing selected");
            }
            boolean exists = Files.exists(p, new LinkOption[0]);
            boolean isDirectory = Files.isDirectory(p, new LinkOption[0]);
            switch (mode) {
                case DIRECTORY: {
                    if (exists && !isDirectory) {
                        return Optional.of("Not a directory: " + p);
                    }
                    if (existingOnly && !exists) {
                        return Optional.of("Does not exist: " + p);
                    }
                    return Optional.empty();
                }
                case OPEN: 
                case SAVE: {
                    if (isDirectory) {
                        return Optional.of("Is a directory: " + p);
                    }
                    if (existingOnly && !exists) {
                        return Optional.of("Does not exist: " + p);
                    }
                    return Optional.empty();
                }
            }
            throw new IllegalArgumentException("Unknown FileDialogMode: " + mode);
        };
    }

    private Path getPath() {
        return (Path)this.value.get();
    }

    @Override
    public Node node() {
        return this;
    }

    @Override
    public void reset() {
        this.value.setValue((Object)this.dflt.get());
    }

    @Override
    public Property<Path> valueProperty() {
        return this.value;
    }

    @Override
    public ReadOnlyBooleanProperty validProperty() {
        return this.valid;
    }

    @Override
    public ReadOnlyStringProperty errorProperty() {
        return this.error;
    }

    static class PathConverter
    extends StringConverter<Path> {
        PathConverter() {
        }

        public String toString(@Nullable Path path) {
            return path == null ? "" : path.toString();
        }

        public Path fromString(@Nullable String s) {
            return s == null ? Paths.get("", new String[0]) : Paths.get(s, new String[0]);
        }
    }
}

