/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.fx.controls;

import com.dua3.utility.fx.controls.FileDialogMode;
import com.dua3.utility.fx.controls.FileInput;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.beans.value.ObservableValue;
import javafx.stage.FileChooser;
import org.jspecify.annotations.Nullable;

public final class FileInputBuilder {
    private final FileDialogMode mode;
    private final List<FileChooser.ExtensionFilter> extensionFilters;
    private Supplier<Path> initialPath;
    private boolean existingOnly;
    private Function<Path, Optional<String>> validate;
    private @Nullable ObservableValue<Boolean> disabled;

    FileInputBuilder(FileDialogMode mode) {
        assert (mode != null) : "arg#1 is null";
        this.extensionFilters = new ArrayList<FileChooser.ExtensionFilter>();
        this.initialPath = () -> null;
        this.existingOnly = true;
        this.mode = mode;
        this.validate = this::defaultValidate;
    }

    public FileInputBuilder disabled(ObservableValue<Boolean> disabled) {
        if (disabled == null) {
            throw new NullPointerException("arg#1 is null");
        }
        this.disabled = disabled;
        return this;
    }

    public FileInputBuilder validate(Function<Path, Optional<String>> validate) {
        if (validate == null) {
            throw new NullPointerException("arg#1 is null");
        }
        this.validate = validate;
        return this;
    }

    public FileInputBuilder initialPath(@Nullable Path initialPath) {
        this.initialPath = () -> initialPath;
        return this;
    }

    public FileInputBuilder initialPath(Supplier<Path> initialPath) {
        if (initialPath == null) {
            throw new NullPointerException("arg#1 is null");
        }
        this.initialPath = initialPath;
        return this;
    }

    public FileInputBuilder filter(FileChooser.ExtensionFilter ... filter) {
        if (filter == null) {
            throw new NullPointerException("arg#1 is null");
        }
        this.extensionFilters.addAll(Arrays.asList(filter));
        return this;
    }

    public FileInputBuilder existingOnly(boolean flag) {
        this.existingOnly = flag;
        return this;
    }

    public FileInput build() {
        FileInput control = new FileInput(this.mode, this.existingOnly, this.initialPath, this.extensionFilters, this.validate);
        if (this.disabled != null) {
            control.disableProperty().bind(this.disabled);
        }
        return control;
    }

    private String itemText(boolean captitalize) {
        return switch (this.mode) {
            default -> throw new IncompatibleClassChangeError();
            case FileDialogMode.DIRECTORY -> {
                if (captitalize) {
                    yield "Directory";
                }
                yield "directory";
            }
            case FileDialogMode.OPEN, FileDialogMode.SAVE -> captitalize ? "File" : "file";
        };
    }

    private Optional<String> defaultValidate(@Nullable Path p) {
        if (p == null) {
            return Optional.of("No " + this.itemText(false) + " selected");
        }
        if (this.existingOnly && !Files.exists(p, new LinkOption[0])) {
            return Optional.of(this.itemText(true) + " does not exist");
        }
        if (!this.existingOnly) {
            return Optional.empty();
        }
        boolean isDirectory = Files.isDirectory(p, new LinkOption[0]);
        return switch (this.mode) {
            default -> throw new IncompatibleClassChangeError();
            case FileDialogMode.DIRECTORY -> {
                if (isDirectory) {
                    yield Optional.empty();
                }
                yield Optional.of("Selection is not a " + this.itemText(false));
            }
            case FileDialogMode.OPEN -> {
                if (isDirectory) {
                    yield Optional.of("Selection is a directory");
                }
                yield Optional.empty();
            }
            case FileDialogMode.SAVE -> isDirectory ? Optional.of("Selection is a directory") : (!Files.isWritable(p) ? Optional.of(this.itemText(true) + "is not writeable") : Optional.empty());
        };
    }
}

