/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.fx.controls;

import com.dua3.utility.fx.controls.AbstractDialogBuilder;
import com.dua3.utility.fx.controls.ComboBoxEx;
import com.dua3.utility.fx.controls.FileDialogMode;
import com.dua3.utility.fx.controls.InputBuilder;
import com.dua3.utility.fx.controls.InputControl;
import com.dua3.utility.fx.controls.InputDialog;
import com.dua3.utility.fx.controls.InputPane;
import com.dua3.utility.fx.controls.InputPaneBuilder;
import com.dua3.utility.options.Arguments;
import com.dua3.utility.options.Option;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.jspecify.annotations.Nullable;

public class InputDialogBuilder
extends AbstractDialogBuilder<InputDialog, InputDialogBuilder, Map<String, Object>>
implements InputBuilder<InputDialogBuilder> {
    private final InputPaneBuilder pb = new InputPaneBuilder();

    InputDialogBuilder(@Nullable Window parentWindow) {
        super(parentWindow);
        this.setDialogSupplier(this::createDialog);
    }

    private InputDialog createDialog() {
        InputDialog dlg = new InputDialog();
        InputPane dialogPane = (InputPane)this.pb.build();
        dialogPane.init();
        dialogPane.getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        Button okButton = (Button)dialogPane.lookupButton(ButtonType.OK);
        okButton.disableProperty().bind((ObservableValue)Bindings.not((ObservableBooleanValue)dialogPane.validProperty()));
        dlg.setDialogPane(dialogPane);
        return dlg;
    }

    @Override
    public <T> InputDialogBuilder add(String id, String label, Class<T> type, Supplier<T> dflt, InputControl<T> control) {
        if (id == null) {
            throw new NullPointerException("arg#1 is null");
        }
        if (label == null) {
            throw new NullPointerException("arg#2 is null");
        }
        if (type == null) {
            throw new NullPointerException("arg#3 is null");
        }
        if (dflt == null) {
            throw new NullPointerException("arg#4 is null");
        }
        if (control == null) {
            throw new NullPointerException("arg#5 is null");
        }
        this.pb.add(id, label, (Class)type, (Supplier)dflt, (InputControl)control);
        return this;
    }

    @Override
    public <T> InputDialogBuilder add(String id, Class<T> type, Supplier<T> dflt, InputControl<T> control) {
        if (id == null) {
            throw new NullPointerException("arg#1 is null");
        }
        if (type == null) {
            throw new NullPointerException("arg#2 is null");
        }
        if (dflt == null) {
            throw new NullPointerException("arg#3 is null");
        }
        if (control == null) {
            throw new NullPointerException("arg#4 is null");
        }
        this.pb.add(id, (Class)type, (Supplier)dflt, (InputControl)control);
        return this;
    }

    @Override
    public InputDialogBuilder addNode(String id, String label, Node node) {
        if (id == null) {
            throw new NullPointerException("arg#1 is null");
        }
        if (label == null) {
            throw new NullPointerException("arg#2 is null");
        }
        if (node == null) {
            throw new NullPointerException("arg#3 is null");
        }
        this.pb.addNode(id, label, node);
        return this;
    }

    @Override
    public InputDialogBuilder addNode(String id, Node node) {
        if (id == null) {
            throw new NullPointerException("arg#1 is null");
        }
        if (node == null) {
            throw new NullPointerException("arg#2 is null");
        }
        this.pb.addNode(id, node);
        return this;
    }

    @Override
    public InputDialogBuilder columns(int columns) {
        this.pb.columns(columns);
        return this;
    }

    @Override
    public InputDialogBuilder string(String id, String label, Supplier<String> dflt, Function<String, Optional<String>> validate) {
        if (id == null) {
            throw new NullPointerException("arg#1 is null");
        }
        if (label == null) {
            throw new NullPointerException("arg#2 is null");
        }
        if (dflt == null) {
            throw new NullPointerException("arg#3 is null");
        }
        if (validate == null) {
            throw new NullPointerException("arg#4 is null");
        }
        this.pb.string(id, label, (Supplier)dflt, (Function)validate);
        return this;
    }

    @Override
    public InputDialogBuilder integer(String id, String label, Supplier<Integer> dflt, Function<Integer, Optional<String>> validate) {
        if (id == null) {
            throw new NullPointerException("arg#1 is null");
        }
        if (label == null) {
            throw new NullPointerException("arg#2 is null");
        }
        if (dflt == null) {
            throw new NullPointerException("arg#3 is null");
        }
        if (validate == null) {
            throw new NullPointerException("arg#4 is null");
        }
        this.pb.integer(id, label, (Supplier)dflt, (Function)validate);
        return this;
    }

    @Override
    public InputDialogBuilder decimal(String id, String label, Supplier<Double> dflt, Function<Double, Optional<String>> validate) {
        if (id == null) {
            throw new NullPointerException("arg#1 is null");
        }
        if (label == null) {
            throw new NullPointerException("arg#2 is null");
        }
        if (dflt == null) {
            throw new NullPointerException("arg#3 is null");
        }
        if (validate == null) {
            throw new NullPointerException("arg#4 is null");
        }
        this.pb.decimal(id, label, (Supplier)dflt, (Function)validate);
        return this;
    }

    @Override
    public InputDialogBuilder checkBox(String id, String label, Supplier<Boolean> dflt, String text, Function<Boolean, Optional<String>> validate) {
        if (id == null) {
            throw new NullPointerException("arg#1 is null");
        }
        if (label == null) {
            throw new NullPointerException("arg#2 is null");
        }
        if (dflt == null) {
            throw new NullPointerException("arg#3 is null");
        }
        if (text == null) {
            throw new NullPointerException("arg#4 is null");
        }
        if (validate == null) {
            throw new NullPointerException("arg#5 is null");
        }
        this.pb.checkBox(id, label, (Supplier)dflt, text, (Function)validate);
        return this;
    }

    @Override
    public <T> InputDialogBuilder comboBox(String id, String label, Supplier<T> dflt, Class<T> cls, Collection<T> items, Function<T, Optional<String>> validate) {
        if (id == null) {
            throw new NullPointerException("arg#1 is null");
        }
        if (label == null) {
            throw new NullPointerException("arg#2 is null");
        }
        if (dflt == null) {
            throw new NullPointerException("arg#3 is null");
        }
        if (cls == null) {
            throw new NullPointerException("arg#4 is null");
        }
        if (items == null) {
            throw new NullPointerException("arg#5 is null");
        }
        if (validate == null) {
            throw new NullPointerException("arg#6 is null");
        }
        this.pb.comboBox(id, label, (Supplier)dflt, (Class)cls, (Collection)items, (Function)validate);
        return this;
    }

    @Override
    public <T> InputDialogBuilder comboBoxEx(String id, String label, @Nullable UnaryOperator<T> edit, @Nullable Supplier<T> add, @Nullable BiPredicate<ComboBoxEx<T>, T> remove, Function<T, String> format, Supplier<T> dflt, Class<T> cls, Collection<T> items, Function<T, Optional<String>> validate) {
        if (id == null) {
            throw new NullPointerException("arg#1 is null");
        }
        if (label == null) {
            throw new NullPointerException("arg#2 is null");
        }
        if (format == null) {
            throw new NullPointerException("arg#6 is null");
        }
        if (dflt == null) {
            throw new NullPointerException("arg#7 is null");
        }
        if (cls == null) {
            throw new NullPointerException("arg#8 is null");
        }
        if (items == null) {
            throw new NullPointerException("arg#9 is null");
        }
        if (validate == null) {
            throw new NullPointerException("arg#10 is null");
        }
        this.pb.comboBoxEx(id, label, (UnaryOperator)edit, (Supplier)add, (BiPredicate)remove, (Function)format, (Supplier)dflt, (Class)cls, (Collection)items, (Function)validate);
        return this;
    }

    @Override
    public <T> InputDialogBuilder radioList(String id, String label, Supplier<T> dflt, Class<T> cls, Collection<T> items, Function<T, Optional<String>> validate) {
        if (id == null) {
            throw new NullPointerException("arg#1 is null");
        }
        if (label == null) {
            throw new NullPointerException("arg#2 is null");
        }
        if (dflt == null) {
            throw new NullPointerException("arg#3 is null");
        }
        if (cls == null) {
            throw new NullPointerException("arg#4 is null");
        }
        if (items == null) {
            throw new NullPointerException("arg#5 is null");
        }
        if (validate == null) {
            throw new NullPointerException("arg#6 is null");
        }
        this.pb.radioList(id, label, (Supplier)dflt, (Class)cls, (Collection)items, (Function)validate);
        return this;
    }

    @Override
    public InputDialogBuilder options(String id, String label, Supplier<Arguments> dflt, Supplier<Collection<Option<?>>> options) {
        if (id == null) {
            throw new NullPointerException("arg#1 is null");
        }
        if (label == null) {
            throw new NullPointerException("arg#2 is null");
        }
        if (dflt == null) {
            throw new NullPointerException("arg#3 is null");
        }
        if (options == null) {
            throw new NullPointerException("arg#4 is null");
        }
        this.pb.options(id, label, (Supplier)dflt, (Supplier)options);
        return this;
    }

    @Override
    public InputDialogBuilder options(String id, Supplier<Arguments> dflt, Supplier<Collection<Option<?>>> options) {
        if (id == null) {
            throw new NullPointerException("arg#1 is null");
        }
        if (dflt == null) {
            throw new NullPointerException("arg#2 is null");
        }
        if (options == null) {
            throw new NullPointerException("arg#3 is null");
        }
        this.pb.options(id, (Supplier)dflt, (Supplier)options);
        return this;
    }

    @Override
    public InputDialogBuilder chooseFile(String id, String label, Supplier<Path> dflt, FileDialogMode mode, boolean existingOnly, Collection<FileChooser.ExtensionFilter> filter, Function<Path, Optional<String>> validate) {
        if (id == null) {
            throw new NullPointerException("arg#1 is null");
        }
        if (label == null) {
            throw new NullPointerException("arg#2 is null");
        }
        if (dflt == null) {
            throw new NullPointerException("arg#3 is null");
        }
        if (mode == null) {
            throw new NullPointerException("arg#4 is null");
        }
        if (filter == null) {
            throw new NullPointerException("arg#6 is null");
        }
        if (validate == null) {
            throw new NullPointerException("arg#7 is null");
        }
        this.pb.chooseFile(id, label, (Supplier)dflt, mode, existingOnly, (Collection)filter, (Function)validate);
        return this;
    }
}

