/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.fx.controls;

import com.dua3.utility.data.Pair;
import com.dua3.utility.lang.LangUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.DialogPane;

public abstract class InputDialogPane<R>
extends DialogPane
implements Supplier<R> {
    protected final BooleanProperty valid = new SimpleBooleanProperty(false);
    protected final List<Pair<ButtonType, Consumer<InputDialogPane<R>>>> buttons = new ArrayList<Pair<ButtonType, Consumer<InputDialogPane<R>>>>();

    public abstract void init();

    public ReadOnlyBooleanProperty validProperty() {
        return this.valid;
    }

    public void initButtons() {
        ObservableList bt = this.getButtonTypes();
        bt.clear();
        for (Pair<ButtonType, Consumer<InputDialogPane<R>>> b : this.buttons) {
            bt.add((Object)((ButtonType)b.first()));
            Button btn = (Button)this.lookupButton((ButtonType)b.first());
            btn.setOnAction(evt -> ((Consumer)b.second()).accept(this));
        }
    }

    protected Node createButton(ButtonType buttonType) {
        assert (buttonType != null) : "arg#1 is null";
        if (LangUtil.isOneOf((Object)buttonType, (Object[])new ButtonType[]{ButtonType.OK, ButtonType.FINISH, ButtonType.CANCEL})) {
            return super.createButton(buttonType);
        }
        Button button = new Button(buttonType.getText());
        ButtonBar.ButtonData buttonData = buttonType.getButtonData();
        ButtonBar.setButtonData((Node)button, (ButtonBar.ButtonData)buttonData);
        button.setDefaultButton(buttonData.isDefaultButton());
        button.setCancelButton(buttonData.isCancelButton());
        return button;
    }
}

