/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.fx.controls;

import com.dua3.utility.fx.FxUtil;
import com.dua3.utility.fx.controls.InputControl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Bounds;
import javafx.geometry.Dimension2D;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jspecify.annotations.Nullable;

public class InputGrid
extends GridPane {
    protected static final Logger LOG = LogManager.getLogger(InputGrid.class);
    private static final String MARKER_INITIAL = "";
    private static final String MARKER_ERROR = "\u26a0";
    private static final String MARKER_OK = "";
    protected final BooleanProperty valid = new SimpleBooleanProperty(false);
    private Collection<Meta<?>> data = null;
    private int columns = 1;

    public ReadOnlyBooleanProperty validProperty() {
        return this.valid;
    }

    public Map<String, Object> get() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        this.data.forEach(e -> result.put(e.id, e.control.get()));
        return result;
    }

    void setContent(Collection<Meta<?>> data, int columns) {
        assert (data != null) : "arg#1 is null";
        this.data = data;
        this.columns = columns;
    }

    public void init() {
        block3: {
            Meta<?> entry2;
            this.getChildren().clear();
            ArrayList controls = new ArrayList();
            Insets insets = new Insets(2.0);
            Insets markerInsets = new Insets(0.0);
            int r = 0;
            int c = 0;
            for (Meta<?> entry2 : this.data) {
                int span;
                int gridX = 3 * c;
                int gridY = r;
                if (entry2.label != null) {
                    this.addToGrid((Node)entry2.label, gridX, gridY, 1, insets);
                    ++gridX;
                    span = 1;
                } else {
                    span = 2;
                }
                controls.add(entry2.control);
                this.addToGrid(entry2.control.node(), gridX, gridY, span, insets);
                this.addToGrid((Node)entry2.marker, gridX += span, gridY, 1, markerInsets);
                entry2.control.init();
                if ((c = (c + 1) % this.columns) != 0) continue;
                ++r;
            }
            this.valid.bind((ObservableValue)Bindings.createBooleanBinding(() -> controls.stream().allMatch(control -> {
                boolean v = control.isValid();
                LOG.info("validate: {} -> {}", control, (Object)v);
                return v;
            }), (Observable[])((Observable[])controls.stream().flatMap(control -> Stream.of(control.valueProperty(), control.validProperty())).toArray(ObservableValue[]::new))));
            Iterator<Meta<?>> iterator = this.data.iterator();
            if (!iterator.hasNext()) break block3;
            entry2 = iterator.next();
            entry2.control.node().requestFocus();
        }
    }

    private void addToGrid(Node child, int c, int r, int span, Insets insets) {
        if (!$assertionsDisabled) {
            if (child == null) {
                throw new AssertionError((Object)"arg#1 is null");
            }
            if (insets == null) {
                throw new AssertionError((Object)"arg#5 is null");
            }
        }
        this.add(child, c, r, span, 1);
        InputGrid.setMargin((Node)child, (Insets)insets);
    }

    public void reset() {
        this.data.forEach(entry -> entry.control.reset());
    }

    static final class Meta<T> {
        final String id;
        final Class<T> cls;
        final Supplier<? extends T> dflt;
        final InputControl<? super T> control;
        final Label label;
        final Label marker;
        static final /* synthetic */ boolean $assertionsDisabled;

        Meta(String id, @Nullable String label, Class<T> cls, Supplier<? extends T> dflt, InputControl<? super T> control) {
            if (!$assertionsDisabled) {
                if (id == null) {
                    throw new AssertionError((Object)"arg#1 is null");
                }
                if (cls == null) {
                    throw new AssertionError((Object)"arg#3 is null");
                }
                if (dflt == null) {
                    throw new AssertionError((Object)"arg#4 is null");
                }
                if (control == null) {
                    throw new AssertionError((Object)"arg#5 is null");
                }
            }
            this.marker = new Label();
            this.id = id;
            this.label = label != null ? new Label(label) : null;
            this.cls = cls;
            this.dflt = dflt;
            this.control = control;
            Dimension2D dimMarker = new Dimension2D(0.0, 0.0);
            dimMarker = FxUtil.growToFit((Dimension2D)dimMarker, (Bounds)this.marker.getBoundsInLocal());
            this.marker.setMinSize(dimMarker.getWidth(), dimMarker.getHeight());
            this.marker.setText("");
        }

        void reset() {
            this.control.set(this.dflt.get());
        }

        static {
            $assertionsDisabled = !Meta.class.desiredAssertionStatus();
        }
    }
}

