/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.fx.controls;

import com.dua3.utility.fx.controls.ComboBoxEx;
import com.dua3.utility.fx.controls.FileDialogMode;
import com.dua3.utility.fx.controls.FileInput;
import com.dua3.utility.fx.controls.InputBuilder;
import com.dua3.utility.fx.controls.InputControl;
import com.dua3.utility.fx.controls.InputGrid;
import com.dua3.utility.fx.controls.OptionsPane;
import com.dua3.utility.fx.controls.RadioPane;
import com.dua3.utility.lang.LangUtil;
import com.dua3.utility.options.Arguments;
import com.dua3.utility.options.Option;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.scene.Node;
import javafx.stage.FileChooser;
import org.jspecify.annotations.Nullable;

public class InputGridBuilder
implements InputBuilder<InputGridBuilder> {
    private final LinkedHashMap<String, InputGrid.Meta<?>> data = new LinkedHashMap();
    private int columns = 1;

    InputGridBuilder() {
    }

    public InputGrid build() {
        InputGrid grid = new InputGrid();
        grid.setContent(this.data.values(), this.columns);
        return grid;
    }

    @Override
    public <T> InputGridBuilder add(String id, String label, Class<T> type, Supplier<T> dflt, InputControl<T> control) {
        if (id == null) {
            throw new NullPointerException("arg#1 is null");
        }
        if (label == null) {
            throw new NullPointerException("arg#2 is null");
        }
        if (type == null) {
            throw new NullPointerException("arg#3 is null");
        }
        if (dflt == null) {
            throw new NullPointerException("arg#4 is null");
        }
        if (control == null) {
            throw new NullPointerException("arg#5 is null");
        }
        return this.doAdd(id, label, type, dflt, control);
    }

    @Override
    public <T> InputGridBuilder add(String id, Class<T> type, Supplier<T> dflt, InputControl<T> control) {
        if (id == null) {
            throw new NullPointerException("arg#1 is null");
        }
        if (type == null) {
            throw new NullPointerException("arg#2 is null");
        }
        if (dflt == null) {
            throw new NullPointerException("arg#3 is null");
        }
        if (control == null) {
            throw new NullPointerException("arg#4 is null");
        }
        return this.doAdd(id, null, type, dflt, control);
    }

    private <T> InputGridBuilder doAdd(String id, @Nullable String label, Class<T> type, Supplier<T> dflt, InputControl<T> control) {
        InputGrid.Meta<T> meta;
        InputGrid.Meta<T> prev;
        if (!$assertionsDisabled) {
            if (id == null) {
                throw new AssertionError((Object)"arg#1 is null");
            }
            if (type == null) {
                throw new AssertionError((Object)"arg#3 is null");
            }
            if (dflt == null) {
                throw new AssertionError((Object)"arg#4 is null");
            }
            if (control == null) {
                throw new AssertionError((Object)"arg#5 is null");
            }
        }
        LangUtil.check(((prev = this.data.put(id, meta = new InputGrid.Meta<T>(id, label, type, dflt, control))) == null ? 1 : 0) != 0, (String)("Input with id '" + id + "' already defined"), (Object[])new Object[0]);
        return this;
    }

    @Override
    public InputGridBuilder addNode(String id, @Nullable String label, Node node) {
        if (id == null) {
            throw new NullPointerException("arg#1 is null");
        }
        if (node == null) {
            throw new NullPointerException("arg#3 is null");
        }
        InputGrid.Meta<Void> meta = new InputGrid.Meta<Void>(id, label, Void.class, null, new ControlWrapper(node));
        InputGrid.Meta<Void> prev = this.data.put(id, meta);
        LangUtil.check((prev == null ? 1 : 0) != 0, (String)("Input with id '" + id + "' already defined"), (Object[])new Object[0]);
        return this;
    }

    @Override
    public InputGridBuilder addNode(String id, Node node) {
        if (id == null) {
            throw new NullPointerException("arg#1 is null");
        }
        if (node == null) {
            throw new NullPointerException("arg#2 is null");
        }
        InputGrid.Meta<Void> meta = new InputGrid.Meta<Void>(id, null, Void.class, null, new ControlWrapper(node));
        InputGrid.Meta<Void> prev = this.data.put(id, meta);
        LangUtil.check((prev == null ? 1 : 0) != 0, (String)("Input with id '" + id + "' already defined"), (Object[])new Object[0]);
        return this;
    }

    @Override
    public InputGridBuilder columns(int columns) {
        this.columns = LangUtil.requirePositive((int)columns);
        return this;
    }

    @Override
    public InputGridBuilder string(String id, String label, Supplier<String> dflt, Function<String, Optional<String>> validate) {
        if (id == null) {
            throw new NullPointerException("arg#1 is null");
        }
        if (label == null) {
            throw new NullPointerException("arg#2 is null");
        }
        if (dflt == null) {
            throw new NullPointerException("arg#3 is null");
        }
        if (validate == null) {
            throw new NullPointerException("arg#4 is null");
        }
        return this.add(id, label, String.class, (Supplier)dflt, InputControl.stringInput(dflt, validate));
    }

    @Override
    public InputGridBuilder integer(String id, String label, Supplier<Integer> dflt, Function<Integer, Optional<String>> validate) {
        if (id == null) {
            throw new NullPointerException("arg#1 is null");
        }
        if (label == null) {
            throw new NullPointerException("arg#2 is null");
        }
        if (dflt == null) {
            throw new NullPointerException("arg#3 is null");
        }
        if (validate == null) {
            throw new NullPointerException("arg#4 is null");
        }
        return this.add(id, label, Integer.class, (Supplier)dflt, InputControl.integerInput(dflt, validate));
    }

    @Override
    public InputGridBuilder decimal(String id, String label, Supplier<Double> dflt, Function<Double, Optional<String>> validate) {
        if (id == null) {
            throw new NullPointerException("arg#1 is null");
        }
        if (label == null) {
            throw new NullPointerException("arg#2 is null");
        }
        if (dflt == null) {
            throw new NullPointerException("arg#3 is null");
        }
        if (validate == null) {
            throw new NullPointerException("arg#4 is null");
        }
        return this.add(id, label, Double.class, (Supplier)dflt, InputControl.decimalInput(dflt, validate));
    }

    @Override
    public InputGridBuilder checkBox(String id, String label, Supplier<Boolean> dflt, String text, Function<Boolean, Optional<String>> validate) {
        if (id == null) {
            throw new NullPointerException("arg#1 is null");
        }
        if (label == null) {
            throw new NullPointerException("arg#2 is null");
        }
        if (dflt == null) {
            throw new NullPointerException("arg#3 is null");
        }
        if (text == null) {
            throw new NullPointerException("arg#4 is null");
        }
        if (validate == null) {
            throw new NullPointerException("arg#5 is null");
        }
        return this.add(id, label, Boolean.class, (Supplier)dflt, InputControl.checkBoxInput(dflt, text, validate));
    }

    @Override
    public <T> InputGridBuilder comboBox(String id, String label, Supplier<T> dflt, Class<T> cls, Collection<T> items, Function<T, Optional<String>> validate) {
        if (id == null) {
            throw new NullPointerException("arg#1 is null");
        }
        if (label == null) {
            throw new NullPointerException("arg#2 is null");
        }
        if (dflt == null) {
            throw new NullPointerException("arg#3 is null");
        }
        if (cls == null) {
            throw new NullPointerException("arg#4 is null");
        }
        if (items == null) {
            throw new NullPointerException("arg#5 is null");
        }
        if (validate == null) {
            throw new NullPointerException("arg#6 is null");
        }
        return this.add(id, label, (Class)cls, (Supplier)dflt, InputControl.comboBoxInput(items, dflt, validate));
    }

    @Override
    public <T> InputGridBuilder comboBoxEx(String id, String label, @Nullable UnaryOperator<T> edit, @Nullable Supplier<T> add, @Nullable BiPredicate<ComboBoxEx<T>, T> remove, Function<T, String> format, Supplier<T> dflt, Class<T> cls, Collection<T> items, Function<T, Optional<String>> validate) {
        if (id == null) {
            throw new NullPointerException("arg#1 is null");
        }
        if (label == null) {
            throw new NullPointerException("arg#2 is null");
        }
        if (format == null) {
            throw new NullPointerException("arg#6 is null");
        }
        if (dflt == null) {
            throw new NullPointerException("arg#7 is null");
        }
        if (cls == null) {
            throw new NullPointerException("arg#8 is null");
        }
        if (items == null) {
            throw new NullPointerException("arg#9 is null");
        }
        if (validate == null) {
            throw new NullPointerException("arg#10 is null");
        }
        return this.add(id, label, (Class)cls, (Supplier)dflt, InputControl.comboBoxExInput(items, dflt, edit, add, remove, format, validate));
    }

    @Override
    public <T> InputGridBuilder radioList(String id, String label, Supplier<T> dflt, Class<T> cls, Collection<T> items, Function<T, Optional<String>> validate) {
        if (id == null) {
            throw new NullPointerException("arg#1 is null");
        }
        if (label == null) {
            throw new NullPointerException("arg#2 is null");
        }
        if (dflt == null) {
            throw new NullPointerException("arg#3 is null");
        }
        if (cls == null) {
            throw new NullPointerException("arg#4 is null");
        }
        if (items == null) {
            throw new NullPointerException("arg#5 is null");
        }
        if (validate == null) {
            throw new NullPointerException("arg#6 is null");
        }
        return this.add(id, label, (Class)cls, (Supplier)dflt, (InputControl)new RadioPane<Object>(items, null, validate));
    }

    @Override
    public InputGridBuilder options(String id, String label, Supplier<Arguments> dflt, Supplier<Collection<Option<?>>> options) {
        if (id == null) {
            throw new NullPointerException("arg#1 is null");
        }
        if (label == null) {
            throw new NullPointerException("arg#2 is null");
        }
        if (dflt == null) {
            throw new NullPointerException("arg#3 is null");
        }
        if (options == null) {
            throw new NullPointerException("arg#4 is null");
        }
        return this.add(id, label, Arguments.class, (Supplier)dflt, (InputControl)new OptionsPane(options, dflt));
    }

    @Override
    public InputGridBuilder options(String id, Supplier<Arguments> dflt, Supplier<Collection<Option<?>>> options) {
        if (id == null) {
            throw new NullPointerException("arg#1 is null");
        }
        if (dflt == null) {
            throw new NullPointerException("arg#2 is null");
        }
        if (options == null) {
            throw new NullPointerException("arg#3 is null");
        }
        return this.add(id, Arguments.class, (Supplier)dflt, (InputControl)new OptionsPane(options, dflt));
    }

    @Override
    public InputGridBuilder chooseFile(String id, String label, Supplier<Path> dflt, FileDialogMode mode, boolean existingOnly, Collection<FileChooser.ExtensionFilter> filter, Function<Path, Optional<String>> validate) {
        if (id == null) {
            throw new NullPointerException("arg#1 is null");
        }
        if (label == null) {
            throw new NullPointerException("arg#2 is null");
        }
        if (dflt == null) {
            throw new NullPointerException("arg#3 is null");
        }
        if (mode == null) {
            throw new NullPointerException("arg#4 is null");
        }
        if (filter == null) {
            throw new NullPointerException("arg#6 is null");
        }
        if (validate == null) {
            throw new NullPointerException("arg#7 is null");
        }
        return this.add(id, label, Path.class, (Supplier)dflt, (InputControl)new FileInput(mode, existingOnly, dflt, filter, validate));
    }

    static class ControlWrapper
    implements InputControl<Void> {
        private final Node node;
        private final Property<Void> value;
        private final BooleanProperty valid;
        private final ReadOnlyStringProperty error;
        static final /* synthetic */ boolean $assertionsDisabled;

        ControlWrapper(Node node) {
            if (!$assertionsDisabled && node == null) {
                throw new AssertionError((Object)"arg#1 is null");
            }
            this.value = new SimpleObjectProperty(null);
            this.valid = new SimpleBooleanProperty(true);
            this.error = new SimpleStringProperty("");
            this.node = node;
        }

        @Override
        public Node node() {
            return this.node;
        }

        @Override
        public Property<Void> valueProperty() {
            return this.value;
        }

        @Override
        public void reset() {
        }

        @Override
        public ReadOnlyBooleanProperty validProperty() {
            return this.valid;
        }

        @Override
        public ReadOnlyStringProperty errorProperty() {
            return this.error;
        }

        static {
            $assertionsDisabled = !ControlWrapper.class.desiredAssertionStatus();
        }
    }
}

