/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.fx.controls;

import com.dua3.utility.data.Pair;
import com.dua3.utility.fx.FxUtil;
import com.dua3.utility.fx.PlatformHelper;
import com.dua3.utility.fx.controls.PinBoardSkin;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Supplier;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Dimension2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Skin;

public class PinBoard
extends Control {
    final ObservableList<Item> items = FXCollections.observableArrayList();
    private final ObjectProperty<Rectangle2D> areaProperty = new SimpleObjectProperty((Object)new Rectangle2D(0.0, 0.0, 0.0, 0.0));

    public void setHbarPolicy(ScrollPane.ScrollBarPolicy policy) {
        if (policy == null) {
            throw new NullPointerException("arg#1 is null");
        }
        Skin skin = this.getSkin();
        if (skin instanceof PinBoardSkin) {
            PinBoardSkin skin2 = (PinBoardSkin)skin;
            skin2.setHbarPolicy(policy);
        }
    }

    public void setVbarPolicy(ScrollPane.ScrollBarPolicy policy) {
        if (policy == null) {
            throw new NullPointerException("arg#1 is null");
        }
        Skin skin = this.getSkin();
        if (skin instanceof PinBoardSkin) {
            PinBoardSkin skin2 = (PinBoardSkin)skin;
            skin2.setVbarPolicy(policy);
        }
    }

    public void clear() {
        PlatformHelper.checkApplicationThread();
        this.items.clear();
        this.areaProperty.set((Object)new Rectangle2D(0.0, 0.0, 0.0, 0.0));
    }

    public void refresh() {
        Skin skin = this.getSkin();
        if (skin instanceof PinBoardSkin) {
            PinBoardSkin skin2 = (PinBoardSkin)skin;
            skin2.refresh();
        }
    }

    public void dispose() {
        Skin skin = this.getSkin();
        if (skin instanceof PinBoardSkin) {
            PinBoardSkin skin2 = (PinBoardSkin)skin;
            skin2.dispose();
        }
    }

    protected Skin<PinBoard> createDefaultSkin() {
        return new PinBoardSkin(this);
    }

    public ReadOnlyObjectProperty<Rectangle2D> areaProperty() {
        return this.areaProperty;
    }

    public ObservableList<Item> getItems() {
        return FXCollections.unmodifiableObservableList(this.items);
    }

    public Pair<Double, Double> getScrollPosition() {
        Skin skin = this.getSkin();
        if (skin instanceof PinBoardSkin) {
            PinBoardSkin skin2 = (PinBoardSkin)skin;
            return skin2.getScrollPosition();
        }
        return Pair.of((Object)0.0, (Object)0.0);
    }

    public void setScrollPosition(double hValue, double vValue) {
        Skin skin = this.getSkin();
        if (skin instanceof PinBoardSkin) {
            PinBoardSkin skin2 = (PinBoardSkin)skin;
            skin2.setScrollPosition(hValue, vValue);
        }
    }

    public void setScrollPosition(Pair<Double, Double> scrollPosition) {
        if (scrollPosition == null) {
            throw new NullPointerException("arg#1 is null");
        }
        this.setScrollPosition((Double)scrollPosition.first(), (Double)scrollPosition.second());
    }

    public void scrollTo(PositionInItem pos) {
        if (pos == null) {
            throw new NullPointerException("arg#1 is null");
        }
        Skin skin = this.getSkin();
        if (skin instanceof PinBoardSkin) {
            PinBoardSkin skin2 = (PinBoardSkin)skin;
            skin2.scrollTo(pos);
        }
    }

    public Optional<Item> getItemAt(double x, double y) {
        return this.getPositionInItem(x, y).map(PositionInItem::item);
    }

    public Optional<PositionInItem> getPositionInItem(double x, double y) {
        Skin skin = this.getSkin();
        if (skin instanceof PinBoardSkin) {
            PinBoardSkin skin2 = (PinBoardSkin)skin;
            return skin2.getPositionInItem(x, y);
        }
        return Optional.empty();
    }

    public void pinBottom(String name, Supplier<Node> nodeSupplier, Dimension2D dimension) {
        if (name == null) {
            throw new NullPointerException("arg#1 is null");
        }
        if (nodeSupplier == null) {
            throw new NullPointerException("arg#2 is null");
        }
        if (dimension == null) {
            throw new NullPointerException("arg#3 is null");
        }
        Rectangle2D boardArea = this.getArea();
        double xCenter = (boardArea.getMaxX() + boardArea.getMinX()) / 2.0;
        double y = boardArea.getMaxY();
        Rectangle2D area = new Rectangle2D(xCenter - dimension.getWidth() / 2.0, y, dimension.getWidth(), dimension.getHeight());
        this.pin(new Item(name, area, nodeSupplier));
    }

    public Rectangle2D getArea() {
        return (Rectangle2D)this.areaProperty.get();
    }

    public void pin(Item item) {
        if (item == null) {
            throw new NullPointerException("arg#1 is null");
        }
        this.pin(Collections.singleton(item));
    }

    public void pin(Collection<Item> itemsToPin) {
        if (itemsToPin == null) {
            throw new NullPointerException("arg#1 is null");
        }
        PlatformHelper.checkApplicationThread();
        if (itemsToPin.isEmpty()) {
            return;
        }
        this.items.addAll(itemsToPin);
        itemsToPin.stream().map(Item::area).reduce(FxUtil::union).map(r -> FxUtil.union((Rectangle2D)this.getArea(), (Rectangle2D)r)).ifPresent(r -> {
            if (!r.equals((Object)this.getArea())) {
                this.areaProperty.set(r);
            }
        });
    }

    public String toString() {
        return "PinBoard{area=" + this.areaProperty.get() + ", items=" + this.items + "}";
    }

    public record PositionInItem(Item item, double x, double y) {
        public PositionInItem {
            if (item == null) {
                throw new NullPointerException("item is null");
            }
        }
    }

    public record Item(String name, Rectangle2D area, Supplier<Node> nodeBuilder) {
        public Item {
            if (name == null) {
                throw new NullPointerException("name is null");
            }
            if (area == null) {
                throw new NullPointerException("area is null");
            }
            if (nodeBuilder == null) {
                throw new NullPointerException("nodeBuilder is null");
            }
        }
    }
}

