/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.fx.controls;

import com.dua3.utility.data.Pair;
import com.dua3.utility.fx.FxRefresh;
import com.dua3.utility.fx.PlatformHelper;
import com.dua3.utility.fx.controls.PinBoard;
import com.dua3.utility.lang.LangUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javafx.geometry.Bounds;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.AnchorPane;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class PinBoardSkin
extends SkinBase<PinBoard> {
    private static final Logger LOG = LogManager.getLogger(PinBoardSkin.class);
    private final FxRefresh refresher;
    private final AnchorPane pane;
    private final ScrollPane scrollPane;

    PinBoardSkin(PinBoard pinBoard) {
        assert (pinBoard != null) : "arg#1 is null";
        super((Control)pinBoard);
        this.pane = new AnchorPane();
        this.scrollPane = new ScrollPane((Node)this.pane);
        this.refresher = FxRefresh.create((String)LangUtil.defaultToString((Object)((Object)this)), () -> PlatformHelper.runLater(this::updateNodes), (Node)pinBoard);
        this.scrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        this.scrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        this.scrollPane.setPannable(true);
        this.getChildren().setAll((Object[])new Node[]{this.scrollPane});
        pinBoard.areaProperty().addListener((v, o, n) -> {
            this.pane.setMinWidth(n.getWidth());
            this.pane.setMinHeight(n.getHeight());
        });
        pinBoard.getItems().addListener(c -> this.refresh());
        this.pane.layoutBoundsProperty().addListener(o -> this.refresh());
        this.scrollPane.hvalueProperty().addListener(h -> this.refresh());
        this.scrollPane.vvalueProperty().addListener(v -> this.refresh());
        this.scrollPane.widthProperty().addListener(e -> this.refresh());
        this.scrollPane.heightProperty().addListener(e -> this.refresh());
        this.scrollPane.viewportBoundsProperty().addListener((v, o, n) -> this.refresh());
        this.refresher.setActive(true);
    }

    private void updateNodes() {
        LOG.trace("updateNodes()");
        PlatformHelper.checkApplicationThread();
        PinBoard board = (PinBoard)this.getSkinnable();
        Rectangle2D viewPort = this.getViewPort();
        Rectangle2D boardArea = board.getArea();
        double dx = Math.max(0.0, viewPort.getWidth() - boardArea.getWidth()) / 2.0 - boardArea.getMinX();
        double dy = Math.max(0.0, viewPort.getHeight() - boardArea.getHeight()) / 2.0 - boardArea.getMinY();
        Rectangle2D viewportInLocal = new Rectangle2D(viewPort.getMinX() + boardArea.getMinX(), viewPort.getMinY() + boardArea.getMinY(), viewPort.getWidth(), viewPort.getHeight());
        List<Node> nodes = new ArrayList<PinBoard.Item>((Collection<PinBoard.Item>)board.items).stream().filter(item -> item.area().intersects(viewportInLocal)).map(item -> {
            LOG.debug("item is visible: {}", (Object)item.name());
            Rectangle2D itemArea = item.area();
            Node node = item.nodeBuilder().get();
            node.setTranslateX(dx + itemArea.getMinX());
            node.setTranslateY(dy + itemArea.getMinY());
            return node;
        }).toList();
        this.pane.setMinWidth(boardArea.getWidth());
        this.pane.setMinHeight(boardArea.getHeight());
        this.pane.getChildren().setAll(nodes);
    }

    void refresh() {
        this.refresher.refresh();
    }

    private Rectangle2D getViewPort() {
        Bounds vpBounds = this.scrollPane.getViewportBounds();
        return new Rectangle2D(-vpBounds.getMinX(), -vpBounds.getMinY(), vpBounds.getWidth(), vpBounds.getHeight());
    }

    public void dispose() {
        this.refresher.stop();
        super.dispose();
    }

    public Pair<Double, Double> getScrollPosition() {
        return Pair.of((Object)this.scrollPane.getHvalue(), (Object)this.scrollPane.getVvalue());
    }

    public void setScrollPosition(double hValue, double vValue) {
        this.scrollPane.setHvalue(hValue);
        this.scrollPane.setVvalue(vValue);
    }

    public Optional<PinBoard.PositionInItem> getPositionInItem(double xViewport, double yViewport) {
        Rectangle2D vp = this.getViewPort();
        double x = xViewport + vp.getMinX();
        double y = yViewport + vp.getMinY();
        Rectangle2D b = ((PinBoard)this.getSkinnable()).getArea();
        ArrayList<PinBoard.Item> items = new ArrayList<PinBoard.Item>((Collection<PinBoard.Item>)((PinBoard)this.getSkinnable()).getItems());
        for (PinBoard.Item item : items) {
            Rectangle2D a = item.area();
            if (!a.contains(x, y)) continue;
            return Optional.of(new PinBoard.PositionInItem(item, x + b.getMinX() - a.getMinX(), y + b.getMinY() - a.getMinY()));
        }
        return Optional.empty();
    }

    public void scrollTo(PinBoard.PositionInItem pos) {
        if (pos == null) {
            throw new NullPointerException("arg#1 is null");
        }
        LOG.debug("scrollTo({})", (Object)pos);
        Rectangle2D area = pos.item().area();
        double xBoard = area.getMinX() + pos.x();
        double yBoard = area.getMinY() + pos.y();
        this.scrollToBoardCoordinates(xBoard, yBoard);
    }

    public void scrollToBoardCoordinates(double xBoard, double yBoard) {
        LOG.debug("scrollToBoardCoordinates({}, {})", (Object)xBoard, (Object)yBoard);
        Rectangle2D boardArea = ((PinBoard)this.getSkinnable()).getArea();
        if (boardArea.getWidth() == 0.0 || boardArea.getHeight() == 0.0) {
            return;
        }
        Bounds viewportBounds = this.scrollPane.getViewportBounds();
        double sx = PinBoardSkin.calcScrollPosition(xBoard, boardArea.getMinX(), boardArea.getMaxX(), viewportBounds.getWidth());
        double sy = PinBoardSkin.calcScrollPosition(yBoard, boardArea.getMinY(), boardArea.getMaxY(), viewportBounds.getHeight());
        this.setScrollPosition(sx, sy);
    }

    private static double calcScrollPosition(double c, double tMin, double tMax, double viewableSize) {
        double totalSize = tMax - tMin;
        double scrollableSize = totalSize - viewableSize;
        if (scrollableSize <= 0.0) {
            return 0.0;
        }
        if (c >= scrollableSize) {
            return 1.0;
        }
        return (c - tMin) / scrollableSize;
    }

    public void setHbarPolicy(ScrollPane.ScrollBarPolicy policy) {
        if (policy == null) {
            throw new NullPointerException("arg#1 is null");
        }
        this.scrollPane.setHbarPolicy(policy);
    }

    public void setVbarPolicy(ScrollPane.ScrollBarPolicy policy) {
        if (policy == null) {
            throw new NullPointerException("arg#1 is null");
        }
        this.scrollPane.setVbarPolicy(policy);
    }
}

